/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.vc;

import com.urbancode.air.vc.PersistentRecord;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="vc_latest_version_entry")
public class LatestVersionEntry {
    @Id
    @NotNull
    @Column(name="path")
    @Length(min=1, max=255)
    private String path;
    @NotNull
    @ManyToOne
    @JoinColumn(name="persistent_record_id")
    private PersistentRecord record;
    @NotNull
    @Column(name="relative_version")
    private Integer relativeVersion;
    @NotNull
    @Column(name="deleted")
    @Type(type="yes_no")
    private Boolean deleted;
    @NotNull
    @Column(name="directory")
    @Length(min=1, max=255)
    private String directory;
    @NotNull
    @Column(name="commit_id")
    private Long commit;

    private LatestVersionEntry() {
    }

    public LatestVersionEntry(PersistentRecord record) {
        this.record = record;
        this.path = record.getPath();
        this.relativeVersion = record.getRelativeVersion();
        this.deleted = record.isDeleted();
        this.directory = record.getDirectory();
        this.commit = record.getCommitNumber();
    }

    protected String getPath() {
        return this.path;
    }

    protected PersistentRecord getPersistentRecord() {
        return this.record;
    }

    protected void setPersistentRecord(PersistentRecord record) {
        this.record = record;
    }

    protected Integer getRelativeVersion() {
        return this.relativeVersion;
    }

    protected void setRelativeVersion(int version) {
        this.relativeVersion = version;
    }

    protected Boolean isDeleted() {
        return this.deleted;
    }

    protected void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    protected Long getCommitNumber() {
        return this.commit;
    }

    protected void setCommitNumber(Long commit) {
        this.commit = commit;
    }

    protected String getDirectory() {
        return this.directory;
    }

    protected void setDirectory(String directory) {
        this.directory = directory;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof LatestVersionEntry) {
            LatestVersionEntry other = (LatestVersionEntry)obj;
            result = other.path.equals(this.path) && other.record.equals(this.record);
        }
        return result;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 31 + this.getClass().hashCode();
        hash = hash * 31 + this.path.hashCode();
        hash = hash * 31 + this.record.hashCode();
        return hash;
    }
}

