/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.vc;

import com.urbancode.air.vc.Commit;
import com.urbancode.air.vc.Handle;
import com.urbancode.air.vc.PersistenceData;
import com.urbancode.air.vc.Persistent;
import com.urbancode.air.vc.PersistentReader;
import com.urbancode.air.vc.PersistentRecord;
import com.urbancode.air.vc.Repository;
import com.urbancode.air.vc.Transaction;
import com.urbancode.air.vc.VersionedObjectLoadLimitExceededException;
import com.urbancode.air.vc.metadata.RecordMetadataCondition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.hibernate.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session {
    private static final Logger log = Logger.getLogger(Session.class);
    private Repository repository;
    private int maxSessionSize;
    private Map<String, SortedSet<Integer>> path2versions = new HashMap<String, SortedSet<Integer>>();
    private Map<Handle, Persistent> handle2trackedPersistents = new LinkedHashMap<Handle, Persistent>();
    private List<String> purgedPaths = new ArrayList<String>();
    private Transaction transaction = null;
    private Map<String, Integer> latestVersionCache = new HashMap<String, Integer>();
    private boolean isDebugEnabled;
    private boolean isTraceEnabled;

    Session(Repository repository, int maxSessionSize) {
        this.repository = repository;
        this.maxSessionSize = maxSessionSize;
        this.isDebugEnabled = log.isDebugEnabled();
        this.isTraceEnabled = log.isTraceEnabled();
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Transaction beginTransaction() {
        if (this.transaction == null) {
            this.transaction = new Transaction(this);
        } else if (this.isDebugEnabled) {
            log.debug((Object)"Started a transaction when one was already active. Extending the current session.");
        }
        return this.transaction;
    }

    public Transaction getCurrentTransaction() {
        return this.transaction;
    }

    void unbindTransaction() {
        this.transaction = null;
    }

    public void saveOrUpdate(Persistent p) {
        Handle h;
        Persistent tracked;
        PersistenceData persistenceData = p.getPersistenceData();
        String path = persistenceData.getPath();
        if (path == null) {
            throw new IllegalArgumentException("Cannot persist a Persistent which has no path.");
        }
        if (persistenceData.getRelativeVersion() == 0) {
            persistenceData.setRelativeVersion(1);
            persistenceData.setVersionCount(1);
        }
        if ((tracked = this.handle2trackedPersistents.remove(h = new Handle(p))) != null) {
            SortedSet<Integer> versions = this.path2versions.remove(path);
            if (versions != null) {
                versions.remove(h.getVersion());
                if (!versions.isEmpty()) {
                    this.path2versions.put(path, versions);
                }
            }
            if (this.isDebugEnabled) {
                log.debug((Object)("Overwriting version of " + path + " currently in session cache."));
            }
        }
        this.trackPersistent(p);
    }

    public void purgePersistentForPath(String path) {
        org.hibernate.Session hibernateSession = this.repository.getTxManager().getSession();
        Handle handle = new Handle(path, -1);
        Persistent p = this.restore(handle);
        PersistenceData persistenceData = p.getPersistenceData();
        if (persistenceData.isDirty()) {
            throw new IllegalArgumentException("Cannot purge persistent " + path + " because it has been modified.");
        }
        Query metadataQuery = hibernateSession.createQuery("delete from GenericRecordMetadata meta   where exists        (select 1 from PersistentRecord rec            where meta.record=rec and rec.path=:path)");
        metadataQuery.setParameter("path", (Object)path);
        metadataQuery.executeUpdate();
        Query lveQuery = hibernateSession.createQuery("delete from LatestVersionEntry where path=:path");
        lveQuery.setParameter("path", (Object)path);
        lveQuery.executeUpdate();
        Query persistentQuery = hibernateSession.createQuery("delete from PersistentRecord where path=:path");
        persistentQuery.setParameter("path", (Object)path);
        persistentQuery.executeUpdate();
        this.purgedPaths.add(path);
    }

    List<String> getPurgedPaths() {
        return this.purgedPaths;
    }

    @Deprecated
    public <T extends Persistent> T restore(Class<T> clazz, String path) {
        PersistentReader reader = new PersistentReader(this.repository);
        Object result = reader.readPersistent(clazz, path = new Handle(path, -1).getPath());
        result = result != null ? this.filterFromCacheOrTrack((Persistent)result) : this.getUnsavedPersistentFromCache(path);
        return result;
    }

    @Deprecated
    public <T extends Persistent> T restore(Class<T> clazz, String path, int version) {
        path = new Handle(path, -1).getPath();
        PersistentReader reader = new PersistentReader(this.repository);
        Object result = version <= 0 ? reader.readPersistent(clazz, path) : reader.readPersistent(clazz, path, version);
        if (result != null) {
            result = this.filterFromCacheOrTrack((Persistent)result);
        } else if (version <= 0) {
            result = this.getUnsavedPersistentFromCache(path);
        }
        return result;
    }

    public List<Persistent> restoreForHandlesIntoList(List<Handle> handles, boolean skipVersionCount) {
        PersistentReader reader = new PersistentReader(this.repository);
        Collection<Persistent> collection = reader.getPersistentMapForHandles(handles, skipVersionCount).values();
        ArrayList<Persistent> result = new ArrayList<Persistent>(collection);
        for (int i = 0; i < result.size(); ++i) {
            result.set(i, this.filterFromCacheOrTrack((Persistent)result.get(i)));
        }
        return result;
    }

    public Map<Handle, Persistent> restoreForHandlesIntoMap(Collection<Handle> handles, boolean skipVersionCount) {
        PersistentReader reader = new PersistentReader(this.repository);
        if (this.isDebugEnabled) {
            log.debug((Object)("restoreForHandlesInMap for " + handles.size() + " handles."));
        }
        HashMap<Handle, Persistent> resolved = new HashMap<Handle, Persistent>();
        ArrayList<Handle> unresolvedHandles = new ArrayList<Handle>();
        for (Handle handle : handles) {
            Persistent p = handle.getVersion() != null && handle.getVersion() == -1 ? this.getUnsavedPersistentFromCache(handle.getPath()) : this.handle2trackedPersistents.get(handle);
            if (p != null) {
                resolved.put(handle, p);
                continue;
            }
            unresolvedHandles.add(handle);
        }
        if (this.isDebugEnabled) {
            log.debug((Object)(resolved.size() + " resolved, " + unresolvedHandles.size() + " unresolved."));
        }
        Map<Handle, Persistent> result = reader.getPersistentMapForHandles(unresolvedHandles, skipVersionCount);
        for (Handle handle : result.keySet()) {
            Persistent persistent = result.get(handle);
            resolved.put(handle, this.filterFromCacheOrTrack(persistent));
        }
        return resolved;
    }

    public List<Persistent> restoreLatestWithPaths(List<String> paths, boolean skipVersionCount) {
        PersistentReader reader = new PersistentReader(this.repository);
        List<Persistent> result = reader.readLatestWithPaths(paths, skipVersionCount);
        for (int i = 0; i < result.size(); ++i) {
            result.set(i, this.filterFromCacheOrTrack(result.get(i)));
        }
        return result;
    }

    public Persistent readLatestWithPath(String path, boolean skipVersionCount) {
        PersistentReader persistentReader = new PersistentReader(this.repository);
        return persistentReader.readLatestWithPath(path, skipVersionCount);
    }

    public Persistent restore(Handle handle) {
        if (this.isTraceEnabled) {
            log.trace((Object)String.format("Restoring object with handle '%s'", handle.toString()));
        }
        PersistentReader reader = new PersistentReader(this.repository, this);
        Persistent result = null;
        if (handle.getVersion() != null && handle.getVersion() == -1) {
            result = this.getUnsavedPersistentFromCache(handle.getPath());
        } else if (this.isTraceEnabled) {
            if (handle.getVersion() == null) {
                log.trace((Object)"handle version is null");
            } else {
                log.trace((Object)String.format("Handle version %d does not equal -1", handle.getVersion()));
            }
        }
        if (result == null) {
            result = reader.readPersistentForHandle(handle);
        } else if (this.isTraceEnabled) {
            log.trace((Object)"Persistent restored from cach skipping db check");
        }
        if (result != null) {
            result = this.filterFromCacheOrTrack(result);
        } else if (this.isTraceEnabled) {
            log.trace((Object)String.format("No result returned from readPersistentForhandle '%s'", handle.toString()));
        }
        return result;
    }

    public Map<String, Integer> getLatestVersionsForPathLike(String partialPath) {
        return this.getLatestVersionsForPathLike(partialPath, true);
    }

    public Map<String, Integer> getLatestVersionsForPathLike(String partialPath, boolean excludeDeleted) {
        PersistentReader reader = new PersistentReader(this.repository);
        return reader.getLatestVersionsForPathLike(partialPath, excludeDeleted);
    }

    public List<Persistent> getLatestPersistentsWithAllMetadata(RecordMetadataCondition ... conditions) {
        return this.getLatestPersistentsWithAllMetadata(false, conditions);
    }

    public Persistent getLatestPersistentWithAllMetadata(boolean excludeDeleted, RecordMetadataCondition ... conditions) throws RuntimeException {
        PersistentReader reader = new PersistentReader(this.repository);
        Persistent restoredPersistent = reader.getLatestPersistentWithAllMetadata(excludeDeleted, conditions);
        Persistent result = null;
        if (restoredPersistent != null) {
            result = this.filterFromCacheOrTrack(restoredPersistent);
        }
        return result;
    }

    public List<Persistent> getLatestPersistentsWithAllMetadata(boolean excludeDeleted, RecordMetadataCondition ... conditions) {
        ArrayList<Persistent> result = new ArrayList<Persistent>();
        PersistentReader reader = new PersistentReader(this.repository);
        List<Persistent> restoredPersistents = reader.getLatestPersistentsWithAllMetadata(excludeDeleted, conditions);
        for (Persistent persistent : restoredPersistents) {
            result.add(this.filterFromCacheOrTrack(persistent));
        }
        return result;
    }

    public List<Persistent> getLatestPersistentsWithAllMetadataInPath(String path, RecordMetadataCondition ... conditions) {
        return this.getLatestPersistentsWithAllMetadataInPath(path, false, conditions);
    }

    public List<Persistent> getLatestPersistentsWithAllMetadataInPath(String path, boolean excludeDeleted, RecordMetadataCondition ... conditions) {
        ArrayList<Persistent> result = new ArrayList<Persistent>();
        PersistentReader reader = new PersistentReader(this.repository);
        List<Persistent> restoredPersistents = reader.getLatestPersistentsWithAllMetadataInPath(path, excludeDeleted, conditions);
        for (Persistent persistent : restoredPersistents) {
            result.add(this.filterFromCacheOrTrack(persistent));
        }
        return result;
    }

    public Persistent getLatestPersistentWithAllMetadataInPath(String path, boolean excludeDeleted, RecordMetadataCondition ... conditions) {
        PersistentReader reader = new PersistentReader(this.repository);
        Persistent restoredPersistent = reader.getLatestPersistentWithAllMetadataInPath(path, excludeDeleted, conditions);
        Persistent result = null;
        if (restoredPersistent != null) {
            result = this.filterFromCacheOrTrack(restoredPersistent);
        }
        return result;
    }

    public Persistent getPersistentWithMetadataAndVersion(int version, RecordMetadataCondition ... conditions) {
        PersistentReader reader = new PersistentReader(this.repository);
        return reader.getPersistentWithMetadataAndVersion(version, conditions);
    }

    public Persistent getPersistentWithMetadataAndVersion(int version, String path, RecordMetadataCondition ... conditions) {
        PersistentReader reader = new PersistentReader(this.repository);
        return reader.getPersistentWithMetadataAndVersion(version, path, conditions);
    }

    public Persistent getPersistentWithMetadataAtCommit(long commit, RecordMetadataCondition ... conditions) {
        PersistentReader reader = new PersistentReader(this.repository);
        return reader.getPersistentWithMetadataAtCommit(commit, conditions);
    }

    public Persistent getPersistentWithMetadataAtCommit(long commit, String path, RecordMetadataCondition ... conditions) {
        PersistentReader reader = new PersistentReader(this.repository);
        return reader.getPersistentWithMetadataAtCommit(commit, path, conditions);
    }

    public List<Persistent> getAllPersistentVersionsInPath(String path) {
        PersistentReader reader = new PersistentReader(this.repository);
        return reader.getAllPersistentVersionsInPath(path);
    }

    @Deprecated
    public <T extends Persistent> T restoreForCommit(Class<T> clazz, String path, long commit) {
        PersistentReader reader = new PersistentReader(this.repository);
        Object result = reader.readPersistentForCommit(clazz, path = new Handle(path, -1).getPath(), commit);
        if (result != null) {
            result = this.filterFromCacheOrTrack((Persistent)result);
        }
        return result;
    }

    public <T extends Persistent> List<T> restoreAllInPath(Class<T> clazz, String path) {
        return this.restoreAllInPath(clazz, path, false);
    }

    public <T extends Persistent> List<T> restoreAllInPathIncludingDeleted(Class<T> clazz, String path) {
        return this.restoreAllInPath(clazz, path, true);
    }

    private <T extends Persistent> List<T> restoreAllInPath(Class<T> clazz, String path, boolean includeDeleted) {
        path = new Handle(path, -1).getPath();
        PersistentReader reader = new PersistentReader(this.repository);
        List<T> results = reader.readAllInPath(clazz, path, includeDeleted);
        ArrayList<Persistent> finalResult = new ArrayList<Persistent>();
        for (Persistent result : results) {
            result = this.filterFromCacheOrTrack(result);
            finalResult.add(result);
        }
        ArrayList<Persistent> persistentResults = new ArrayList<Persistent>(finalResult);
        if (this.isDebugEnabled) {
            log.debug((Object)String.format("restoreAllInPath resolved %s persistents with class %s in path %s", persistentResults.size(), clazz.getCanonicalName(), path));
        }
        Set<Persistent> cacheResults = this.getUnsavedPersistentsInPathFromCache(path, persistentResults);
        for (Persistent cacheResult : cacheResults) {
            finalResult.add(cacheResult);
        }
        return finalResult;
    }

    public <T extends Persistent> List<T> restoreAllLikePath(Class<T> clazz, String path, boolean includeDeleted) {
        PersistentReader reader = new PersistentReader(this.repository);
        List<T> results = reader.readAllLikePath(clazz, path, includeDeleted);
        ArrayList<Persistent> finalResult = new ArrayList<Persistent>();
        for (Persistent result : results) {
            result = this.filterFromCacheOrTrack(result);
            finalResult.add(result);
        }
        ArrayList<Persistent> persistentResults = new ArrayList<Persistent>(finalResult);
        Set<Persistent> cacheResults = this.getUnsavedPersistentsInPathFromCache(path, persistentResults);
        for (Persistent cacheResult : cacheResults) {
            finalResult.add(cacheResult);
        }
        return finalResult;
    }

    public <T extends Persistent> List<T> restoreAllInPartialPathModifiedSince(Class<T> clazz, String path, Long modifiedSince) {
        path = new Handle(path, -1).getPath();
        PersistentReader reader = new PersistentReader(this.repository);
        List<T> results = reader.readAllLikePathSinceTime(clazz, path, modifiedSince);
        ArrayList<Persistent> finalResult = new ArrayList<Persistent>();
        for (Persistent result : results) {
            result = this.filterFromCacheOrTrack(result);
            finalResult.add(result);
        }
        ArrayList<Persistent> persistentResults = new ArrayList<Persistent>(finalResult);
        Set<Persistent> cacheResults = this.getUnsavedPersistentsInPathFromCache(path, persistentResults);
        for (Persistent cacheResult : cacheResults) {
            finalResult.add(cacheResult);
        }
        return finalResult;
    }

    public <T extends Persistent> List<T> restoreAllInPathForCommit(Class<T> clazz, String path, Long commit) {
        path = new Handle(path, -1).getPath();
        PersistentReader reader = new PersistentReader(this.repository);
        List<T> results = reader.readAllInPathForCommit(clazz, path, commit);
        ArrayList<Persistent> finalResult = new ArrayList<Persistent>();
        for (Persistent result : results) {
            result = this.filterFromCacheOrTrack(result);
            finalResult.add(result);
        }
        return finalResult;
    }

    private Persistent filterFromCacheOrTrack(Persistent target) {
        PersistenceData persistenceData = target.getPersistenceData();
        String path = persistenceData.getPath();
        Handle targetHandle = new Handle(target);
        Persistent cached = this.handle2trackedPersistents.get(targetHandle);
        if (cached == null) {
            if (this.isTraceEnabled) {
                log.trace((Object)("Cache miss for handle: " + targetHandle.toString()));
            }
            this.trackPersistent(target);
            return target;
        }
        if (this.isTraceEnabled) {
            log.trace((Object)String.format("Favoring Persistent with path '%s' found in session cache", path));
        }
        return cached;
    }

    private Persistent getUnsavedPersistentFromCache(String path) {
        SortedSet<Integer> versions = this.path2versions.get(path);
        if (versions != null) {
            int version = versions.last();
            Handle handle = new Handle(path, version);
            Persistent cachedResult = this.handle2trackedPersistents.get(handle);
            if (cachedResult != null) {
                int versionCount;
                PersistenceData persistenceData = cachedResult.getPersistenceData();
                int relativeVersion = persistenceData.getRelativeVersion();
                if (relativeVersion == (versionCount = persistenceData.getVersionCount())) {
                    if (this.isTraceEnabled) {
                        log.trace((Object)String.format("Found cached result for handle '%s'", handle.toString()));
                    }
                    return cachedResult;
                }
                if (this.isTraceEnabled) {
                    log.trace((Object)String.format("Relative version '%d' does not equal version count '%d'", relativeVersion, versionCount));
                }
            } else if (this.isTraceEnabled) {
                log.trace((Object)String.format("cachedResult was null for Handle '%s'", handle.toString()));
            }
        } else if (this.isTraceEnabled) {
            log.trace((Object)String.format("No versions for path '%s' in this Session", path));
        }
        return null;
    }

    private Set<Persistent> getUnsavedPersistentsInPathFromCache(String latestPath, List<Persistent> currentResult) {
        latestPath = new Handle(latestPath, -1).getPath();
        HashSet<String> currentResultPaths = new HashSet<String>();
        for (Persistent p : currentResult) {
            currentResultPaths.add(p.getPersistenceData().getPath());
        }
        HashSet<Persistent> result = new HashSet<Persistent>();
        for (Persistent cached : this.handle2trackedPersistents.values()) {
            String pathAfterSearch;
            PersistenceData cachedData = cached.getPersistenceData();
            String cachedPath = cachedData.getPath();
            if (!cachedPath.startsWith(latestPath) || (pathAfterSearch = cachedPath.substring(latestPath.length())).lastIndexOf("/") != 0 || currentResultPaths.contains(cachedPath)) continue;
            result.add(cached);
        }
        return result;
    }

    private void trackPersistent(Object target) {
        if (target instanceof Persistent) {
            Persistent persistent;
            Handle h;
            SortedSet<Integer> versions;
            if (this.maxSessionSize > 0 && this.getSessionSize() >= this.maxSessionSize) {
                this.failForSessionSizeExceeded();
            }
            if ((versions = this.path2versions.get((h = new Handle(persistent = (Persistent)target)).getPath())) == null) {
                if (this.isTraceEnabled) {
                    log.trace((Object)String.format("Creating new sorted set for first persistent with path '%s'", h.getPath()));
                }
                versions = new TreeSet<Integer>();
                this.path2versions.put(h.getPath(), versions);
            }
            versions.add(h.getVersion());
            this.handle2trackedPersistents.put(h, persistent);
            if (this.isDebugEnabled) {
                log.debug((Object)String.format("Now tracking persistent with handle '%s'", h.toString()));
            }
        } else {
            throw new RuntimeException("Cannot restore a " + target.getClass() + " (" + target + ") because it does not implement Persistent.");
        }
    }

    int getMaxSessionSize() {
        return this.maxSessionSize;
    }

    int getSessionSize() {
        return this.handle2trackedPersistents.size();
    }

    Set<Persistent> getDirtyPersistents() {
        HashSet<Persistent> result = new HashSet<Persistent>();
        for (Persistent persistent : this.handle2trackedPersistents.values()) {
            PersistenceData persistenceData = persistent.getPersistenceData();
            if (!persistenceData.isDirty() || persistenceData.isDeleted()) continue;
            result.add(persistent);
        }
        log.debug((Object)("Session " + this + " has " + result.size() + " dirty persistents."));
        return result;
    }

    Set<Persistent> getDirtyAndDeletedPersistents() {
        HashSet<Persistent> result = new HashSet<Persistent>();
        for (Persistent persistent : this.handle2trackedPersistents.values()) {
            PersistenceData persistenceData = persistent.getPersistenceData();
            if (!persistenceData.isDeleted() || !persistenceData.isDirty()) continue;
            result.add(persistent);
        }
        log.debug((Object)("Session " + this + " has " + result.size() + " deleted persistents."));
        return result;
    }

    public Commit getCommit(long id) {
        PersistentReader reader = new PersistentReader(this.repository);
        return reader.readCommit(id);
    }

    public <T extends Persistent> List<Commit> getCommitsForPersistent(T persistent) {
        PersistentReader reader = new PersistentReader(this.repository);
        return reader.readCommitsForPersistent(persistent.getPersistenceData().getPath());
    }

    public List<Commit> getCommitsForPersistent(String path) {
        PersistentReader reader = new PersistentReader(this.repository);
        return reader.readCommitsForPersistent(path);
    }

    public List<Commit> getCommitsForPath(String path) {
        path = new Handle(path, -1).getPath();
        PersistentReader reader = new PersistentReader(this.repository);
        return reader.readCommitsForPath(path);
    }

    public <T extends Persistent> Integer getVersionCountForPersistent(T persistent) {
        PersistentReader reader = new PersistentReader(this.repository);
        return reader.getVersionCountForPersistent(persistent);
    }

    public <T extends Persistent> Integer getVersionForCommit(T persistent, Long commit) {
        PersistentReader reader = new PersistentReader(this.repository);
        return reader.getVersionForCommit(persistent, commit);
    }

    public boolean persistentExistsUnderPath(String path) {
        PersistentReader reader = new PersistentReader(this.repository);
        return reader.persistentExistsUnderPath(path);
    }

    public Persistent getPersistentForRecord(PersistentRecord record) {
        PersistentReader reader = new PersistentReader(this.repository);
        Persistent result = reader.restore(record);
        if (result != null) {
            result = this.filterFromCacheOrTrack(result);
        }
        return result;
    }

    public boolean doesPersistentWithMetadataExistInLikePath(String path, RecordMetadataCondition ... conditions) {
        PersistentReader reader = new PersistentReader(this.repository);
        return reader.doesPersistentWithMetadataExistInLikePath(path, conditions);
    }

    protected void cacheLatestVersion(String path, Integer version) {
        this.latestVersionCache.put(path, version);
    }

    protected Integer getCachedLatestVersion(String path) {
        return this.latestVersionCache.get(path);
    }

    public void close() {
        this.repository.unbindSession();
    }

    void failForSessionSizeExceeded() {
        String msg = String.format("VC session size limit reached for loaded persistent objects (limit=%d). Failing request to prevent memory exhaustion. Increase server.vc.maxSessionSize in installed.properties to raise the limit or set to zero to disable it.", this.maxSessionSize);
        throw new VersionedObjectLoadLimitExceededException(msg);
    }
}

