/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.vc;

import com.urbancode.air.vc.Commit;
import com.urbancode.air.vc.LatestVersionEntry;
import com.urbancode.air.vc.PersistenceData;
import com.urbancode.air.vc.Persistent;
import com.urbancode.air.vc.PersistentRecord;
import com.urbancode.air.vc.PersistentWriter;
import com.urbancode.air.vc.Repository;
import com.urbancode.air.vc.Session;
import com.urbancode.air.vc.VCHelper;
import com.urbancode.air.vc.VCHelperRegistry;
import com.urbancode.air.vc.metadata.RecordMetadata;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transaction {
    private static final Logger log = Logger.getLogger(Transaction.class);
    private final Session session;
    private final long startCommit;
    private String comment;

    Transaction(Session session) {
        this.session = session;
        this.comment = "";
        if (!session.getRepository().getTxManager().isActive()) {
            throw new RuntimeException("Cannot create a versioned configuration transaction when there is no hibernate transaction active.");
        }
        Repository repository = session.getRepository();
        this.startCommit = repository.getCurrentCommit();
    }

    public Commit commit(String username) {
        Repository repository = this.session.getRepository();
        PersistentWriter writer = new PersistentWriter(repository);
        Commit commit = null;
        Set<Persistent> dirtyPersistents = this.session.getDirtyPersistents();
        Set<Persistent> deletedPersistents = this.session.getDirtyAndDeletedPersistents();
        List<String> purgedPaths = this.session.getPurgedPaths();
        try {
            if (!(dirtyPersistents.isEmpty() && deletedPersistents.isEmpty() && purgedPaths.isEmpty())) {
                String data;
                HashMap<Persistent, String> dirtyPersistentToData = new HashMap<Persistent, String>();
                HashMap<Persistent, String> deletedPersistentToData = new HashMap<Persistent, String>();
                for (Persistent persistent : dirtyPersistents) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Running interceptors for " + persistent));
                    }
                    writer.runWriteInterceptors(persistent);
                }
                for (Persistent p : dirtyPersistents) {
                    data = this.getDataString(repository, p);
                    dirtyPersistentToData.put(p, data);
                }
                for (Persistent p : deletedPersistents) {
                    data = this.getDataString(repository, p);
                    deletedPersistentToData.put(p, data);
                }
                repository.getSession().getRepository().getTxManager().getSession().flush();
                long timeToAcquire = repository.acquireLock("CommitLock");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Time to acquireLock: " + timeToAcquire));
                }
                long nextCommit = repository.getCurrentCommit() + 1L;
                commit = new Commit(nextCommit, username, this.getCurrentComment());
                Map<Class<?>, List<Object>> written = writer.write(commit, dirtyPersistentToData, this.startCommit);
                for (Persistent persistent : dirtyPersistents) {
                    PersistenceData persistenceData = persistent.getPersistenceData();
                    persistenceData.setDirty(false);
                    commit.addPathModified(persistenceData.getPath());
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Wrote persistent " + persistent + " to " + persistenceData.getPath()));
                }
                Map<Class<?>, List<Object>> deleted = writer.delete(commit, deletedPersistentToData, this.startCommit);
                HashMap toSaveMap = new HashMap();
                for (Class<?> key : written.keySet()) {
                    toSaveMap.put(key, written.get(key));
                }
                for (Class<?> key : deleted.keySet()) {
                    List cur = (List)toSaveMap.get(key);
                    if (cur == null) {
                        toSaveMap.put(key, deleted.get(key));
                        continue;
                    }
                    cur.addAll((Collection)deleted.get(key));
                }
                for (Persistent persistent : deletedPersistents) {
                    commit.addPathDeleted(persistent.getPersistenceData().getPath());
                }
                repository.getTxManager().getSession().save((Object)commit);
                for (Serializable obj : (List)toSaveMap.get(PersistentRecord.class)) {
                    repository.getTxManager().getSession().save((Object)obj);
                }
                for (Serializable obj : (List)toSaveMap.get(RecordMetadata.class)) {
                    repository.getTxManager().getSession().save((Object)obj);
                }
                for (Serializable obj : (List)toSaveMap.get(LatestVersionEntry.class)) {
                    repository.getTxManager().getSession().save((Object)obj);
                }
                toSaveMap.remove(PersistentRecord.class);
                toSaveMap.remove(RecordMetadata.class);
                toSaveMap.remove(LatestVersionEntry.class);
                for (List objs : toSaveMap.values()) {
                    for (Object obj : objs) {
                        repository.getTxManager().getSession().save(obj);
                    }
                }
                this.createPurgeEntriesForCommit(commit, purgedPaths);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Failed to commit transaction: " + e.getMessage(), e);
        }
        finally {
            this.setCurrentComment("");
            this.session.unbindTransaction();
        }
        return commit;
    }

    private void createPurgeEntriesForCommit(Commit commit, List<String> purgedPaths) {
        for (String path : purgedPaths) {
            commit.addPathPurged(path);
        }
    }

    private String getDataString(Repository repository, Persistent p) {
        String data;
        VCHelperRegistry registry = repository.getHelperRegistry();
        VCHelper<?> helper = registry.getHelper(p.getClass());
        if (helper == null) {
            throw new RuntimeException("No helper registered for class " + p.getClass());
        }
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            helper.write(p, output);
            output.close();
            data = output.toString("UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to write persistent to a string", e);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Commit commitAndEnd(String username) {
        Commit result;
        try {
            result = this.commit(username);
        }
        finally {
            this.session.close();
        }
        return result;
    }

    public boolean isActive() {
        return this.session.getRepository().getTxManager().isActive();
    }

    public String getCurrentComment() {
        return this.comment;
    }

    public void setCurrentComment(String comment) {
        if (comment != null) {
            this.comment = comment;
        }
    }
}

