/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.vc;

import com.urbancode.air.vc.VCHelper;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VCHelperRegistry {
    private List<VCHelper<?>> registry = new ArrayList();

    public void registerHelper(VCHelper<?> helper) {
        this.registry.add(helper);
    }

    public <T> VCHelper<T> getHelper(Class<T> clazz) {
        VCHelper<?> result = null;
        for (VCHelper<?> helper : this.registry) {
            if (!helper.getPersistentClass().equals(clazz)) continue;
            if (result != null) {
                throw new RuntimeException("More than one VCHelper would take class " + clazz + " " + "(" + result.getClass() + " and " + helper.getClass() + ")");
            }
            result = helper;
        }
        if (result == null) {
            for (VCHelper<?> helper : this.registry) {
                if (!helper.getPersistentClass().isAssignableFrom(clazz)) continue;
                result = helper;
            }
        }
        if (result == null) {
            throw new RuntimeException("No helper found for class " + clazz);
        }
        return result;
    }

    public VCHelper<?> getHelper(String element) {
        VCHelper<?> result = null;
        for (VCHelper<?> helper : this.registry) {
            if (!helper.getObjectElementName().equals(element)) continue;
            if (result != null) {
                throw new RuntimeException("More than one VCHelper would take object element name " + element + " (" + result.getClass() + " and " + helper.getClass() + ")");
            }
            result = helper;
        }
        if (result == null) {
            throw new RuntimeException("No helper found for element name " + element);
        }
        return result;
    }
}

