/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.vc.interceptors;

import com.urbancode.air.vc.Persistent;
import com.urbancode.air.vc.interceptors.DirtyInterceptor;
import com.urbancode.air.vc.interceptors.ReadInterceptor;
import com.urbancode.air.vc.interceptors.WriteInterceptor;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorRegistry
implements ReadInterceptor,
WriteInterceptor {
    private static InterceptorRegistry instance = new InterceptorRegistry();
    private List<DirtyInterceptor> dirtyInterceptors = new ArrayList<DirtyInterceptor>();
    private List<WriteInterceptor> writeInterceptors = new ArrayList<WriteInterceptor>();
    private List<ReadInterceptor> readInterceptors = new ArrayList<ReadInterceptor>();

    public static InterceptorRegistry getInstance() {
        return instance;
    }

    public synchronized void registerDirtyInterceptor(DirtyInterceptor interceptor) {
        this.dirtyInterceptors.add(interceptor);
    }

    public synchronized void registerWriteInterceptor(WriteInterceptor interceptor) {
        this.writeInterceptors.add(interceptor);
    }

    public synchronized void registerReadInterceptor(ReadInterceptor interceptor) {
        this.readInterceptors.add(interceptor);
    }

    public synchronized List<DirtyInterceptor> getDirtyInterceptors() {
        return new ArrayList<DirtyInterceptor>(this.dirtyInterceptors);
    }

    public synchronized List<WriteInterceptor> getWriteInterceptors() {
        return new ArrayList<WriteInterceptor>(this.writeInterceptors);
    }

    public synchronized List<ReadInterceptor> getReadInterceptors() {
        return new ArrayList<ReadInterceptor>(this.readInterceptors);
    }

    public synchronized void clear() {
        this.readInterceptors.clear();
        this.writeInterceptors.clear();
        this.dirtyInterceptors.clear();
    }

    @Override
    public void interceptRead(Persistent persistent) {
        for (ReadInterceptor interceptor : this.readInterceptors) {
            interceptor.interceptRead(persistent);
        }
    }

    @Override
    public void interceptWrite(Persistent persistent) {
        for (WriteInterceptor interceptor : this.writeInterceptors) {
            interceptor.interceptWrite(persistent);
        }
    }
}

