/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.connector.scm.client;

import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import com.ibm.team.connector.scm.client.JzLocation;
import com.ibm.team.connector.scm.client.JzProvider;
import com.ibm.team.connector.scm.client.JzRepoComponent;
import com.ibm.team.connector.scm.client.JzRepoControllableFolder;
import com.ibm.team.connector.scm.client.JzRepoControllableResource;
import com.ibm.team.connector.scm.client.JzRepoWorkspace;
import com.ibm.team.connector.scm.client.Messages;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IFolderHandle;
import java.util.List;
import java.util.Map;
import javax.wvcm.ControllableFolder;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.WvcmException;

public class JzRepoBaselineControlledFolder
extends JzRepoControllableFolder {
    public JzRepoBaselineControlledFolder(JzProvider provider, Location loc) {
        super(provider, loc);
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Resource.RESOURCE_IDENTIFIER)) {
            return this.getResourceIdentifier(feedback);
        }
        if (propertyName.equals((Object)Resource.PATHNAME_LOCATION)) {
            return this.getPathnameLocation(feedback);
        }
        if (propertyName.equals((Object)ControllableFolder.ROOT_FOLDER_OF)) {
            return this.getWvcmConfiguration(feedback);
        }
        if (propertyName.equals((Object)Resource.DISPLAY_NAME)) {
            return this.getDisplayName(feedback);
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    @Override
    protected String getResourceIdentifier(SrvcFeedback feedback) throws WvcmException {
        JzRepoWorkspace ws = this.getWvcmWorkspace(feedback.nest(50));
        JzRepoComponent comp = ws.getJzRepoComponent(this.location().getComponentLocation(), feedback);
        JzLocation resultLoc = JzLocation.createBCFLoc(ws.location(), comp.location());
        return resultLoc.string();
    }

    @Override
    public IItemHandle computeItemHandle(SrvcFeedback feedback) throws WvcmException {
        JzRepoWorkspace ws = this.getWvcmWorkspace(feedback.nest(30));
        JzLocation myLoc = this.location();
        JzRepoComponent comp = ws.getJzRepoComponent(myLoc.getComponentLocation(), feedback.nest(60));
        String locationString = myLoc.string();
        if (comp == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoBaselineControlledFolder_ERROR_GET_BCF_COMPONENT_FAILED, (Object)locationString, (Object[])new Object[0]), WvcmException.ReasonCode.NOT_FOUND);
        }
        IFolderHandle rootFolder = comp.getRootFolderHandle(feedback);
        if (rootFolder == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoBaselineControlledFolder_ERROR_GET_BCF_ROOT_DIR_FAILED, (Object)locationString, (Object[])new Object[0]), WvcmException.ReasonCode.NOT_FOUND);
        }
        return rootFolder;
    }

    @Override
    public String getDisplayName(SrvcFeedback feedback) throws WvcmException {
        return this.getJzRepoComponent(feedback.nest(50)).getName(feedback);
    }

    public static JzRepoBaselineControlledFolder doCreateResource(JzProvider provider, JzLocation myLoc, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        JzLocation wsLoc = myLoc.parent();
        JzRepoWorkspace ws = (JzRepoWorkspace)provider.lookup((Location)wsLoc, feedback.nest(30));
        if (ws == null) {
            throw new WvcmException(NLS.bind((String)Messages.JzRepoBaselineControlledFolder_ERROR_GET_WORKSPACE_FROM_BCF_LOC_FAILED, (Object)myLoc.string(), (Object[])new Object[0]), WvcmException.ReasonCode.NOT_FOUND);
        }
        JzLocation compLoc = ws.doCreateComponent(myLoc.getComponentLocation(), updates, updated, feedback.nest(60));
        JzLocation resultLoc = JzLocation.createBCFLoc(wsLoc, compLoc);
        JzRepoBaselineControlledFolder result = (JzRepoBaselineControlledFolder)provider.get((Location)resultLoc, feedback);
        return result;
    }

    public JzLocation getPathnameLocation(SrvcFeedback feedback) throws WvcmException {
        return JzRepoBaselineControlledFolder.getPathnameLocation(this.provider(), this.location(), feedback);
    }

    private static JzLocation getPathnameLocation(JzProvider provider, JzLocation myLoc, SrvcFeedback feedback) throws WvcmException {
        JzRepoWorkspace ws = (JzRepoWorkspace)provider.get((Location)myLoc.getWorkspaceLocation(), feedback.nest(10));
        JzLocation wsPathnameLoc = ws.getPathnameLocation(feedback.nest(20));
        JzRepoComponent comp = ws.getJzRepoComponent(myLoc.getComponentLocation(), feedback.nest(40));
        JzLocation result = wsPathnameLoc.child(comp.getName(feedback));
        return result;
    }

    public static JzRepoBaselineControlledFolder lookup(JzProvider provider, JzLocation myLoc, SrvcFeedback feedback) throws WvcmException {
        JzRepoBaselineControlledFolder result = null;
        try {
            JzLocation myPathnameLoc = JzRepoBaselineControlledFolder.getPathnameLocation(provider, myLoc, feedback);
            if (myPathnameLoc != null) {
                result = new JzRepoBaselineControlledFolder(provider, (Location)myLoc);
            }
        }
        catch (WvcmException e) {
            if (WvcmException.ReasonCode.NOT_FOUND.equals((Object)e.getReasonCode())) {
                provider.logIgnoredExceptionAsNotAlwaysVisible("JzRepoBaselineControlledFolder.lookup", (Exception)((Object)e));
            }
            throw e;
        }
        return result;
    }

    public static /* bridge */ /* synthetic */ JzRepoControllableResource lookup(JzProvider jzProvider, JzLocation jzLocation, SrvcFeedback srvcFeedback) throws WvcmException {
        return JzRepoBaselineControlledFolder.lookup(jzProvider, jzLocation, srvcFeedback);
    }
}

