/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.runtime;

import com.urbancode.commons.util.IO;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CharsetTranscoder {
    private static final Logger logger = Logger.getLogger(CharsetTranscoder.class);
    private File rootDir = null;

    CharsetTranscoder(File directory) {
        this.rootDir = directory;
    }

    public void transcode() throws IOException {
        Iterator<?> iterator = this.createIterator();
        String decode = "UTF-8";
        String encode = System.getProperty("system.default.encoding");
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Transcoding %s from %s to %s", file, decode, encode));
            }
            IO.transcode((String)decode, (String)encode, (File)file);
        }
    }

    protected Iterator<?> createIterator() {
        String[] extensions = System.getProperty("plugin.transcode.extensions", "groovy,txt,py,cmd,bat,conf,cmd,sh,gvy,pl,rb").split(",");
        return FileUtils.iterateFiles((File)this.rootDir, (String[])extensions, (boolean)true);
    }
}

