/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin_command.upgrade;

import com.urbancode.air.plugin_command.upgrade.PluginVersionMigration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginUpgrade {
    private static final Logger log = Logger.getLogger(PluginUpgrade.class);
    public List<PluginVersionMigration> migrations = new ArrayList<PluginVersionMigration>();

    public void addPluginVersionMigration(PluginVersionMigration migration) {
        this.migrations.add(migration);
    }

    public List<PluginVersionMigration> getPluginVersionMigrationList() {
        return Collections.unmodifiableList(this.migrations);
    }

    public List<PluginVersionMigration> getMigrationsForVersions(long fromVersion, long toVersion) {
        ArrayList<PluginVersionMigration> result = new ArrayList<PluginVersionMigration>();
        if (fromVersion < toVersion) {
            for (PluginVersionMigration migration : this.migrations) {
                if (migration.getVersion() <= fromVersion || migration.getVersion() > toVersion) continue;
                result.add(migration);
            }
            Collections.sort(result);
        } else if (fromVersion > toVersion) {
            for (PluginVersionMigration migration : this.migrations) {
                if (migration.getVersion() != toVersion) continue;
                result.add(migration);
            }
        }
        if (log.isDebugEnabled()) {
            String msg = "";
            if (result.size() == 0) {
                msg = "No migrations need to be applied";
            } else {
                for (PluginVersionMigration migration : result) {
                    msg = msg + migration.getVersion() + ", ";
                }
                msg = "The following migrations need to be applied: " + msg;
                if (result.size() > 0) {
                    msg = msg.substring(0, msg.length() - 2);
                }
            }
            log.debug((Object)msg);
        }
        return result;
    }
}

