/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.changemodel;

import com.ibm.team.filesystem.common.changemodel.ConfigurationChange;
import com.ibm.team.filesystem.common.changemodel.FileChange;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.common.changemodel.IPathResolver;
import com.ibm.team.filesystem.common.changemodel.VersionablePath;
import com.ibm.team.filesystem.common.changemodel.VersionablePathSegment;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.SiloedItemId;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public final class ResolvedConfigurationChangePaths {
    private IPathResolver pathResolver;
    private boolean resolveConflicts;
    private IPathResolver beforeResolver = new IPathResolver(){

        @Override
        public Map<SiloedItemId<IVersionable>, VersionablePath> resolve(Collection<SiloedItemId<IVersionable>> unresolved, IProgressMonitor monitor) throws TeamRepositoryException {
            return ResolvedConfigurationChangePaths.this.computePaths(unresolved, true, monitor);
        }
    };
    private IPathResolver afterResolver = new IPathResolver(){

        @Override
        public Map<SiloedItemId<IVersionable>, VersionablePath> resolve(Collection<SiloedItemId<IVersionable>> unresolved, IProgressMonitor monitor) throws TeamRepositoryException {
            return ResolvedConfigurationChangePaths.this.computePaths(unresolved, false, monitor);
        }
    };
    private Map<SiloedItemId<IVersionable>, VersionablePathSegment> resolvedPaths = new HashMap<SiloedItemId<IVersionable>, VersionablePathSegment>();
    private Map<SiloedItemId<IVersionable>, List<FileChange>> changesByItem;
    private Collection<SiloedItemId<IVersionable>> knownResolvedItems = new HashSet<SiloedItemId<IVersionable>>();
    private Collection<SiloedItemId<IVersionable>> knownRootItems = new HashSet<SiloedItemId<IVersionable>>();
    private final boolean absolutePathsIfPossible;

    private ResolvedConfigurationChangePaths(IPathResolver resolver, ConfigurationChange change, boolean resolveConflicts, boolean absolutePathsIfPossible) {
        this.absolutePathsIfPossible = absolutePathsIfPossible;
        this.changesByItem = change.getChangesByItem();
        this.pathResolver = resolver;
        this.resolveConflicts = resolveConflicts;
        for (List<FileChange> changes : this.changesByItem.values()) {
            for (FileChange next : changes) {
                if (!next.getNonDeleted(true).getPath().getParent().isNull()) continue;
                this.knownResolvedItems.add(next.getSiloedItemId());
            }
        }
    }

    public IPathResolver getPathResolver(boolean beforePaths) {
        return beforePaths ? this.beforeResolver : this.afterResolver;
    }

    public Map<SiloedItemId<IVersionable>, VersionablePath> computePaths(Collection<SiloedItemId<IVersionable>> versionables, boolean beforeState, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        HashMap<SiloedItemId<IVersionable>, VersionablePath> result = new HashMap<SiloedItemId<IVersionable>, VersionablePath>();
        Map<Object, List<VersionablePath>> toFetch = new HashMap<SiloedItemId<IVersionable>, List<VersionablePath>>();
        this.fetchMoreSegments(versionables, (IProgressMonitor)progress.newChild(10));
        for (SiloedItemId<IVersionable> next : versionables) {
            VersionablePath nextPath = this.getKnownSegments(next, beforeState);
            if (nextPath.isResolved()) {
                result.put(next, nextPath);
            }
            if (!this.moreSegmentsDesired(nextPath)) continue;
            CollectionUtil.addToMapOfLists(toFetch, nextPath.getSiloedRoot(), (Object)nextPath);
        }
        while (!toFetch.isEmpty() && !progress.isCanceled()) {
            HashMap<SiloedItemId<IVersionable>, List<VersionablePath>> nextToFetch = new HashMap<SiloedItemId<IVersionable>, List<VersionablePath>>();
            if (this.fetchMoreSegments(toFetch.keySet(), (IProgressMonitor)progress.newChild(50))) {
                for (SiloedItemId next : toFetch.keySet()) {
                    VersionablePath beforeSegments = this.getKnownSegments((SiloedItemId<IVersionable>)next, beforeState);
                    List<VersionablePath> nextPaths = toFetch.get(next);
                    if (beforeSegments.segmentCount() == 0) {
                        for (VersionablePath nextPath : nextPaths) {
                            result.put(nextPath.getSiloedItemId(), nextPath);
                        }
                        continue;
                    }
                    for (VersionablePath nextPath : nextPaths) {
                        VersionablePath computedPath = beforeSegments.append(nextPath);
                        if (computedPath.isResolved()) {
                            result.put(nextPath.getSiloedItemId(), computedPath);
                        }
                        if (!this.moreSegmentsDesired(computedPath)) continue;
                        CollectionUtil.addToMapOfLists(nextToFetch, computedPath.getSiloedRoot(), (Object)computedPath);
                    }
                }
            }
            toFetch = this.wasProgressMade(toFetch, nextToFetch) ? nextToFetch : Collections.emptyMap();
        }
        return result;
    }

    private boolean wasProgressMade(Map<SiloedItemId<IVersionable>, List<VersionablePath>> toFetch, Map<SiloedItemId<IVersionable>, List<VersionablePath>> nextToFetch) {
        if (toFetch.size() == nextToFetch.size()) {
            for (SiloedItemId<IVersionable> key : toFetch.keySet()) {
                List<VersionablePath> list = toFetch.get(key);
                List<VersionablePath> nextList = nextToFetch.get(key);
                if (nextList != null && !this.wasProgressMade(list, nextList)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean wasProgressMade(List<VersionablePath> list, List<VersionablePath> nextList) {
        for (VersionablePath path : list) {
            for (VersionablePath nextPath : nextList) {
                if (!path.getSiloedItemId().equals(nextPath.getSiloedItemId()) || path.equals(nextPath)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean moreSegmentsDesired(VersionablePath path) {
        return !path.isResolved() || this.absolutePathsIfPossible && !path.isAbsolute();
    }

    private boolean fetchMoreSegments(Collection<SiloedItemId<IVersionable>> keySet, IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet<SiloedItemId<IVersionable>> newKeySet = this.getUnresolvedItems(keySet);
        if (!newKeySet.isEmpty()) {
            this.internalFetchMoreSegments(newKeySet, monitor);
            return true;
        }
        return false;
    }

    private HashSet<SiloedItemId<IVersionable>> getUnresolvedItems(Collection<SiloedItemId<IVersionable>> keySet) {
        HashSet<SiloedItemId<IVersionable>> newKeySet = new HashSet<SiloedItemId<IVersionable>>();
        for (SiloedItemId<IVersionable> next : keySet) {
            if (this.resolvedPaths.containsKey(next)) continue;
            newKeySet.add(next);
        }
        return newKeySet;
    }

    private void internalFetchMoreSegments(Collection<SiloedItemId<IVersionable>> newKeySet, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Map<SiloedItemId<IVersionable>, VersionablePath> resolved = this.pathResolver.resolve(newKeySet, (IProgressMonitor)progress.newChild(100));
        for (VersionablePath next : resolved.values()) {
            SiloedItemId nextId = next.getSiloedItemId();
            int idx = next.segmentCount() - 1;
            while (idx >= 0) {
                VersionablePathSegment nextSegment = next.segment(idx);
                if (!this.resolvedPaths.containsKey(nextId)) {
                    this.resolvedPaths.put(nextId, nextSegment);
                }
                nextId = SiloedItemId.upcast((SiloedItemId)SiloedItemId.create(nextSegment.getParent(), (ItemId)next.getSiloedItemId().getComponent()));
                --idx;
            }
            SiloedItemId topLevelItem = null;
            if (!next.isResolved()) continue;
            if (next.segmentCount() > 1) {
                topLevelItem = SiloedItemId.upcast((SiloedItemId)SiloedItemId.create(next.segment(1).getParent(), (ItemId)next.getSiloedItemId().getComponent()));
            } else if (next.segmentCount() >= 0) {
                topLevelItem = next.getSiloedItemId();
            }
            if (topLevelItem == null) continue;
            this.knownResolvedItems.add(topLevelItem);
            if (!this.absolutePathsIfPossible || !next.isAbsolute()) continue;
            this.knownRootItems.add((SiloedItemId<IVersionable>)topLevelItem);
        }
    }

    private VersionablePath getKnownSegments(SiloedItemId<IVersionable> siloedItem, boolean beforeState) {
        LinkedList<VersionablePathSegment> segments = new LinkedList<VersionablePathSegment>();
        HashSet<SiloedItemId> versionables = new HashSet<SiloedItemId>();
        if (siloedItem.getItemId().isNull()) {
            return VersionablePath.create(new VersionablePathSegment[0], siloedItem, false, false);
        }
        boolean resolved = false;
        boolean absolute = false;
        ItemId component = siloedItem.getComponent();
        SiloedItemId nextItem = siloedItem;
        while (!(nextItem == null || resolved || this.absolutePathsIfPossible && absolute)) {
            if (versionables.contains(nextItem)) break;
            versionables.add(nextItem);
            VersionablePathSegment nextSegment = this.getCachedPath(nextItem, beforeState);
            if (this.knownResolvedItems.contains(nextItem)) {
                resolved = true;
            }
            if (this.knownRootItems.contains(nextItem)) {
                absolute = true;
            }
            if (nextSegment != null) {
                segments.addFirst(nextSegment);
                nextItem = SiloedItemId.upcast((SiloedItemId)SiloedItemId.create(nextSegment.getParent(), (ItemId)component));
                continue;
            }
            nextItem = null;
        }
        return VersionablePath.create(segments, siloedItem, absolute, resolved);
    }

    private VersionablePathSegment getPath(List<FileChange> changes, boolean beforeStates) {
        HashSet<VersionablePathSegment> parentPaths = new HashSet<VersionablePathSegment>();
        for (FileChange next : changes) {
            FileState state = next.getNonDeleted(beforeStates);
            parentPaths.add(state.getPath());
        }
        VersionablePathSegment result = null;
        if (parentPaths.size() == 1 || parentPaths.size() > 1 && this.resolveConflicts) {
            result = (VersionablePathSegment)parentPaths.iterator().next();
        }
        if (result == null) {
            return null;
        }
        return result;
    }

    private VersionablePathSegment getCachedPath(SiloedItemId<IVersionable> next, boolean beforeState) {
        List<FileChange> changes = this.changesByItem.get(next);
        if (next.getItemId().isNull()) {
            return null;
        }
        if (changes != null) {
            return this.getPath(changes, beforeState);
        }
        VersionablePathSegment result = this.resolvedPaths.get(next);
        if (result != null && result.getParent().equals((Object)next.getItemId())) {
            throw new IllegalStateException("Error: found an item that has itself as its own parent");
        }
        return result;
    }

    public static ResolvedConfigurationChangePaths resolve(IPathResolver context, ConfigurationChange config, IProgressMonitor monitor) throws TeamRepositoryException {
        return ResolvedConfigurationChangePaths.resolve(context, config, true, false, monitor);
    }

    public static ResolvedConfigurationChangePaths resolve(IPathResolver context, ConfigurationChange config, boolean resolveConflicts, boolean absolutePathsIfPossible, IProgressMonitor monitor) throws TeamRepositoryException {
        ResolvedConfigurationChangePaths result = new ResolvedConfigurationChangePaths(context, config, resolveConflicts, absolutePathsIfPossible);
        result.resolveAll(monitor);
        return result;
    }

    public static ResolvedConfigurationChangePaths resolve(IPathResolver context, ConfigurationChange config, boolean resolveConflicts, IProgressMonitor monitor) throws TeamRepositoryException {
        return ResolvedConfigurationChangePaths.resolve(context, config, resolveConflicts, false, monitor);
    }

    private void resolveAll(IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet<SiloedItemId<IVersionable>> allVersionables = new HashSet<SiloedItemId<IVersionable>>();
        for (List<FileChange> next : this.changesByItem.values()) {
            for (FileChange nextChange : next) {
                UUID componentId = nextChange.getSiloedItemId().getComponentUUID();
                IItemType itemType = nextChange.getItemId().getItemType();
                SiloedItemId nextId = SiloedItemId.create((IItemType)itemType, (UUID)nextChange.getSiloedItemId().getItemUUID(), (UUID)componentId);
                if (!this.changesByItem.containsKey(nextId)) {
                    allVersionables.add((SiloedItemId<IVersionable>)nextId);
                }
                if (this.changesByItem.containsKey(nextId = SiloedItemId.create((IItemType)IFolder.ITEM_TYPE, (UUID)nextChange.getFinal().getPath().getParent().getItemUUID(), (UUID)componentId))) continue;
                allVersionables.add((SiloedItemId<IVersionable>)nextId);
            }
        }
        this.fetchMoreSegments(allVersionables, monitor);
    }

    public VersionablePath computePath(SiloedItemId<IVersionable> siloedItemId, boolean beforePath, IProgressMonitor monitor) throws TeamRepositoryException {
        VersionablePath result = this.computePaths(Collections.singleton(siloedItemId), beforePath, monitor).get(siloedItemId);
        if (result == null) {
            throw new TeamRepositoryException("Item not found in configuration");
        }
        return result;
    }
}

