/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.IFileOptions;
import com.ibm.team.filesystem.client.internal.IShareableInternal;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileItem;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class FileOptions
implements IFileOptions {
    private final boolean force;
    private final String encoding;
    private final FileLineDelimiter lineDelimiter;
    private final Map<String, String> properties;

    public FileOptions(boolean force, IFileItem fileItem) {
        this.force = force;
        this.encoding = this.nonNullEncoding(fileItem.getContent().getCharacterEncoding());
        this.lineDelimiter = this.nonNullDelimiter(fileItem.getContent().getLineDelimiter());
        this.properties = new HashMap<String, String>(fileItem.getUserProperties());
    }

    public FileOptions(boolean force, FileLineDelimiter lineDelimiter, String characterEncoding, Map<String, String> properties) {
        this.force = force;
        this.encoding = this.nonNullEncoding(characterEncoding);
        this.lineDelimiter = this.nonNullDelimiter(lineDelimiter);
        this.properties = properties == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(new HashMap<String, String>(properties));
    }

    public FileOptions(boolean force, FileItemInfo fileItemInfo, Map<String, String> properties) {
        this.force = force;
        if (fileItemInfo != null) {
            this.lineDelimiter = this.nonNullDelimiter(fileItemInfo.getLineDelimiter());
            this.encoding = this.nonNullEncoding(fileItemInfo.getStoredEncoding());
        } else {
            this.encoding = "";
            this.lineDelimiter = FileLineDelimiter.LINE_DELIMITER_NONE;
        }
        this.properties = properties == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(new HashMap<String, String>(properties));
    }

    private FileLineDelimiter nonNullDelimiter(FileLineDelimiter delimiter) {
        return delimiter == null ? FileLineDelimiter.LINE_DELIMITER_NONE : delimiter;
    }

    private String nonNullEncoding(String characterEncoding) {
        return characterEncoding == null ? "" : characterEncoding;
    }

    public FileOptions(boolean force, IShareableInternal shareable, IProgressMonitor progress) throws FileSystemException {
        this.force = force;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
        if (shareable != null) {
            FileItemInfo info = shareable.getFileItemInfo((IProgressMonitor)monitor.newChild(1));
            if (info != null) {
                this.encoding = info.getStoredEncoding();
                this.lineDelimiter = info.getLineDelimiter();
            } else {
                this.encoding = "";
                this.lineDelimiter = FileLineDelimiter.LINE_DELIMITER_NONE;
            }
            this.properties = shareable.getMetadataProperties((IProgressMonitor)monitor.newChild(1)).getCurrentProperties();
        } else {
            this.encoding = "";
            this.lineDelimiter = FileLineDelimiter.LINE_DELIMITER_NONE;
            this.properties = Collections.EMPTY_MAP;
        }
    }

    @Override
    public boolean force() {
        return this.force;
    }

    @Override
    public String getCharacterEncoding() {
        return this.encoding;
    }

    @Override
    public FileLineDelimiter getLineDelimiter() {
        return this.lineDelimiter;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }
}

