/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.IFileContentManager;
import com.ibm.team.filesystem.client.IFileSystemManager;
import com.ibm.team.filesystem.client.IFileSystemView;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemView;
import com.ibm.team.filesystem.client.internal.content.FileContentManager;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.internal.ScmClientLibraryContext;
import org.eclipse.core.runtime.IProgressMonitor;

public class FileSystemManager
implements IFileSystemManager {
    private final FileContentManager cm;
    private final FileSystemServiceProxy fileSystemService;

    public FileSystemManager(IClientLibraryContext context) {
        context = new ScmClientLibraryContext(context);
        this.cm = new FileContentManager(context);
        this.fileSystemService = new FileSystemServiceProxy(context);
    }

    public FileSystemServiceProxy getFileSystemService() {
        return this.fileSystemService;
    }

    @Override
    public IFileSystemView getFileSystemView(IConnection connection) {
        return new FileSystemView(this.fileSystemService, connection);
    }

    public int getFileSystemServiceCompatabilityLevel(IProgressMonitor progress) throws TeamRepositoryException {
        return this.getFileSystemService().getCompatabilityLevel(false, progress);
    }

    @Override
    public IFileContentManager getContentManager() {
        return this.cm;
    }

    @Override
    public boolean serverSupportsSymbolicLinks(IProgressMonitor progress) throws TeamRepositoryException {
        return this.getFileSystemService().serverSupportsSymbolicLinks(progress);
    }
}

