/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFACreateLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFAListReadLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFAReadLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFARemoveLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ComponentLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.MultiLock;

public final class GlobalCFALock
extends AbstractLock {
    final ILocation cfaPath;

    public GlobalCFALock(ILocation path) {
        this.cfaPath = path;
    }

    @Override
    public boolean contains(AbstractLock rule) {
        ILocation otherPath;
        if (this == rule) {
            return true;
        }
        if (rule instanceof MultiLock) {
            MultiLock multi = (MultiLock)rule;
            AbstractLock[] children = multi.getChildren();
            int i = 0;
            while (i < children.length) {
                if (!this.contains(children[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (rule instanceof CFAReadLock) {
            otherPath = ((CFAReadLock)rule).cfaPath;
        } else if (rule instanceof GlobalCFALock) {
            otherPath = ((GlobalCFALock)rule).cfaPath;
        } else if (rule instanceof ComponentLock) {
            otherPath = ((ComponentLock)rule).cfaPath;
        } else {
            return false;
        }
        return this.cfaPath.equals(otherPath);
    }

    @Override
    public boolean isConflicting(AbstractLock rule) {
        ILocation otherPath;
        if (rule instanceof MultiLock) {
            MultiLock multi = (MultiLock)rule;
            AbstractLock[] abstractLockArray = multi.getChildren();
            int n = abstractLockArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractLock child = abstractLockArray[n2];
                if (this.isConflicting(child)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        if (rule == GlobalLock.INSTANCE) {
            return true;
        }
        if (rule instanceof GlobalCFALock) {
            otherPath = ((GlobalCFALock)rule).cfaPath;
        } else if (rule instanceof ComponentLock) {
            otherPath = ((ComponentLock)rule).cfaPath;
        } else if (rule instanceof CFARemoveLock) {
            otherPath = ((CFARemoveLock)rule).cfaPath;
        } else {
            return false;
        }
        return this.cfaPath.equals(otherPath);
    }

    public int hashCode() {
        return this.cfaPath.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlobalCFALock)) {
            return false;
        }
        GlobalCFALock other = (GlobalCFALock)o;
        return this.cfaPath.equals(other.cfaPath);
    }

    @Override
    public boolean mayPromoteTo(AbstractLock rule) {
        if (rule instanceof MultiLock) {
            MultiLock multi = (MultiLock)rule;
            AbstractLock[] children = multi.getChildren();
            int i = 0;
            while (i < children.length) {
                if (!this.mayPromoteTo(children[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (this.contains(rule)) {
            return true;
        }
        if (rule == CFAListReadLock.INSTANCE) {
            return true;
        }
        if (rule == CFACreateLock.INSTANCE) {
            return true;
        }
        return rule instanceof CFAReadLock;
    }

    public String toString() {
        return "GlobalCFALock(" + this.cfaPath + ')';
    }
}

