/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.share;

import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.operations.IShareOverlap;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class ShareOverlap
implements IShareOverlap {
    private IShareable shareableRoot;
    private IConnection connection;
    private IComponentHandle componentHandle;
    private HashSet<IShareable> overlappingShareRoots;
    private HashSet<IShare> overlappingShares;

    public ShareOverlap(IConnection connection, IComponentHandle componentHandle, IShareable shareableRoot) {
        this.connection = connection;
        this.componentHandle = componentHandle;
        this.shareableRoot = shareableRoot;
        this.overlappingShareRoots = new HashSet();
        this.overlappingShares = new HashSet();
    }

    @Override
    public IComponentHandle getComponent() {
        return this.componentHandle;
    }

    @Override
    public IConnection getConnection() {
        return this.connection;
    }

    @Override
    public Collection<IShareable> getOverlappingShareRoots() {
        return Collections.unmodifiableCollection(this.overlappingShareRoots);
    }

    @Override
    public Collection<IShare> getOverlappingShares() {
        return Collections.unmodifiableCollection(this.overlappingShares);
    }

    @Override
    public IShareable getShareRoot() {
        return this.shareableRoot;
    }

    public void addShareRootOverlap(IShareable shareableOverlapped) {
        this.overlappingShareRoots.add(shareableOverlapped);
    }

    public void addShareOverlap(IShare shareOverlapped) {
        this.overlappingShares.add(shareOverlapped);
    }
}

