/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.snapshot;

import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.BaselineId;
import com.ibm.team.filesystem.client.internal.snapshot.BaselineSetId;
import com.ibm.team.filesystem.client.internal.snapshot.ISnapshot;
import com.ibm.team.filesystem.client.internal.snapshot.NamespaceSetId;
import com.ibm.team.filesystem.client.internal.snapshot.WorkspaceId;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.collection.SoftValueMap;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class SnapshotId {
    private static SoftValueMap<SnapshotId, ISnapshot> snapshotCache = new SoftValueMap();

    public static SnapshotId createEmptyId(ITeamRepository repo) {
        return NamespaceSetId.create(repo, Collections.<ItemNamespace>emptySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ISnapshot getSnapshot(IProgressMonitor monitor) throws TeamRepositoryException {
        ISnapshot result;
        SoftValueMap<SnapshotId, ISnapshot> softValueMap = snapshotCache;
        synchronized (softValueMap) {
            result = (ISnapshot)snapshotCache.get((Object)this);
            if (result != null) {
                return result;
            }
        }
        result = this.createSnapshot(monitor);
        softValueMap = snapshotCache;
        synchronized (softValueMap) {
            snapshotCache.put((Object)this, (Object)result);
        }
        return result;
    }

    protected abstract ISnapshot createSnapshot(IProgressMonitor var1) throws TeamRepositoryException;

    public abstract ITeamRepository getRepository();

    public abstract IItemHandle getIdentifyingHandle();

    public static SnapshotId getSnapshotId(IItemHandle itemHandle) {
        if (itemHandle == null || !(itemHandle.getOrigin() instanceof ITeamRepository)) {
            throw new IllegalArgumentException("Handle must have a team repository origin");
        }
        return SnapshotId.getSnapshotId((ITeamRepository)itemHandle.getOrigin(), itemHandle);
    }

    public static SnapshotId getSnapshotId(ITeamRepository repo, IItemHandle itemHandle) {
        if (itemHandle instanceof IBaselineHandle) {
            IBaselineHandle baseline = (IBaselineHandle)itemHandle;
            return BaselineId.create(repo, baseline);
        }
        if (itemHandle instanceof IBaselineSetHandle) {
            IBaselineSetHandle baselineSet = (IBaselineSetHandle)itemHandle;
            return BaselineSetId.create(repo, baselineSet);
        }
        if (itemHandle instanceof IWorkspaceHandle) {
            IWorkspaceHandle workspace = (IWorkspaceHandle)itemHandle;
            return WorkspaceId.create(repo, workspace);
        }
        return SnapshotId.createEmptyId(repo);
    }

    public boolean isEmpty() {
        return false;
    }

    public IConnection getConnection(IProgressMonitor monitor) throws TeamRepositoryException {
        return null;
    }
}

