/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.util.ConnectionUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.ConnectionDescriptor;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IFlowNodeHandle;
import com.ibm.team.scm.common.IFlowTable;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class FlowTableUtil {
    public static void addCollaboration(IWorkspaceConnection local, IWorkspaceConnection remote, IProgressMonitor monitor) throws TeamRepositoryException {
        IFlowTable flowTable = local.getFlowTable().getWorkingCopy();
        FlowTableUtil.addCollaboration(flowTable, local, remote);
        local.setFlowTable(flowTable, monitor);
    }

    public static void addCollaboration(IFlowTable flowTable, IWorkspaceConnection local, IWorkspaceConnection remote) throws TeamRepositoryException {
        List<IComponentHandle> components = FlowTableUtil.getCommonComponents((IConnection)local, (IConnection)remote);
        IWorkspaceHandle target = (IWorkspaceHandle)remote.getResolvedWorkspace().getItemHandle();
        UUID remoteRepoId = null;
        String remoteRepoURI = null;
        if (!local.sameRepository((IConnection)remote)) {
            ITeamRepository remoteRepo = remote.teamRepository();
            remoteRepoId = remoteRepo.getId();
            remoteRepoURI = remoteRepo.getRepositoryURI();
        }
        flowTable.addAcceptFlow((IFlowNodeHandle)target, remoteRepoId, remoteRepoURI, (Collection)Collections.EMPTY_LIST, null);
        flowTable.addDeliverFlow((IFlowNodeHandle)target, remoteRepoId, remoteRepoURI, components, null);
        List acceptSources = flowTable.acceptSources();
        boolean setNewDefaultCurrent = true;
        for (Object obj : acceptSources) {
            IFlowEntry entry = (IFlowEntry)obj;
            IFlowNodeHandle flowNode = entry.getFlowNode();
            if (flowNode.sameItemId(remote.getResolvedWorkspace().getItemHandle()) || flowNode.sameItemId(local.getResolvedWorkspace().getItemHandle())) continue;
            setNewDefaultCurrent = false;
            break;
        }
        if (setNewDefaultCurrent) {
            FlowTableUtil.setDefaultCollaboration(flowTable, target);
            FlowTableUtil.setCurrentCollaboration(flowTable, target);
        }
    }

    private static List<IComponentHandle> getCommonComponents(IConnection c1, IConnection c2) throws TeamRepositoryException {
        Map<UUID, IComponentHandle> components1 = FlowTableUtil.getComponents(c1);
        Map<UUID, IComponentHandle> components2 = FlowTableUtil.getComponents(c2);
        ArrayList<IComponentHandle> result = new ArrayList<IComponentHandle>();
        for (Map.Entry<UUID, IComponentHandle> entry : components1.entrySet()) {
            if (!components2.containsKey(entry.getKey())) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    private static Map<UUID, IComponentHandle> getComponents(IConnection connection) throws TeamRepositoryException {
        try {
            if (connection instanceof IWorkspaceConnection) {
                HashMap<UUID, IComponentHandle> result = new HashMap<UUID, IComponentHandle>();
                for (IComponentHandle component : ((IWorkspaceConnection)connection).getComponents()) {
                    result.put(component.getItemId(), component);
                }
                return result;
            }
            if (connection instanceof IBaselineConnection) {
                IComponentHandle component = ((IBaselineConnection)connection).getComponent();
                return Collections.singletonMap(component.getItemId(), component);
            }
            throw new IllegalArgumentException("Unsupported type " + connection);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            return Collections.EMPTY_MAP;
        }
    }

    public static void removeCollaboration(IWorkspaceConnection local, IWorkspaceConnection remote, IProgressMonitor monitor) throws TeamRepositoryException {
        IFlowTable flowTable = local.getFlowTable().getWorkingCopy();
        FlowTableUtil.removeCollaboration(flowTable, (IWorkspaceHandle)remote.getResolvedWorkspace());
        local.setFlowTable(flowTable, monitor);
    }

    public static void removeCollaboration(IFlowTable flowTable, IWorkspaceHandle remote) {
        flowTable.removeAcceptFlow((IFlowNodeHandle)remote);
        flowTable.removeDeliverFlow((IFlowNodeHandle)remote);
    }

    public static void removeCollaboration(IWorkspaceConnection local, IFlowNodeHandle remote, IProgressMonitor monitor) throws TeamRepositoryException {
        IFlowTable flowTable = local.getFlowTable().getWorkingCopy();
        flowTable.removeAcceptFlow(remote);
        flowTable.removeDeliverFlow(remote);
        local.setFlowTable(flowTable, monitor);
    }

    public static boolean hasCollaboration(IWorkspaceConnection local, IWorkspaceConnection remote) throws TeamRepositoryException {
        IWorkspace target = remote.getResolvedWorkspace();
        return local.getFlowTable().getAcceptFlow((IFlowNodeHandle)target) != null || local.getFlowTable().getDeliverFlow((IFlowNodeHandle)target) != null;
    }

    public static boolean hasCollaboration(IWorkspaceConnection local) {
        return !local.getFlowTable().acceptSources().isEmpty() || !local.getFlowTable().deliverTargets().isEmpty();
    }

    public static void setDefaultCollaboration(IFlowTable flowTable, IWorkspaceHandle target) {
        if (target == null) {
            flowTable.unsetDefaultAcceptFlow();
            flowTable.unsetDefaultDeliverFlow();
        } else {
            IFlowEntry deliverEntry;
            IFlowEntry acceptEntry = flowTable.getAcceptFlow((IFlowNodeHandle)target);
            if (acceptEntry != null) {
                flowTable.setDefault(acceptEntry);
            }
            if ((deliverEntry = flowTable.getDeliverFlow((IFlowNodeHandle)target)) != null) {
                flowTable.setDefault(deliverEntry);
            }
        }
    }

    public static IWorkspaceConnection[] getAllAccessibleCollaborations(IWorkspaceConnection connection, IRepositoryResolver resolver, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IWorkspaceConnection> result = new ArrayList<IWorkspaceConnection>();
        IFlowTable flowTable = connection.getFlowTable();
        Map<ITeamRepository, List<IWorkspaceHandle>> requests = FlowTableUtil.getAllCollaborationHandles(connection, resolver, flowTable);
        result.addAll(ConnectionUtil.getAccessibleConnections(requests, monitor));
        return result.toArray(new IWorkspaceConnection[result.size()]);
    }

    public static IWorkspaceConnection[] getAllCollaborations(IWorkspaceConnection connection, IRepositoryResolver resolver, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IWorkspaceConnection> result = new ArrayList<IWorkspaceConnection>();
        IFlowTable flowTable = connection.getFlowTable();
        Map<ITeamRepository, List<IWorkspaceHandle>> requests = FlowTableUtil.getAllCollaborationHandles(connection, resolver, flowTable);
        result.addAll(ConnectionUtil.getConnections(requests, monitor));
        return result.toArray(new IWorkspaceConnection[result.size()]);
    }

    private static Map<ITeamRepository, List<IWorkspaceHandle>> getAllCollaborationHandles(IWorkspaceConnection connection, IRepositoryResolver resolver, IFlowTable flowTable) {
        HashMap<ITeamRepository, List<IWorkspaceHandle>> workspacesByRepos = new HashMap<ITeamRepository, List<IWorkspaceHandle>>();
        for (IFlowEntry entry : flowTable.acceptSources()) {
            ArrayList<IWorkspaceHandle> wsHandles;
            if (!(entry.getFlowNode() instanceof IWorkspaceHandle)) continue;
            ITeamRepository repo = connection.teamRepository();
            if (entry.getRemoteRepositoryURI() != null || entry.getRemoteRepositoryIdentifier() != null) {
                try {
                    repo = resolver.getRepoFor(entry.getRemoteRepositoryURI(), entry.getRemoteRepositoryIdentifier());
                }
                catch (TeamRepositoryException teamRepositoryException) {
                    continue;
                }
            }
            if ((wsHandles = (ArrayList<IWorkspaceHandle>)workspacesByRepos.get(repo)) == null) {
                wsHandles = new ArrayList<IWorkspaceHandle>();
                workspacesByRepos.put(repo, wsHandles);
            }
            wsHandles.add((IWorkspaceHandle)entry.getFlowNode());
        }
        return workspacesByRepos;
    }

    public static void setCurrentCollaboration(IFlowTable flowTable, IWorkspaceHandle target) {
        if (target == null) {
            flowTable.unsetCurrentAcceptFlow();
            flowTable.unsetCurrentDeliverFlow();
        } else {
            IFlowEntry deliverEntry;
            IFlowEntry acceptEntry = flowTable.getAcceptFlow((IFlowNodeHandle)target);
            if (acceptEntry != null) {
                flowTable.setCurrent(acceptEntry);
            }
            if ((deliverEntry = flowTable.getDeliverFlow((IFlowNodeHandle)target)) != null) {
                flowTable.setCurrent(deliverEntry);
            }
        }
    }

    public static ConnectionDescriptor getCurrentCollaborationDescriptor(IWorkspaceConnection connection) {
        IFlowTable flowTable = connection.getFlowTable();
        ITeamRepository repository = connection.teamRepository();
        IFlowEntry entry = flowTable.getCurrentAcceptFlow();
        return FlowTableUtil.getConnectionDescriptor(entry, repository);
    }

    public static ConnectionDescriptor getCurrentCollaborationDescriptor(IWorkspaceConnection connection, IComponentHandle component) {
        IFlowTable flowTable = connection.getFlowTable();
        IFlowEntry entry = flowTable.getCurrentAcceptFlow(component);
        return FlowTableUtil.getConnectionDescriptor(entry, connection.teamRepository());
    }

    private static ConnectionDescriptor getConnectionDescriptor(IFlowEntry entry, ITeamRepository repository) {
        if (entry != null && entry.getFlowNode() instanceof IWorkspaceHandle) {
            IWorkspaceHandle handle = (IWorkspaceHandle)entry.getFlowNode();
            UUID repositoryId = repository.getId();
            String repositoryURI = repository.getRepositoryURI();
            if (entry.getRemoteRepositoryURI() != null) {
                repositoryURI = entry.getRemoteRepositoryURI();
            }
            if (entry.getRemoteRepositoryIdentifier() != null) {
                repositoryId = entry.getRemoteRepositoryIdentifier();
            }
            return new ConnectionDescriptor(repositoryId, repositoryURI, (IContextHandle)handle);
        }
        return null;
    }

    public static void setCurrentCollaboration(IFlowTable flowTable, IComponentHandle component, IWorkspaceHandle target) {
        if (target == null) {
            flowTable.unsetCurrentAcceptFlow(component);
            flowTable.unsetCurrentDeliverFlow(component);
        } else {
            IFlowEntry deliverEntry;
            IFlowEntry acceptEntry = flowTable.getAcceptFlow((IFlowNodeHandle)target);
            if (acceptEntry != null) {
                flowTable.setCurrent(acceptEntry, component);
            }
            if ((deliverEntry = flowTable.getDeliverFlow((IFlowNodeHandle)target)) != null) {
                flowTable.setCurrent(deliverEntry, component);
            }
        }
    }
}

