/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class InternalCommonMessages {
    private static volatile ICommonMessagesProvider MESSAGES_PROVIDER = InternalCommonMessages.createDefaultMessagesProvider();

    private static ICommonMessagesProvider createDefaultMessagesProvider() {
        return new ICommonMessagesProvider(){

            private Class<?> getClass(Object object) {
                Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
                return clazz;
            }

            private ClassLoader getClassLoader(Object object) {
                Class<?> clazz = this.getClass(object);
                ClassLoader classLoader = clazz.getClassLoader();
                return classLoader;
            }

            @Override
            public String getString(Object receiver, String bundleName, String key) {
                ClassLoader classLoader = this.getClassLoader(receiver);
                ResourceBundle bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault(), classLoader);
                try {
                    return bundle.getString(key);
                }
                catch (MissingResourceException missingResourceException) {
                    return String.valueOf('!') + key + '!';
                }
            }
        };
    }

    public static ICommonMessagesProvider getMessagesProvider() {
        return MESSAGES_PROVIDER;
    }

    public static void setServerMessages(ICommonMessagesProvider messagesProvider) {
        if (messagesProvider == null) {
            throw new IllegalArgumentException("messagesProvider must not be null");
        }
        MESSAGES_PROVIDER = messagesProvider;
    }

    private InternalCommonMessages() {
    }

    public static interface ICommonMessagesProvider {
        public String getString(Object var1, String var2, String var3);
    }
}

