/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.internal.util.IComponentElementDescriptor;
import com.ibm.team.repository.common.internal.util.IModelElementDescriptor;
import com.ibm.team.repository.common.internal.util.IServiceElementDescriptor;
import com.ibm.team.repository.common.internal.util.ModelElementDescriptor;
import com.ibm.team.repository.common.internal.util.ServiceElementDescriptor;
import com.ibm.team.repository.common.transport.AbstractElementDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.core.runtime.IConfigurationElement;

public class ComponentElementDescriptor
extends AbstractElementDescriptor
implements IComponentElementDescriptor {
    private volatile String componentConfigurationAttribute;
    private volatile String idAttribute;
    private volatile String nameAttribute;
    private volatile IModelElementDescriptor modelElementDescriptor;
    private volatile ConcurrentMap<String, IServiceElementDescriptor> serviceDescriptorsMap;
    private volatile ConcurrentMap<String, IModelElementDescriptor> dtoModelDescriptorsMap;

    public ComponentElementDescriptor(IConfigurationElement element) {
        super(element, "component");
    }

    private void addServiceElementDescriptor(IServiceElementDescriptor descriptor) {
        String serviceUri = descriptor.getUriAttribute();
        if (serviceUri == null) {
            return;
        }
        this.addServiceElementDescriptor(serviceUri, descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addServiceElementDescriptor(String serviceUri, IServiceElementDescriptor descriptor) {
        Map<String, IServiceElementDescriptor> map;
        Map<String, IServiceElementDescriptor> map2 = map = this.getServiceDescriptorsMap();
        synchronized (map2) {
            map.put(serviceUri, descriptor);
        }
    }

    private void addDtoModelElementDescriptor(IModelElementDescriptor descriptor) {
        String serviceUri = descriptor.getUriAttribute();
        if (serviceUri == null) {
            return;
        }
        this.addDtoModelElementDescriptor(serviceUri, descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDtoModelElementDescriptor(String serviceUri, IModelElementDescriptor descriptor) {
        Map<String, IModelElementDescriptor> map;
        Map<String, IModelElementDescriptor> map2 = map = this.getDtoModelDescriptorsMap();
        synchronized (map2) {
            map.put(serviceUri, descriptor);
        }
    }

    @Override
    protected void checkElement() {
        this.checkIdAttribute();
        this.checkNameAttribute();
    }

    private void checkIdAttribute() {
        String value = this.getIdAttribute();
        this.checkAttributeIsSet(value, "id");
    }

    private void checkNameAttribute() {
        String value = this.getNameAttribute();
        this.checkAttributeIsSet(value, "name");
    }

    @Override
    public boolean containsService(String serviceUri) {
        if (serviceUri == null) {
            throw new IllegalArgumentException("serviceUri must not be null");
        }
        return this.getServiceDescriptorsMap().containsKey(serviceUri);
    }

    @Override
    public String getComponentConfigurationAttribute() {
        return this.componentConfigurationAttribute;
    }

    @Override
    public String getIdAttribute() {
        return this.idAttribute;
    }

    @Override
    public IModelElementDescriptor getModelElementDescriptor() {
        return this.modelElementDescriptor;
    }

    @Override
    public String getNameAttribute() {
        return this.nameAttribute;
    }

    private Map<String, IServiceElementDescriptor> getServiceDescriptorsMap() {
        return this.serviceDescriptorsMap;
    }

    private Map<String, IModelElementDescriptor> getDtoModelDescriptorsMap() {
        return this.dtoModelDescriptorsMap;
    }

    @Override
    public IServiceElementDescriptor getServiceElementDescriptor(String serviceUri) {
        if (serviceUri == null) {
            throw new IllegalArgumentException("serviceUri must not be null");
        }
        return this.getServiceDescriptorsMap().get(serviceUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IServiceElementDescriptor> getServiceElementDescriptors() {
        ArrayList<IServiceElementDescriptor> list;
        Map<String, IServiceElementDescriptor> map;
        Map<String, IServiceElementDescriptor> map2 = map = this.getServiceDescriptorsMap();
        synchronized (map2) {
            Collection<IServiceElementDescriptor> values = map.values();
            int size = values.size();
            list = new ArrayList<IServiceElementDescriptor>(size);
            list.addAll(values);
        }
        return list;
    }

    @Override
    public IModelElementDescriptor getModelElementDescriptor(String modelUri) {
        if (modelUri == null) {
            throw new IllegalArgumentException("modelUri must not be null");
        }
        if (modelUri.equals(this.getModelElementDescriptor().getUriAttribute())) {
            return this.getModelElementDescriptor();
        }
        return this.getDtoModelDescriptorsMap().get(modelUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IModelElementDescriptor> getDtoModelElementDescriptors() {
        ArrayList<IModelElementDescriptor> list;
        Map<String, IModelElementDescriptor> map;
        Map<String, IModelElementDescriptor> map2 = map = this.getDtoModelDescriptorsMap();
        synchronized (map2) {
            Collection<IModelElementDescriptor> values = map.values();
            int size = values.size();
            list = new ArrayList<IModelElementDescriptor>(size);
            list.addAll(values);
        }
        return list;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setComponentConfigurationAttribute(this.getAttribute("componentConfiguration"));
        this.setIdAttribute(this.getAttribute("id"));
        this.setNameAttribute(this.getAttribute("name"));
        this.setServiceDescriptorsMap(new ConcurrentHashMap<String, IServiceElementDescriptor>(101, 0.75f, 1));
        this.setDtoModelDescriptorsMap(new ConcurrentHashMap<String, IModelElementDescriptor>(10, 0.75f, 1));
    }

    private void printIdAttributeOn(StringBuffer buffer) {
        String value = this.getIdAttribute();
        this.printOn(buffer, "id", value);
    }

    private void printModelElementDescriptorOn(StringBuffer buffer) {
        IModelElementDescriptor value = this.getModelElementDescriptor();
        this.printOn(buffer, "modelElementDescriptor", value);
    }

    private void printNameAttributeOn(StringBuffer buffer) {
        String value = this.getNameAttribute();
        this.printOn(buffer, "name", value);
    }

    @Override
    protected void printOn(StringBuffer buffer) {
        super.printOn(buffer);
        this.printIdAttributeOn(buffer);
        this.printNameAttributeOn(buffer);
        this.printModelElementDescriptorOn(buffer);
    }

    @Override
    protected void processChild(IConfigurationElement child) {
        String name = child.getName();
        if (name.equalsIgnoreCase("service")) {
            ServiceElementDescriptor descriptor = new ServiceElementDescriptor(child);
            this.addServiceElementDescriptor(descriptor);
        } else if (name.equalsIgnoreCase("model")) {
            IModelElementDescriptor descriptor = this.getModelElementDescriptor();
            if (descriptor != null) {
                String bundleSymbolicName = this.getBundleSymbolicName();
                String id = this.getIdAttribute();
                String pattern = "The %s bundle's plugin.xml file has a <%s %s=\"%s\"> element that contains multiple <%s> child elements when only 0 or 1 is allowed.";
                String message = String.format(pattern, bundleSymbolicName, "component", "id", id, "model");
                throw new IllegalArgumentException(message);
            }
            descriptor = new ModelElementDescriptor(child);
            this.setModelElementDescriptor(descriptor);
        } else if (name.equalsIgnoreCase("dtoModel")) {
            ModelElementDescriptor descriptor = new ModelElementDescriptor(child);
            this.addDtoModelElementDescriptor(descriptor);
        } else {
            super.processChild(child);
        }
    }

    private void setComponentConfigurationAttribute(String componentConfiguration) {
        this.componentConfigurationAttribute = componentConfiguration;
    }

    private void setIdAttribute(String id) {
        this.idAttribute = id;
    }

    private void setModelElementDescriptor(IModelElementDescriptor modelElementDescriptor) {
        this.modelElementDescriptor = modelElementDescriptor;
    }

    private void setServiceDescriptorsMap(ConcurrentMap<String, IServiceElementDescriptor> serviceDescriptorsMap) {
        this.serviceDescriptorsMap = serviceDescriptorsMap;
    }

    private void setDtoModelDescriptorsMap(ConcurrentMap<String, IModelElementDescriptor> dtoModelDescriptorsMap) {
        this.dtoModelDescriptorsMap = dtoModelDescriptorsMap;
    }

    private void setNameAttribute(String nameAttribute) {
        this.nameAttribute = nameAttribute;
    }
}

