/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.model.impl;

import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ComponentRegistry;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.Item;
import com.ibm.team.repository.common.model.ItemHandle;
import com.ibm.team.repository.common.model.ItemType;
import com.ibm.team.repository.common.model.RepositoryPackage;
import com.ibm.team.repository.common.model.impl.TypeImpl;
import com.ibm.team.repository.common.query.ast.IDynamicItemQueryModel;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class ItemTypeImpl
extends TypeImpl
implements ItemType {
    Boolean fRedactable = null;

    protected ItemTypeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return RepositoryPackage.eINSTANCE.getItemType();
    }

    @Override
    public boolean isAuditable() {
        EClass eClass = ItemUtil.getTypeEClass(this);
        if (eClass == null) {
            return false;
        }
        return RepositoryPackage.eINSTANCE.getAuditable().isSuperTypeOf(eClass);
    }

    @Override
    public boolean isUnmanaged() {
        EClass eClass = ItemUtil.getTypeEClass(this);
        if (eClass == null) {
            return false;
        }
        return RepositoryPackage.eINSTANCE.getUnmanagedItem().isSuperTypeOf(eClass);
    }

    @Override
    public boolean isSimple() {
        EClass eClass = ItemUtil.getTypeEClass(this);
        if (eClass == null) {
            return false;
        }
        return RepositoryPackage.eINSTANCE.getSimpleItem().isSuperTypeOf(eClass);
    }

    @Override
    public boolean isConfigurationAware() {
        EClass eClass = ItemUtil.getTypeEClass(this);
        if (eClass == null) {
            return false;
        }
        return RepositoryPackage.eINSTANCE.getConfigurationAwareSimpleItem().isSuperTypeOf(eClass) || RepositoryPackage.eINSTANCE.getConfigurationAwareAuditable().isSuperTypeOf(eClass);
    }

    @Override
    public boolean isRedactable() {
        if (this.fRedactable == null) {
            this.fRedactable = new Boolean(ItemUtil.isRedactable(this));
        }
        return this.fRedactable;
    }

    @Override
    public IItem createItem() {
        EObject eObject;
        this.ensureConcrete();
        EClass eClass = ItemUtil.getTypeEClass(this);
        if (eClass != null && (eObject = eClass.getEPackage().getEFactoryInstance().create(eClass)) instanceof Item) {
            Item item = (Item)eObject;
            item.initNew();
            return item;
        }
        return null;
    }

    private void ensureConcrete() {
        if (this.isAbstract()) {
            throw new IllegalStateException("Cannot create abstract items");
        }
    }

    @Override
    public IItem createItem(Object origin) {
        EObject eObject;
        this.ensureConcrete();
        if (origin == null) {
            throw new IllegalArgumentException();
        }
        EClass eClass = ItemUtil.getTypeEClass(this);
        if (eClass != null && (eObject = eClass.getEPackage().getEFactoryInstance().create(eClass)) instanceof Item) {
            Item item = (Item)eObject;
            item.setOrigin(origin);
            item.initNew();
            return item;
        }
        return null;
    }

    @Override
    public IItemHandle createItemHandle(UUID itemId, UUID optionalStateId) {
        EObject eObject;
        this.ensureConcrete();
        if (itemId == null) {
            throw new IllegalArgumentException();
        }
        EClass eClass = ItemUtil.getHandleEClass(this);
        if (eClass != null && (eObject = eClass.getEPackage().getEFactoryInstance().create(eClass)) instanceof ItemHandle) {
            ItemHandle handle = (ItemHandle)eObject;
            handle.setItemId(itemId);
            handle.setStateId(optionalStateId);
            return handle;
        }
        return null;
    }

    @Override
    public IItemHandle createItemHandle(Object origin, UUID itemId, UUID optionalStateId) {
        this.ensureConcrete();
        if (origin == null) {
            throw new IllegalArgumentException();
        }
        IItemHandle handle = this.createItemHandle(itemId, optionalStateId);
        ((ItemHandle)handle).setOrigin(origin);
        return handle;
    }

    @Override
    public boolean allowsStateExtensions() {
        return ItemUtil.allowsStateExtensions(this);
    }

    @Override
    public String idPropertyName() {
        return ItemUtil.getIdProperty(this);
    }

    @Override
    public IDynamicItemQueryModel getQueryModel() {
        return (IDynamicItemQueryModel)ItemUtil.getQueryModel(this);
    }

    @Override
    public boolean isPublic() {
        return ComponentRegistry.INSTANCE.isUsingPublicReadAccessPolicy(this);
    }

    @Override
    public boolean isProtected() {
        return ComponentRegistry.INSTANCE.isUsingProtectedReadAccessPolicy(this);
    }

    @Override
    public boolean isApplicationManaged() {
        return ComponentRegistry.INSTANCE.isUsingApplicationManagedReadAccessPolicy(this);
    }

    @Override
    public boolean isInternal() {
        return ComponentRegistry.INSTANCE.isUsingInternalReadAccessPolicy(this);
    }

    @Override
    public boolean isStoreableInCommonConfiguration() {
        return ComponentRegistry.INSTANCE.isStoreableInCommonConfiguration(this);
    }
}

