/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.util;

import com.ibm.team.repository.common.util.HashUtil;
import com.ibm.team.repository.common.util.MessageBundle;
import com.ibm.team.repository.common.util.SettableSoftReference;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JazzLog
implements Log {
    private static final SettableSoftReference<Map<Integer, Integer>> stackTraceHashes = new SettableSoftReference(new HashMap());
    private final MessageBundle bundle;
    private final Log innerLog;

    private JazzLog(Class<?> forClass) {
        this.innerLog = LogFactory.getLog(forClass);
        this.bundle = MessageBundle.findBundle(forClass);
    }

    private JazzLog(String name, Class<?> bundleClass) {
        this.innerLog = LogFactory.getLog((String)name);
        this.bundle = MessageBundle.findBundle(bundleClass);
    }

    private JazzLog(String name) {
        this(name, JazzLog.class);
    }

    public static JazzLog getLog(Class<?> c) {
        return new JazzLog(c);
    }

    public static JazzLog getLog(String name) {
        return new JazzLog(name);
    }

    public static JazzLog getLog(String name, Class<?> c) {
        return new JazzLog(name, c);
    }

    public void logConsoleMsg(String messageKey, Object ... args) {
        String message = this.bundle.getString(messageKey, args);
        this.logConsole(message);
    }

    public void logConsole(String message) {
        System.out.println(message);
        this.info(message);
    }

    public void logConsole(String message, Object ... args) {
        System.out.println(this.format(message, args));
        this.info(message);
    }

    public void fatalMsg(String messageKey, Object ... args) {
        this.fatalMsg(messageKey, null, args);
    }

    public void errorMsg(String messageKey, Object ... args) {
        this.errorMsg(messageKey, null, args);
    }

    public void warnMsg(String messageKey, Object ... args) {
        this.warnMsg(messageKey, null, args);
    }

    public void infoMsg(String messageKey, Object ... args) {
        this.infoMsg(messageKey, null, args);
    }

    public void debugMsg(String messageKey, Object ... args) {
        this.debugMsg(messageKey, null, args);
    }

    public void traceMsg(String messageKey, Object ... args) {
        this.traceMsg(messageKey, null, args);
    }

    public void fatalMsg(String messageKey, Throwable cause, Object ... args) {
        if (this.isFatalEnabled()) {
            String message = this.bundle.getString(messageKey, args);
            this.fatal((Object)message, cause);
        }
    }

    public void errorMsg(String messageKey, Throwable cause, Object ... args) {
        if (this.isErrorEnabled()) {
            String message = this.bundle.getString(messageKey, args);
            this.error((Object)message, cause);
        }
    }

    public void warnMsg(String messageKey, Throwable cause, Object ... args) {
        if (this.isWarnEnabled()) {
            String message = this.bundle.getString(messageKey, args);
            this.warn((Object)message, cause);
        }
    }

    public void infoMsg(String messageKey, Throwable cause, Object ... args) {
        if (this.isInfoEnabled()) {
            String message = this.bundle.getString(messageKey, args);
            this.info((Object)message, cause);
        }
    }

    public void debugMsg(String messageKey, Throwable cause, Object ... args) {
        if (this.isDebugEnabled()) {
            String message = this.bundle.getString(messageKey, args);
            this.debug((Object)message, cause);
        }
    }

    public void traceMsg(String messageKey, Throwable cause, Object ... args) {
        if (this.isTraceEnabled()) {
            String message = this.bundle.getString(messageKey, args);
            this.trace((Object)message, cause);
        }
    }

    public void debug(Object message, Throwable cause, Object ... args) {
        if (this.isDebugEnabled()) {
            this.innerLog.debug((Object)this.format(message, args), cause);
        }
    }

    public void error(Object message, Throwable cause, Object ... args) {
        if (this.isErrorEnabled()) {
            this.innerLog.error((Object)this.format(message, args), cause);
        }
    }

    public void warn(Object message, Throwable cause, Object ... args) {
        if (this.isWarnEnabled()) {
            this.innerLog.warn((Object)this.format(message, args), cause);
        }
    }

    public void info(Object message, Throwable cause, Object ... args) {
        if (this.isInfoEnabled()) {
            this.innerLog.info((Object)this.format(message, args), cause);
        }
    }

    public void trace(Object message, Throwable cause, Object ... args) {
        if (this.isTraceEnabled()) {
            this.innerLog.trace((Object)this.format(message, args), cause);
        }
    }

    public void fatal(Object message, Throwable cause, Object ... args) {
        if (this.isFatalEnabled()) {
            this.innerLog.fatal((Object)this.format(message, args), cause);
        }
    }

    public void debug(Object message, Object ... args) {
        this.debug(message, null, args);
    }

    public void error(Object message, Object ... args) {
        this.error(message, null, args);
    }

    public void warn(Object message, Object ... args) {
        this.warn(message, null, args);
    }

    public void info(Object message, Object ... args) {
        this.info(message, null, args);
    }

    public void trace(Object message, Object ... args) {
        this.trace(message, null, args);
    }

    public void fatal(Object message, Object ... args) {
        this.fatal(message, null, args);
    }

    public void debug(Throwable t) {
        this.debug((Object)t.getLocalizedMessage(), t);
    }

    public void error(Throwable t) {
        this.error((Object)t.getLocalizedMessage(), t);
    }

    public void warn(Throwable t) {
        this.warn((Object)t.getLocalizedMessage(), t);
    }

    public void info(Throwable t) {
        this.info((Object)t.getLocalizedMessage(), t);
    }

    public void trace(Throwable t) {
        this.trace((Object)t.getLocalizedMessage(), t);
    }

    public void fatal(Throwable t) {
        this.fatal((Object)t.getLocalizedMessage(), t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHashString(Throwable t) {
        if (t != null) {
            int stHash = HashUtil.getStackTraceHashCode(t);
            Integer count = null;
            SettableSoftReference<Map<Integer, Integer>> settableSoftReference = stackTraceHashes;
            synchronized (settableSoftReference) {
                Map m = stackTraceHashes.get();
                if (m == null) {
                    m = stackTraceHashes.set(new HashMap());
                }
                if ((count = m.get(stHash)) == null) {
                    m.put(stHash, 1);
                    return String.valueOf('[') + Integer.toHexString(stHash) + ']' + ' ';
                }
                m.put(stHash, count + 1);
            }
            return String.valueOf('[') + Integer.toHexString(stHash) + '.' + (count + 1) + ']' + ' ';
        }
        return null;
    }

    private String getMessageWithHash(Object message, String stackTraceHash) {
        if (stackTraceHash == null) {
            return String.valueOf(message);
        }
        return String.valueOf(stackTraceHash) + String.valueOf(message);
    }

    private Throwable filterThrowable(Throwable t, String stackTraceHash) {
        if (t != null && stackTraceHash.indexOf(46) == -1) {
            return t;
        }
        return null;
    }

    private String format(Object msg, Object ... args) {
        if (msg == null) {
            return null;
        }
        if (args.length == 0) {
            return msg.toString();
        }
        int i = 0;
        while (i < args.length) {
            args[i] = this.getArg(args[i]);
            ++i;
        }
        return MessageFormat.format(msg.toString(), args);
    }

    private Object getArg(Object arg) {
        if (arg != null && arg.getClass().isArray()) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            int i = 0;
            while (i < Array.getLength(arg)) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.getArg(Array.get(arg, i)));
                ++i;
            }
            sb.append(']');
            return sb.toString();
        }
        return arg;
    }

    public boolean isDebugEnabled() {
        return this.innerLog.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.innerLog.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.innerLog.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.innerLog.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.innerLog.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.innerLog.isWarnEnabled();
    }

    public void trace(Object message) {
        this.innerLog.trace(message);
    }

    public void trace(Object message, Throwable t) {
        if (this.isTraceEnabled()) {
            String h = this.getHashString(t);
            this.innerLog.trace((Object)this.getMessageWithHash(message, h), this.filterThrowable(t, h));
        }
    }

    public void debug(Object message) {
        this.innerLog.debug(message);
    }

    public void debug(Object message, Throwable t) {
        if (this.isDebugEnabled()) {
            String h = this.getHashString(t);
            this.innerLog.debug((Object)this.getMessageWithHash(message, h), this.filterThrowable(t, h));
        }
    }

    public void info(Object message) {
        this.innerLog.info(message);
    }

    public void info(Object message, Throwable t) {
        if (this.isInfoEnabled()) {
            String h = this.getHashString(t);
            this.innerLog.info((Object)this.getMessageWithHash(message, h), this.filterThrowable(t, h));
        }
    }

    public void warn(Object message) {
        this.innerLog.warn(message);
    }

    public void warn(Object message, Throwable t) {
        if (this.isWarnEnabled()) {
            String h = this.getHashString(t);
            this.innerLog.warn((Object)this.getMessageWithHash(message, h), this.filterThrowable(t, h));
        }
    }

    public void error(Object message) {
        this.innerLog.error(message);
    }

    public void error(Object message, Throwable t) {
        if (this.isErrorEnabled()) {
            String h = this.getHashString(t);
            this.innerLog.error((Object)this.getMessageWithHash(message, h), this.filterThrowable(t, h));
        }
    }

    public void fatal(Object message) {
        this.innerLog.fatal(message);
    }

    public void fatal(Object message, Throwable t) {
        if (this.isFatalEnabled()) {
            String h = this.getHashString(t);
            this.innerLog.fatal((Object)this.getMessageWithHash(message, h), this.filterThrowable(t, h));
        }
    }
}

