/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.auth;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Tracer {
    private final Log _logger;
    private final int _indent;
    private final int INDENT_DEFAULT = Integer.parseInt(System.getProperty("jazz.trace.indentLevel", "2"));
    private final Class<?> _class;
    private static ThreadLocal<Integer> _callDepth = new ThreadLocal();

    public Tracer() {
        this._class = null;
        this._logger = LogFactory.getLog(this.getClass());
        this._indent = this.INDENT_DEFAULT;
    }

    public Tracer(Class<?> clazz) {
        this._class = clazz;
        this._logger = LogFactory.getLog(this.getClass());
        this._indent = this.INDENT_DEFAULT;
    }

    public Tracer(Class<?> clazz, Log log) {
        this._class = clazz;
        this._logger = log == null ? LogFactory.getLog(this.getClass()) : log;
        this._indent = this.INDENT_DEFAULT;
    }

    public void reset() {
        this.setCallDepth(this._indent);
    }

    public void debug(String message, Object ... args) {
        if (message == null) {
            return;
        }
        if (this._logger.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer(127);
            this.incrementCallDepth();
            buf.append(this.getIndentString());
            this.decrementCallDepth();
            buf.append(String.format(message, args));
            this._logger.debug((Object)buf.toString());
        }
    }

    public void trace(String message, Object ... args) {
        if (message == null) {
            return;
        }
        if (this._logger.isTraceEnabled()) {
            StringBuffer buf = new StringBuffer(127);
            this.incrementCallDepth();
            buf.append(this.getIndentString());
            this.decrementCallDepth();
            buf.append(String.format(message, args));
            this._logger.trace((Object)buf.toString());
        }
    }

    public void enter(String message, Object ... args) {
        if (message == null) {
            return;
        }
        if (this._logger.isTraceEnabled()) {
            this.incrementCallDepth();
            StringBuffer buf = new StringBuffer(127);
            buf.append(this.getIndentString());
            buf.append("[ENTERING] ");
            if (this._class != null) {
                buf.append(this._class.getSimpleName());
                buf.append('#');
            }
            buf.append(String.format(message, args));
            this._logger.trace((Object)buf.toString());
        }
    }

    public void leave(String message, Object ... args) {
        if (message == null) {
            return;
        }
        if (this._logger.isTraceEnabled()) {
            StringBuffer buf = new StringBuffer(127);
            buf.append(this.getIndentString());
            buf.append("[EXITING]  ");
            if (this._class != null) {
                buf.append(this._class.getSimpleName());
                buf.append('#');
            }
            buf.append(String.format(message, args));
            this._logger.trace((Object)buf.toString());
            this.decrementCallDepth();
        }
    }

    private static Integer getCallDepth() {
        Integer ndx = _callDepth.get();
        if (ndx == null) {
            ndx = 0;
            _callDepth.set(ndx);
        }
        return ndx;
    }

    private void setCallDepth(int depth) {
        _callDepth.set(depth);
    }

    private void incrementCallDepth() {
        int ndx = Tracer.getCallDepth();
        this.setCallDepth(ndx += this._indent);
    }

    private void decrementCallDepth() {
        int ndx = Tracer.getCallDepth();
        if (ndx == 0) {
            return;
        }
        this.setCallDepth(ndx -= this._indent);
    }

    private String getIndentString() {
        int ndx = Tracer.getCallDepth();
        char[] chars = new char[ndx];
        int i = 0;
        while (i < ndx) {
            chars[i] = 32;
            ++i;
        }
        return new String(chars);
    }
}

