/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_sheet;

import com.urbancode.air.property.prop_sheet.PropSheet;
import com.urbancode.air.property.prop_value.PropValue;
import com.urbancode.air.property.prop_value.PropValueVCHelper;
import com.urbancode.air.vc.Handle;
import com.urbancode.air.vc.xml.XMLVCHelper;
import com.urbancode.commons.xml.DOMUtils;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropSheetVCHelper
extends XMLVCHelper<PropSheet> {
    public static final String PROP_SHEET_ELEMENT = "propSheet";
    public static final String PROP_SHEETS_ELEMENT = "propSheets";
    public static final String ID_ATTRIBUTE = "id";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String PROP_SHEET_DEF_ID = "propSheetDefId";
    public static final String PROP_SHEET_DEF_HANDLE = "propSheetDefHandle";
    public static final String TEMPLATE_ID = "templatePropSheetId";
    public static final String TEMPLATE_HANDLE = "templatePropSheetHandle";
    public static final String PROP_SHEET_GROUP_HANDLE = "propSheetGroupHandle";

    public PropSheet toObject(Element element) {
        String propSheetGroupHandleString;
        PropSheet result = new PropSheet();
        result.id = this.getUUIDAttribute(element, ID_ATTRIBUTE);
        result.name = this.getNullableStringAttribute(element, NAME_ATTRIBUTE);
        result.propSheetDefId = this.getUUIDAttribute(element, PROP_SHEET_DEF_ID);
        if (element.hasAttribute(PROP_SHEET_DEF_HANDLE)) {
            result.propSheetDefHandleString = element.getAttribute(PROP_SHEET_DEF_HANDLE);
        }
        result.templatePropSheetId = this.getUUIDAttribute(element, TEMPLATE_ID);
        if (element.hasAttribute(TEMPLATE_HANDLE)) {
            result.templateHandleString = element.getAttribute(TEMPLATE_HANDLE);
        }
        if (!StringUtils.isEmpty((String)(propSheetGroupHandleString = element.getAttribute(PROP_SHEET_GROUP_HANDLE)))) {
            result.propSheetGroupHandle = new Handle(propSheetGroupHandleString);
        }
        PropValueVCHelper propValueHelper = new PropValueVCHelper();
        String propValuesName = propValueHelper.getObjectCollectionElementName();
        Element propValuesElement = DOMUtils.getFirstChild((Element)element, (String)propValuesName);
        result.propValues = propValueHelper.toObjectList(propValuesElement);
        for (PropValue propValue : result.propValues) {
            propValue.setPropSheet(result);
        }
        result.getPersistenceData().setDirty(false);
        return result;
    }

    public Element toXML(PropSheet object, Document doc) {
        Element element = doc.createElement(this.getObjectElementName());
        element.setAttribute(ID_ATTRIBUTE, object.getId().toString());
        element.setAttribute(NAME_ATTRIBUTE, object.name);
        if (object.propSheetDefId != null) {
            element.setAttribute(PROP_SHEET_DEF_ID, object.propSheetDefId.toString());
        }
        if (object.propSheetDefHandleString != null) {
            element.setAttribute(PROP_SHEET_DEF_HANDLE, object.propSheetDefHandleString);
        }
        if (object.templatePropSheetId != null) {
            element.setAttribute(TEMPLATE_ID, object.templatePropSheetId.toString());
        }
        if (object.templateHandleString != null) {
            element.setAttribute(TEMPLATE_HANDLE, object.templateHandleString);
        }
        if (object.propSheetGroupHandle != null) {
            element.setAttribute(PROP_SHEET_GROUP_HANDLE, object.propSheetGroupHandle.toString());
        }
        PropValueVCHelper propValueHelper = new PropValueVCHelper();
        Object[] propValueArray = object.propValues.toArray(new PropValue[object.propValues.size()]);
        element.appendChild(propValueHelper.toXML(propValueArray, doc));
        return element;
    }

    public String getObjectElementName() {
        return PROP_SHEET_ELEMENT;
    }

    public String getObjectCollectionElementName() {
        return PROP_SHEETS_ELEMENT;
    }

    public Class<PropSheet> getPersistentClass() {
        return PropSheet.class;
    }
}

