/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.fulltext.common.internal.query;

import com.ibm.team.fulltext.common.IQueryProvider;
import com.ibm.team.fulltext.common.ITokenGroup;
import com.ibm.team.fulltext.common.internal.query.PorterStemmingCache;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

public class DefaultQueryProvider
implements IQueryProvider {
    private static final char WILDCARD_ASTERISK = '*';
    private static final char WILDCARD_MARK = '?';

    @Override
    public Query createQuery(String tokenType, Analyzer analyzer, ITokenGroup tokenGroup) {
        return this.createStandardQuery(tokenType, tokenGroup);
    }

    private Query createStandardQuery(String tokenType, ITokenGroup tokenGroup) {
        BooleanQuery bQuery = new BooleanQuery();
        ITokenGroup subGroup = tokenGroup.getSubGroup(tokenType);
        HashSet<String> usedTokenValues = new HashSet<String>();
        for (Token token : subGroup) {
            String termText = token.term();
            if (usedTokenValues.contains(termText)) continue;
            boolean containsWildcards = this.containsWildcards(termText);
            if (containsWildcards) {
                termText = this.normalizeWildcards(termText);
            }
            DisjunctionMaxQuery disjunctionQuery = new DisjunctionMaxQuery(0.0f);
            Term nameTerm = new Term("_name", termText);
            WildcardQuery query = containsWildcards ? new WildcardQuery(nameTerm) : new TermQuery(nameTerm);
            query.setBoost(2.0f);
            disjunctionQuery.add((Query)query);
            Term contentTerm = new Term("_content", termText);
            query = containsWildcards ? new WildcardQuery(contentTerm) : new TermQuery(contentTerm);
            disjunctionQuery.add((Query)query);
            Term tagsTerm = new Term("_tags", termText);
            query = containsWildcards ? new WildcardQuery(tagsTerm) : new PrefixQuery(tagsTerm);
            disjunctionQuery.add((Query)query);
            String originalText = PorterStemmingCache.get(termText);
            if (originalText != null) {
                tagsTerm = new Term("_tags", originalText);
                query = containsWildcards ? new WildcardQuery(tagsTerm) : new TermQuery(tagsTerm);
                disjunctionQuery.add((Query)query);
            }
            Term metaTerm = new Term("_meta", termText);
            query = containsWildcards ? new WildcardQuery(metaTerm) : new TermQuery(metaTerm);
            disjunctionQuery.add((Query)query);
            bQuery.add(new BooleanClause((Query)disjunctionQuery, BooleanClause.Occur.SHOULD));
            usedTokenValues.add(termText);
        }
        int clauses = bQuery.clauses().size();
        if (clauses > 2) {
            bQuery.setMinimumNumberShouldMatch(clauses - 1);
        } else if (clauses == 2) {
            bQuery.setMinimumNumberShouldMatch(2);
        }
        return bQuery;
    }

    private String normalizeWildcards(String termText) {
        StringBuilder str = new StringBuilder();
        StringReader reader = new StringReader(termText);
        boolean inAsterisk = false;
        try {
            int curChar;
            while ((curChar = reader.read()) != -1) {
                if (curChar == 42) {
                    if (inAsterisk) continue;
                    inAsterisk = true;
                } else {
                    inAsterisk = false;
                }
                str.append((char)curChar);
            }
        }
        catch (IOException iOException) {}
        return str.toString();
    }

    private boolean containsWildcards(String token) {
        return token.indexOf(42) >= 0 || token.indexOf(63) >= 0;
    }
}

