/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.ant.com.urbancode.commons.xml;

import com.urbancode.air.plugin.ant.com.urbancode.commons.xml.XMLParserFactoryHardener;
import com.urbancode.air.plugin.ant.com.urbancode.commons.xml.XercesUtils;
import java.io.Serializable;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;

public class DocumentBuilderFactoryBuilder
implements Cloneable,
Serializable {
    protected static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(DocumentBuilderFactoryBuilder.class);
    boolean disableExternalResources = true;
    boolean disallowDocTypeDecl = false;
    boolean enableSchemaValidation = false;

    public static DocumentBuilderFactoryBuilder newBuilder() {
        return new DocumentBuilderFactoryBuilder();
    }

    public static void hardenFactory(DocumentBuilderFactory factory) {
        DocumentBuilderFactoryBuilder builder = DocumentBuilderFactoryBuilder.newBuilder();
        builder.applyTo(factory);
    }

    protected DocumentBuilderFactoryBuilder() {
    }

    public DocumentBuilderFactoryBuilder extenalResources(boolean allow) {
        this.disableExternalResources = !allow;
        return this;
    }

    public DocumentBuilderFactoryBuilder docTypeDecl(boolean allow) {
        this.disallowDocTypeDecl = !allow;
        return this;
    }

    public DocumentBuilderFactoryBuilder schemaValidation(boolean enable) {
        this.enableSchemaValidation = enable;
        return this;
    }

    public DocumentBuilderFactory newDocumentBuilderFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        this.applyTo(factory);
        return factory;
    }

    public void applyTo(DocumentBuilderFactory factory) {
        XMLParserFactoryHardener util = new XMLParserFactoryHardener();
        util.setDisableExpensiveProcessing(true);
        util.setDisableXIncludeAwareness(true);
        util.setDisableValidation(true);
        util.setDisableDoctypeDeclarations(this.disallowDocTypeDecl);
        util.setDisableExternalResources(this.disableExternalResources);
        util.setDisableXmlSchema(!this.enableSchemaValidation);
        if (this.enableSchemaValidation) {
            XercesUtils.silentSetFeature(factory, "http://apache.org/xml/features/validation/schema", true);
            XercesUtils.silentSetFeature(factory, "http://apache.org/xml/features/validation/schema-full-checking", true);
        }
        util.harden(factory);
    }
}

