/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class RepositoryJobSchedulingRule
implements ISchedulingRule {
    private final String uri;
    private final boolean write;

    public static ISchedulingRule getReadAccessRule(String uri) {
        return new RepositoryJobSchedulingRule(uri, true);
    }

    public static ISchedulingRule getWriteAccessRule(String uri) {
        return new RepositoryJobSchedulingRule(uri, false);
    }

    private RepositoryJobSchedulingRule(String uri, boolean write) {
        if (uri == null) {
            throw new IllegalArgumentException("The uri must not be null");
        }
        this.uri = uri;
        this.write = write;
    }

    public boolean contains(ISchedulingRule rule) {
        return rule == this;
    }

    public boolean isConflicting(ISchedulingRule rule) {
        if (rule == this) {
            return true;
        }
        if (rule instanceof RepositoryJobSchedulingRule) {
            RepositoryJobSchedulingRule repoRule = (RepositoryJobSchedulingRule)rule;
            if (repoRule.uri.equals(this.uri)) {
                return this.write || repoRule.write;
            }
            return false;
        }
        return false;
    }
}

