/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.daemon;

import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.daemon.IHttpServer;
import com.ibm.team.filesystem.client.daemon.IRestServiceInitializer;
import com.ibm.team.filesystem.client.daemon.IServerController;
import com.ibm.team.filesystem.client.daemon.IServiceDescription;
import com.ibm.team.filesystem.client.daemon.JSONHandlerRequestEvent;
import com.ibm.team.filesystem.client.daemon.JSONHandlerResponseEvent;
import com.ibm.team.filesystem.client.daemon.JSONMethod;
import com.ibm.team.filesystem.client.daemon.JSONReceiver;
import com.ibm.team.filesystem.client.daemon.Parameters;
import com.ibm.team.filesystem.client.internal.daemon.FSDaemon;
import com.ibm.team.filesystem.client.internal.http.HttpContext;
import com.ibm.team.filesystem.client.internal.http.HttpHandler;
import com.ibm.team.filesystem.client.internal.http.HttpRequest;
import com.ibm.team.filesystem.client.internal.http.HttpResponse;
import com.ibm.team.filesystem.client.internal.http.HttpServer;
import com.ibm.team.filesystem.client.internal.http.constants.HttpMethod;
import com.ibm.team.filesystem.client.internal.http.constants.ResponseCode;
import com.ibm.team.filesystem.client.internal.marshalling.ExceptionHandlingJSONSerializer;
import com.ibm.team.filesystem.client.internal.marshalling.ParameterWrapperDeserializer;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.IValidatingParameterWrapper;
import com.ibm.team.filesystem.client.restproxy.exceptions.RestMarshallingException;
import com.ibm.team.filesystem.client.restproxy.notification.HttpProgressReporter;
import com.ibm.team.filesystem.client.restproxy.notification.IServerNotificationChannel;
import com.ibm.team.internal.repository.rcp.streams.UnsynchronizedByteArrayOutputStream;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.marshal.MarshalFactory;
import com.ibm.team.repository.common.internal.marshal.MarshallerType;
import com.ibm.team.repository.common.internal.marshal.MarshallingException;
import com.ibm.team.repository.common.internal.marshal.impl.WebServicesMarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.RegistryFactory;

public class JSONHandler
extends HttpHandler {
    private static final Log log = LogFactory.getLog((String)JSONHandler.class.getName());
    public static final String SERVICE_PREFIX = "service";
    protected final Map<String, JSONMethod> methods = new HashMap<String, JSONMethod>();
    protected final Set<JSONReceiver> receivers = new HashSet<JSONReceiver>();
    protected final Map<String, IServiceDescription> services = new HashMap<String, IServiceDescription>();
    protected FSDaemon fsd;
    protected HttpServer server;
    IServerController controller = new IServerController(){

        @Override
        public void shutdown() throws IOException {
            JSONHandler.this.server.shutdown();
        }
    };
    private final ParameterWrapperDeserializer deserializer;
    private final HashMap<String, IConfigurationElement> lazyExtensionPoints = new HashMap();

    public JSONHandler() {
        this.deserializer = new ParameterWrapperDeserializer();
    }

    @Override
    public void registered(FSDaemon fsd, HttpServer httpServer, Collection<HttpContext> httpContext) {
        this.fsd = fsd;
        this.server = httpServer;
        this.loadHandlers();
    }

    protected void loadHandlers() {
        IConfigurationElement[] configs = RegistryFactory.getRegistry().getConfigurationElementsFor("com.ibm.team.filesystem.client.daemon", "restservice");
        HashMap<String, IConfigurationElement> ids = new HashMap<String, IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = configs;
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            String id = config.getAttribute("id");
            if (ids.containsKey(id)) {
                log.error((Object)("Multiple definitions for extension com.ibm.team.filesystem.client.daemon.restservice id=\"" + id + "\" (using entry contributed by \"" + ((IConfigurationElement)ids.get(id)).getContributor().getName() + "\", discarding entry contributed by \"" + config.getContributor().getName() + "\")"));
            } else {
                ids.put(id, config);
                if (JSONHandler.isLazyConfig(config)) {
                    this.lazyExtensionPoints.put(id, config);
                } else {
                    this.installService(id, config);
                }
                String version = config.getAttribute("version");
                this.services.put(id, new ServiceDescription(id, version));
            }
            ++n2;
        }
    }

    private void installService(String id, IConfigurationElement config) {
        Object receiver;
        if (config.getAttribute("initializer") != null) {
            Object initializerObj;
            try {
                initializerObj = config.createExecutableExtension("initializer");
            }
            catch (CoreException coreException) {
                log.error((Object)("Could not create extension for initializer " + config.getAttribute("initializer") + " from plugin " + config.getContributor().getName() + " for extension point " + "com.ibm.team.filesystem.client.daemon" + ".restservice"));
                return;
            }
            IRestServiceInitializer init = (IRestServiceInitializer)initializerObj;
            init.initialize(config);
        }
        try {
            receiver = config.createExecutableExtension("class");
        }
        catch (CoreException coreException) {
            log.error((Object)("Could not instantiate class " + id + " from plugin " + config.getContributor().getName() + " for extension point " + "com.ibm.team.filesystem.client.daemon" + ".restservice"));
            return;
        }
        if (!this.addReceiverMethods(receiver, id)) {
            log.error((Object)("Failed to install methods for " + id + " from plugin " + config.getContributor().getName()));
            return;
        }
        if (receiver instanceof JSONReceiver) {
            this.receivers.add((JSONReceiver)receiver);
            ((JSONReceiver)receiver).installationNotification(this.controller, this);
        }
    }

    private static boolean isLazyConfig(IConfigurationElement config) {
        String val = config.getAttribute("lazy_start");
        if (val == null) {
            return true;
        }
        return !"false".equals(val.trim().toLowerCase(Locale.ENGLISH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean addReceiverMethods(Object receiver, String path) {
        Map<String, JSONMethod> map = this.methods;
        synchronized (map) {
            Method[] methodArray = receiver.getClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                Method m = methodArray[n2];
                Class<?>[] params = m.getParameterTypes();
                if (params.length <= 2 && !(params.length != 1 ? params.length == 2 && (!IValidatingParameterWrapper.class.isAssignableFrom(params[0]) || params.length == 2 && params[1] != IProgressMonitor.class && params[1] != IProgressMonitorWithBlocking.class) : !IValidatingParameterWrapper.class.isAssignableFrom(params[0]) && params[0] != IProgressMonitor.class && params[0] != IProgressMonitorWithBlocking.class)) {
                    if (m.getName().startsWith(HttpMethod.GET.toString().toLowerCase(Locale.ENGLISH)) || m.getName().startsWith(HttpMethod.POST.toString().toLowerCase(Locale.ENGLISH))) {
                        String key = String.valueOf(path) + "." + m.getName();
                        if (this.methods.containsKey(key)) {
                            log.error((Object)("Multiple definitions of " + key));
                            return false;
                        }
                        JSONMethod jm = new JSONMethod(receiver, m);
                        this.methods.put(key, jm);
                    }
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdownNotification() {
        super.shutdownNotification();
        HashMap<String, IConfigurationElement> hashMap = this.lazyExtensionPoints;
        synchronized (hashMap) {
            for (JSONReceiver receiver : this.receivers) {
                try {
                    receiver.shutdownNotification();
                }
                catch (Exception e) {
                    log.error((Object)"Exception during shutdown", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void handle(HttpRequest rq, HttpResponse rp) throws IOException {
        Object result;
        Object[] params;
        JSONMethod m = this.getMethod(rq.getMethod(), rq.getPathSegments());
        if (m == null) {
            this.sendErrorResponse(rq, rp, ResponseCode.NOT_FOUND.getCode(), "Unknown service: " + rq.getRequestURI().getRawPath());
            return;
        }
        Parameters parm = this.buildParameters(rq, rp);
        String progressKey = this.findProgressKey(rq);
        try {
            params = this.demarshallParameters(parm, m, rq, rp, progressKey);
        }
        catch (RestMarshallingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.sendErrorResponse(rq, rp, ResponseCode.BAD_REQUEST.getCode(), "Exception during parameter demarshalling", e);
            return;
        }
        this.fsd.queueEvent(new JSONHandlerRequestEvent(rq, rp, params, progressKey));
        try {
            this.validate(m.getMethod().getName(), params);
        }
        catch (Exception e) {
            this.sendErrorResponse(rq, rp, ResponseCode.INTERNAL_SERVER_ERROR.getCode(), "Failure during parameter validation", e);
            return;
        }
        try {
            try {
                result = m.getMethod().invoke(m.getReceiver(), params);
            }
            finally {
                if (params.length != 0 && params[params.length - 1] instanceof HttpProgressReporter) {
                    HttpProgressReporter r = (HttpProgressReporter)params[params.length - 1];
                    r.finish();
                }
            }
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof TeamRepositoryException || e.getCause() instanceof IllegalArgumentException) {
                Throwable causeOfTRE;
                log.error((Object)e.getMessage(), (Throwable)e);
                if (e.getCause() instanceof TeamRepositoryException && (causeOfTRE = e.getCause().getCause()) instanceof FileSystemStatusException) {
                    String statusInfo = CommonUtil.getStatusErrors((FileSystemStatusException)((FileSystemStatusException)causeOfTRE));
                    log.error((Object)statusInfo);
                }
            } else {
                log.error((Object)e.getCause().getMessage(), e.getCause());
            }
            this.sendErrorResponse(rq, rp, ResponseCode.INTERNAL_SERVER_ERROR.getCode(), "Unexpected exception", e.getCause());
            return;
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.sendErrorResponse(rq, rp, ResponseCode.INTERNAL_SERVER_ERROR.getCode(), "Java reflection exception.", e);
            return;
        }
        UnsynchronizedByteArrayOutputStream bOut = new UnsynchronizedByteArrayOutputStream();
        WebServicesMarshaller webServicesMarshaller = (WebServicesMarshaller)MarshalFactory.eINSTANCE.getMarshaller(MarshallerType.WEB_SERVICES_LITERAL);
        Charset charset = Charset.forName("UTF-8");
        try {
            webServicesMarshaller.marshalServiceResponse(m.getMethod().getName(), m.getMethod().getDeclaringClass().getName(), m.getReturnType(), result, 1, (OutputStream)bOut, charset);
        }
        catch (MarshallingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.sendErrorResponse(rq, rp, ResponseCode.INTERNAL_SERVER_ERROR.getCode(), "Exception while marshalling", e);
            return;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            this.sendErrorResponse(rq, rp, ResponseCode.INTERNAL_SERVER_ERROR.getCode(), "Failed to marshal response", new RestMarshallingException("Failed to marshal response", e));
            return;
        }
        rp.setCode(ResponseCode.OK);
        rp.writeHeader("Content-Type", "text/json; charset=utf-8");
        int size = bOut.size();
        rp.writeHeader("Content-Length", Integer.toString(size));
        OutputStream out = rp.getResponseStream();
        out.write(bOut.getBuffer(), 0, size);
        out.close();
        this.fsd.queueEvent(new JSONHandlerResponseEvent(rq, rp, charset, bOut.getBuffer(), 0, size));
    }

    private void validate(String methodName, Object[] params) throws IllegalArgumentException {
        Object[] objectArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof IValidatingParameterWrapper) {
                ((IValidatingParameterWrapper)obj).validate(methodName, new Object[0]);
            }
            ++n2;
        }
    }

    private String findProgressKey(HttpRequest rq) {
        return rq.getFirstHeader("X-Request-Progress");
    }

    private Object[] demarshallParameters(Parameters parm, JSONMethod m, HttpRequest rq, HttpResponse resp, String progressKey) {
        HttpProgressReporter progress = null;
        if (m.takesProgress() && progressKey != null) {
            progress = new HttpProgressReporter(this.findProgressKey(rq), this.fsd.getNotificationChannel(), resp);
        }
        if (m.getParameterType() == null) {
            if (m.takesProgress()) {
                return new Object[]{progress};
            }
            return new Object[0];
        }
        IValidatingParameterWrapper wrapper = this.deserializer.deserialize(m.getReceiver().getClass().getClassLoader(), parm, m.getParameterType());
        if (m.takesProgress()) {
            return new Object[]{wrapper, progress};
        }
        return new Object[]{wrapper};
    }

    protected String normalizeServicePath(HttpMethod method, String[] path) {
        if (path.length < 1) {
            return null;
        }
        if (!SERVICE_PREFIX.equals(path[0])) {
            return null;
        }
        String[] myPath = new String[path.length - 1];
        System.arraycopy(path, 1, myPath, 0, path.length - 2);
        myPath[myPath.length - 1] = String.valueOf(method.name().toLowerCase(Locale.ENGLISH)) + path[path.length - 1];
        StringBuffer buf = new StringBuffer();
        String[] stringArray = myPath;
        int n = myPath.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(s);
            ++n2;
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONMethod getMethod(HttpMethod method, String[] path) {
        Map<String, JSONMethod> map;
        String key;
        block13: {
            JSONMethod result;
            key = this.normalizeServicePath(method, path);
            map = this.methods;
            synchronized (map) {
                result = this.methods.get(key);
            }
            if (result != null) {
                return result;
            }
            map = this.lazyExtensionPoints;
            synchronized (map) {
                int lastDot;
                block12: {
                    if (this.lazyExtensionPoints.size() <= 0) break block13;
                    lastDot = key.lastIndexOf(".");
                    if (lastDot != -1) break block12;
                    return null;
                }
                String id = key.substring(0, lastDot);
                IConfigurationElement config = this.lazyExtensionPoints.remove(id);
                if (config != null) {
                    this.installService(id, config);
                }
            }
        }
        map = this.methods;
        synchronized (map) {
            return this.methods.get(key);
        }
    }

    protected Parameters buildParameters(HttpRequest rq, HttpResponse rp) throws IOException {
        String encoding;
        Parameters p = new Parameters();
        this.addParametersFromQuery(rq.getRequestURI().getRawQuery(), p);
        if (rq.getMethod() == HttpMethod.POST && "application/x-www-form-urlencoded".equals(encoding = rq.getFirstHeader("Content-Type"))) {
            int c;
            InputStream in = rq.getRequestBody();
            String length = rq.getFirstHeader("Content-Length");
            int len = 32;
            if (length != null) {
                len = Integer.valueOf(length);
            }
            StringBuilder b = new StringBuilder(len);
            while ((c = in.read()) != -1) {
                b.append((char)c);
            }
            this.addParametersFromQuery(b.toString(), p);
        }
        return p;
    }

    protected void addParametersFromQuery(String q, Parameters p) throws IOException {
        if (q != null) {
            int end;
            int len = q.length();
            int start = 0;
            do {
                String pair;
                int keyEnd;
                if ((end = q.indexOf(38, start)) == -1) {
                    end = len;
                }
                if ((keyEnd = (pair = q.substring(start, end)).indexOf(61)) == -1) {
                    p.put(URLDecoder.decode(pair, "UTF-8"), null);
                } else {
                    String key = pair.substring(0, keyEnd);
                    String value = pair.substring(keyEnd + 1);
                    key = URLDecoder.decode(key, "UTF-8");
                    value = URLDecoder.decode(value, "UTF-8");
                    p.put(key, value);
                }
                start = end + 1;
            } while (end != len);
        }
    }

    protected void sendErrorResponse(HttpRequest rq, HttpResponse rp, int code, String text) throws IOException {
        rp.setCode(code, text);
        this.fsd.queueEvent(new JSONHandlerResponseEvent(rq, rp, null, null));
    }

    protected void sendErrorResponse(HttpRequest rq, HttpResponse rp, int code, String text, Throwable e) throws IOException {
        ExceptionHandlingJSONSerializer serializer = new ExceptionHandlingJSONSerializer(true);
        UnsynchronizedByteArrayOutputStream bOut = new UnsynchronizedByteArrayOutputStream();
        Charset charset = Charset.forName("UTF-8");
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)bOut, charset);
        try {
            serializer.serializeException(e, code, w);
        }
        catch (Exception ex) {
            log.error((Object)"Failed to serialize exception", (Throwable)ex);
            this.sendErrorResponse(rq, rp, code, "Failure during exception serialization: " + text);
            return;
        }
        w.close();
        rp.setCode(code, text);
        rp.writeHeader("Content-Type", "application/vnd.ibm.jazz-json-stacktrace-1.0; charset=utf-8");
        int size = bOut.size();
        rp.writeHeader("Content-Length", Integer.toString(size));
        rp.getResponseStream().write(bOut.getBuffer(), 0, size);
        this.fsd.queueEvent(new JSONHandlerResponseEvent(rq, rp, charset, bOut.getBuffer(), 0, size));
    }

    public IServerNotificationChannel getNotificationChannel() {
        return this.fsd.getNotificationChannel();
    }

    public IHttpServer getHttpServer() {
        return this.fsd.getHttpServer();
    }

    public FSDaemon getFSDaemon() {
        return this.fsd;
    }

    public Map<String, IServiceDescription> getServiceDescriptions() {
        return this.services;
    }

    private static class ServiceDescription
    implements IServiceDescription {
        final String id;
        final String version;

        public ServiceDescription(String id, String version) {
            this.id = id;
            this.version = version;
        }

        @Override
        public String getServiceId() {
            return this.id;
        }

        @Override
        public String getVersion() {
            return this.version;
        }
    }
}

