/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.buildablesubset.common.impl;

import com.ibm.team.enterprise.buildablesubset.common.IBuildableFileDesc;
import com.ibm.team.enterprise.buildablesubset.common.IBuildableSubset;
import com.ibm.team.enterprise.buildablesubset.common.IBuildableSubsetCriteria;
import com.ibm.team.enterprise.buildablesubset.common.util.BuildableSubsetSerializer;
import com.ibm.team.enterprise.buildablesubset.common.util.BuildableSubsetUtil;
import com.ibm.team.enterprise.buildablesubset.common.util.Constants;
import com.ibm.team.repository.common.json.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class BuildableSubset
implements IBuildableSubset,
Constants {
    private String fWorkspaceUUID = null;
    private String fBuildDefinitionUUID = null;
    private String fLabel = null;
    private String fDescription = null;
    private String fOwnerID = null;
    private IBuildableSubset.Visibility fVisibility = IBuildableSubset.Visibility.PUBLIC;
    private List<IBuildableFileDesc> fFileDescs;
    private List<IBuildableSubsetCriteria> fCriteria = new ArrayList<IBuildableSubsetCriteria>();

    @Override
    public String getSlug() {
        return BuildableSubsetUtil.getOldSlug(this.fLabel, this.fWorkspaceUUID);
    }

    @Override
    public String getNewSlug() {
        return BuildableSubsetUtil.getSlug(this.fLabel, this.fBuildDefinitionUUID);
    }

    @Override
    public String getStorageRepresentation(String repositoryLocation) {
        StringBuffer buf = new StringBuffer();
        buf.append("<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:ns1=\"http://www.ibm.com/xmlns/prod/rational/rtc/buildablesubset/1.0/\">\n  <rdf:Description rdf:about=");
        buf.append("\"" + (repositoryLocation.endsWith("/") ? repositoryLocation : String.valueOf(repositoryLocation) + "/") + "storage" + "/" + "teamz_buildablesubset" + "/" + this.getSlug() + "\">\n");
        buf.append("  <ns1:label>" + this.fLabel + "</ns1:" + "label" + ">\n");
        try {
            buf.append("  <ns1:description>" + (this.fDescription == null ? "" : URLEncoder.encode(this.fDescription, "UTF-8")) + "</ns1:" + "description" + ">\n");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            buf.append("  <ns1:description>" + (this.fDescription == null ? "" : this.fDescription) + "</ns1:" + "description" + ">\n");
        }
        buf.append("  <ns1:workspaceUUID>" + this.fWorkspaceUUID + "</ns1:" + "workspaceUUID" + ">\n");
        if (this.fFileDescs != null) {
            for (IBuildableFileDesc fileDesc : this.fFileDescs) {
                buf.append("  <ns1:fileDesc>_componentId=" + fileDesc.getComponentId() + "_fileItemId=" + fileDesc.getFileItemId());
                if (fileDesc.getScmPath() != null && !fileDesc.getScmPath().equals("")) {
                    buf.append("_scmPath=").append(fileDesc.getScmPath());
                }
                buf.append("</ns1:fileDesc>\n");
            }
        }
        buf.append("  </rdf:Description>\n </rdf:RDF>");
        return buf.toString();
    }

    @Override
    public String getNewStorageRepresentation(String repositoryLocation) {
        return BuildableSubsetSerializer.serializeSubset(this, repositoryLocation, true);
    }

    @Override
    public JSONObject toHandleJSON() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"label", (Object)this.fLabel);
        jsonObject.put((Object)"ownerId", (Object)this.fOwnerID);
        jsonObject.put((Object)"buildDefinitionUUID", (Object)this.fBuildDefinitionUUID);
        jsonObject.put((Object)"visibility", (Object)this.fVisibility.name());
        return jsonObject;
    }

    @Override
    public String getLabel() {
        return this.fLabel;
    }

    @Override
    public String getWorkspaceUUID() {
        return this.fWorkspaceUUID;
    }

    @Override
    public String getOwnerID() {
        return this.fOwnerID;
    }

    @Override
    public void setOwnerID(String ownerID) {
        this.fOwnerID = ownerID;
    }

    @Override
    public void setVisibility(IBuildableSubset.Visibility visibility) {
        this.fVisibility = visibility;
    }

    @Override
    public IBuildableSubset.Visibility getVisibility() {
        return this.fVisibility;
    }

    @Override
    public String getBuildDefinitionUUID() {
        return this.fBuildDefinitionUUID;
    }

    @Override
    public void setLabel(String label) {
        this.fLabel = label;
    }

    @Override
    public void setWorkspaceUUID(String workspaceUUID) {
        this.fWorkspaceUUID = workspaceUUID;
    }

    @Override
    public void setBuildDefinitionUUID(String buildDefinitionUUID) {
        this.fBuildDefinitionUUID = buildDefinitionUUID;
    }

    @Override
    public List<IBuildableFileDesc> getBuildableFileDescs() {
        return this.fFileDescs;
    }

    @Override
    public void setBuildableFileDescs(List<IBuildableFileDesc> itemIds) {
        this.fFileDescs = itemIds;
    }

    @Override
    public String getDescription() {
        return this.fDescription;
    }

    @Override
    public void setDescription(String description) {
        this.fDescription = description;
    }

    @Override
    public List<IBuildableSubsetCriteria> getCriteria() {
        return this.fCriteria;
    }
}

