/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.impl;

import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.internal.common.ProcessPackage;
import com.ibm.team.process.internal.common.TeamArea;
import com.ibm.team.process.internal.common.impl.ProcessAreaImpl;
import com.ibm.team.process.internal.common.impl.SynchronizedInternalViewMap;
import com.ibm.team.repository.common.AdapterManagerFactory;
import com.ibm.team.repository.common.UUID;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;

public class TeamAreaImpl
extends ProcessAreaImpl
implements TeamArea {
    private final Object fProcessDataLock = new Object();
    private Map fSynchronizedProcessData = null;
    private static final String KEY_CLIENTPREFIX = "READ_ACCESS_CLIENT: ";
    private static final String KEY_CLIENTCOUNT = "READ_ACCESS_CLIENT_COUNT";
    private final Object fMutex = new Object();

    protected TeamAreaImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return ProcessPackage.Literals.TEAM_AREA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getProcessData() {
        Object object = this.fProcessDataLock;
        synchronized (object) {
            if (this.fSynchronizedProcessData == null) {
                EMap.InternalMapView emfMap = (EMap.InternalMapView)super.getProcessData();
                this.fSynchronizedProcessData = new SynchronizedInternalViewMap(emfMap);
            }
            return this.fSynchronizedProcessData;
        }
    }

    @Override
    public String getPropertyName(String propertyId) {
        return TeamAreaImpl.getPropertyNameForId(propertyId);
    }

    @Override
    public int getProcessItemType() {
        return 2;
    }

    public Object getAdapter(Class clazz) {
        IAdapterManager adapterManager = AdapterManagerFactory.getAdapterManager();
        Object adapter = adapterManager.getAdapter((Object)this, clazz);
        if (adapter != null) {
            return adapter;
        }
        return super.getAdapter(clazz);
    }

    @Override
    public boolean hasReadAccessContextClient(String client) {
        return this.isStringExtensionSet(KEY_CLIENTPREFIX + client);
    }

    @Override
    public boolean hasReadAccessContextClients() {
        return this.getIntExtension(KEY_CLIENTCOUNT) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReadAccessContextClient(String client) {
        Object object = this.fMutex;
        synchronized (object) {
            if (!this.isStringExtensionSet(KEY_CLIENTPREFIX + client)) {
                this.setStringExtension(KEY_CLIENTPREFIX + client, null);
                this.setIntExtension(KEY_CLIENTCOUNT, this.getIntExtension(KEY_CLIENTCOUNT) + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeReadAccessContextClient(String client) {
        Object object = this.fMutex;
        synchronized (object) {
            if (this.isStringExtensionSet(KEY_CLIENTPREFIX + client)) {
                this.unsetStringExtension(KEY_CLIENTPREFIX + client);
                this.setIntExtension(KEY_CLIENTCOUNT, this.getIntExtension(KEY_CLIENTCOUNT) - 1);
            }
        }
    }

    @Override
    public UUID getContextId(IAccessGroup.ReadAccessContextType contextType) {
        String memberContextId = this.getStringExtension(contextType.getId());
        if (memberContextId != null) {
            return UUID.valueOf((String)memberContextId);
        }
        return null;
    }

    @Override
    public void setContextId(IAccessGroup.ReadAccessContextType contextType, UUID uuid) {
        if (uuid == null) {
            this.unsetStringExtension(contextType.getId());
        } else {
            this.setStringExtension(contextType.getId(), uuid.getUuidValue());
        }
    }
}

