/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.interop.client.rest.internal;

import com.ibm.team.interop.client.rest.IRestExternalState;
import com.ibm.team.interop.client.rest.internal.InteropItem;
import com.ibm.team.interop.client.rest.json.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class RestExternalState
extends InteropItem
implements IRestExternalState {
    static final String EXTERNALSTATE_ITEM_TYPE = "com.ibm.team.interop.ExternalState";
    static final String QUALIFIED_CLASS_NAME = "com.ibm.team.interop:ExternalState";
    private static final String STATE_KEY_PREFIX = "com.ibm.team.interop.xstate.";
    private static final long serialVersionUID = -8877962013216580617L;

    public RestExternalState() {
        this.setItemTypeName(EXTERNALSTATE_ITEM_TYPE);
        this.setQualifiedClassName(QUALIFIED_CLASS_NAME);
    }

    public RestExternalState(JSONObject other) {
        super(other);
    }

    @Override
    public Map<String, Object> getState() {
        Map<String, Object> extensions = this.getStateExtensions();
        HashMap<String, Object> state = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : extensions.entrySet()) {
            if (!entry.getKey().startsWith(STATE_KEY_PREFIX)) continue;
            state.put(entry.getKey().substring(STATE_KEY_PREFIX.length()), entry.getValue());
        }
        return state;
    }

    @Override
    public void setState(Map<String, ?> state) {
        if (state == null) {
            throw new IllegalArgumentException("The state argument cannot be null");
        }
        this.setState(state, false);
    }

    @Override
    public void removeState(Set<String> names) {
        Map<String, Object> state = this.getState();
        for (String name : names) {
            state.remove(name);
        }
        this.setState(state, true);
    }

    private void setState(Map<String, ?> state, boolean replace) {
        HashMap<String, Object> extensions = new HashMap<String, Object>();
        for (Map.Entry<String, ?> entry : state.entrySet()) {
            extensions.put(STATE_KEY_PREFIX + entry.getKey(), entry.getValue());
        }
        this.setStateExtensions(extensions, replace);
    }
}

