/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriBuilderException;
import org.apache.wink.common.internal.MultivaluedMapImpl;
import org.apache.wink.common.internal.PathSegmentImpl;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.uri.UriEncoder;
import org.apache.wink.common.internal.uritemplate.JaxRsUriTemplateProcessor;
import org.apache.wink.common.internal.utils.UriHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriBuilderImpl
extends UriBuilder
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(UriBuilderImpl.class);
    private String scheme;
    private String userInfo;
    private String host;
    private int port;
    private String fragment;
    private List<PathSegment> segments;
    private MultivaluedMap<String, String> query;
    private String schemeSpecificPart;
    private boolean isFirstCall;

    public UriBuilderImpl() {
        this.reset();
        this.isFirstCall = true;
    }

    public void reset() {
        logger.trace("Entered reset");
        this.scheme = null;
        this.resetSchemeSpecificPart();
        this.query = null;
        this.fragment = null;
        logger.trace("Exit reset");
    }

    private void resetSchemeSpecificPart() {
        logger.trace("Entered resetSchemeSpecificPart");
        this.schemeSpecificPart = null;
        this.userInfo = null;
        this.host = null;
        this.port = -1;
        this.segments = null;
        logger.trace("Exit resetSchemeSpecificPart");
    }

    private List<PathSegment> getPathSegments() {
        if (this.segments == null) {
            this.segments = new ArrayList<PathSegment>();
        }
        logger.trace("getPathSegments returning {}", this.segments);
        return this.segments;
    }

    private MultivaluedMap<String, String> getQuery() {
        if (this.query == null) {
            this.query = new MultivaluedMapImpl<String, String>();
        }
        logger.trace("getQuery returning {}", this.query);
        return this.query;
    }

    private String constructPathString() {
        if (this.segments == null) {
            logger.trace("constructPathString() returning null because null segments");
            return null;
        }
        StringBuilder path = new StringBuilder();
        for (PathSegment segment : this.segments) {
            String segmentStr = segment.toString();
            path.append("/");
            path.append(segmentStr);
            logger.trace("appending {} from path segment to path", (Object)segmentStr);
        }
        String str = path.toString();
        logger.trace("constructPathString() returning {}", (Object)str);
        return str;
    }

    private String constructQueryString() {
        if (this.query == null) {
            logger.trace("constructQueryString returning null beause null");
            return null;
        }
        if (this.query.size() == 0) {
            logger.trace("constructQueryString returning empty string because string size is 0");
            return "";
        }
        String queryStr = "?" + MultivaluedMapImpl.toString(this.query, "&");
        logger.trace("constructQueryString returning {}", (Object)queryStr);
        return queryStr;
    }

    private Set<String> getVariableNamesList() {
        logger.trace("getVariableNamesList() entry");
        String constructedPath = this.constructPathString();
        String constructedQuery = this.constructQueryString();
        String uriStr = UriHelper.contructUri(this.scheme, this.userInfo, this.host, this.port, constructedPath, constructedQuery, this.fragment);
        JaxRsUriTemplateProcessor uriTemplate = new JaxRsUriTemplateProcessor(uriStr);
        Set<String> ret = uriTemplate.getVariableNames();
        logger.trace("getVariableNamesList() returning {}", ret);
        return ret;
    }

    private URI buildInternal(Map<String, ? extends Object> values) throws IllegalArgumentException, UriBuilderException {
        if (logger.isTraceEnabled()) {
            logger.trace("buildInternal({}) entry", values);
        }
        StringBuilder out = new StringBuilder();
        this.buildScheme(values, out);
        this.buildAuthority(values, out);
        this.buildPath(values, out);
        this.buildQuery(values, out);
        this.buildFragment(values, out);
        String uriString = out.toString();
        try {
            logger.trace("buildInternal() exit", (Object)uriString);
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new UriBuilderException(e);
        }
    }

    private void buildScheme(Map<String, ? extends Object> values, StringBuilder out) {
        logger.trace("buildScheme({}, {}) entry", values, (Object)out);
        if (this.scheme == null) {
            logger.trace("buildScheme() is null so returning");
            return;
        }
        JaxRsUriTemplateProcessor.expand(this.scheme, MultivaluedMapImpl.toMultivaluedMapString(values), out);
        out.append(':');
        logger.trace("buildScheme() exit changed out to {}", out);
    }

    private void buildAuthority(Map<String, ? extends Object> values, StringBuilder out) {
        logger.trace("buildAuthority({}, {}) entry", values, (Object)out);
        if (this.userInfo == null && this.host == null && this.port == -1) {
            logger.trace("buildAuthority() is null so returning");
            return;
        }
        out.append("//");
        if (this.userInfo != null) {
            String eUserInfo = JaxRsUriTemplateProcessor.expand(this.userInfo, MultivaluedMapImpl.toMultivaluedMapString(values));
            eUserInfo = UriEncoder.encodeUserInfo(eUserInfo, true);
            out.append(eUserInfo);
            out.append('@');
        }
        if (this.host != null) {
            JaxRsUriTemplateProcessor.expand(this.host, MultivaluedMapImpl.toMultivaluedMapString(values), out);
        }
        if (this.port != -1) {
            out.append(':');
            out.append(this.port);
        }
        logger.trace("buildAuthority() exit changed out to {}", out);
    }

    private void buildPath(Map<String, ? extends Object> values, StringBuilder out) {
        if (logger.isTraceEnabled()) {
            logger.trace("buildPath({}, {}) entry", new Object[]{values, out});
        }
        if (this.segments == null || this.segments.size() == 0) {
            logger.trace("buildPath() segments is null or empty so returning");
            return;
        }
        boolean first = true;
        for (PathSegment segment : this.segments) {
            String segmentPath = segment.getPath();
            String eSegmentPath = JaxRsUriTemplateProcessor.expand(segmentPath, MultivaluedMapImpl.toMultivaluedMapString(values));
            eSegmentPath = UriEncoder.encodePath(eSegmentPath, true);
            if (out.length() > 0 && out.charAt(out.length() - 1) != '/' || out.length() == 0 && !first) {
                out.append('/');
            }
            first = false;
            out.append(eSegmentPath);
            MultivaluedMap<String, String> matrixParameters = segment.getMatrixParameters();
            for (String matrix : matrixParameters.keySet()) {
                String eMatrix = JaxRsUriTemplateProcessor.expand(matrix, MultivaluedMapImpl.toMultivaluedMapString(values));
                eMatrix = UriEncoder.encodeMatrix(eMatrix, true);
                for (String matrixValue : (List)matrixParameters.get(matrix)) {
                    String eValue = JaxRsUriTemplateProcessor.expand(matrixValue, MultivaluedMapImpl.toMultivaluedMapString(values));
                    eValue = UriEncoder.encodeMatrix(eValue, true);
                    out.append(';');
                    out.append(eMatrix);
                    out.append('=');
                    out.append(eValue);
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("buildPath() exit changes out to {} ", out);
        }
    }

    private void buildQuery(Map<String, ? extends Object> values, StringBuilder out) {
        if (logger.isTraceEnabled()) {
            logger.trace("buildQuery({}, {}) entry", values, (Object)out);
        }
        if (this.query == null || this.query.size() == 0) {
            logger.trace("buildQuery() exit - query is null");
            return;
        }
        int delim = 63;
        for (String queryParam : this.query.keySet()) {
            String eQueryParam = JaxRsUriTemplateProcessor.expand(queryParam, MultivaluedMapImpl.toMultivaluedMapString(values));
            eQueryParam = UriEncoder.encodeQueryParam(eQueryParam, true);
            for (String queryValue : (List)this.query.get(queryParam)) {
                String eQueryValue = JaxRsUriTemplateProcessor.expand(queryValue, MultivaluedMapImpl.toMultivaluedMapString(values));
                eQueryValue = UriEncoder.encodeQueryParam(eQueryValue, true);
                out.append((char)delim);
                out.append(eQueryParam);
                delim = 38;
                if (eQueryValue == null) continue;
                out.append('=');
                out.append(eQueryValue);
            }
        }
        logger.trace("buildQuery() exit - changes out to {}", out);
    }

    private void buildFragment(Map<String, ? extends Object> values, StringBuilder out) {
        logger.trace("buildFragment({}, {})", values, (Object)out);
        if (this.fragment == null) {
            return;
        }
        String eFragment = JaxRsUriTemplateProcessor.expand(this.fragment, MultivaluedMapImpl.toMultivaluedMapString(values));
        eFragment = UriEncoder.encodeFragment(eFragment, true);
        out.append('#');
        out.append(eFragment);
        logger.trace("buildFragment() exit - changes out to {}", out);
    }

    @Override
    public URI build(Object ... values) throws IllegalArgumentException, UriBuilderException {
        return this.build(true, values);
    }

    @Override
    public URI buildFromEncoded(Object ... values) throws IllegalArgumentException, UriBuilderException {
        return this.build(false, values);
    }

    private URI build(boolean escapePercent, Object ... values) throws IllegalArgumentException, UriBuilderException {
        if (logger.isTraceEnabled()) {
            logger.trace("build({}, {}) enFtry", escapePercent, Arrays.asList(values));
        }
        if (this.schemeSpecificPart != null) {
            try {
                URI uri = new URI(this.scheme, this.schemeSpecificPart, this.fragment);
                if (logger.isTraceEnabled()) {
                    logger.trace("build() returning {}", (Object)uri.toString());
                }
                return uri;
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(Messages.getMessage("isInvalid", "schemeSpecificPart", this.schemeSpecificPart), e);
            }
        }
        Set<String> names = this.getVariableNamesList();
        if (values == null || names.size() > values.length) {
            throw new IllegalArgumentException(Messages.getMessage("missingVariable", "values"));
        }
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        int i = 0;
        for (String name : names) {
            if (values[i] == null) {
                throw new IllegalArgumentException(Messages.getMessage("variableIsNull", name));
            }
            if (valuesMap.get(name) == null) {
                String value = values[i].toString();
                if (escapePercent) {
                    value = this.escapePercent(value);
                }
                valuesMap.put(name, value);
                logger.trace("name: {} has value : {}", (Object)name, (Object)value);
            }
            ++i;
        }
        while (i < values.length) {
            if (values[i] == null) {
                throw new IllegalArgumentException(Messages.getMessage("valueAtIndexIsNull", String.valueOf(i)));
            }
            ++i;
        }
        return this.buildInternal(valuesMap);
    }

    @Override
    public URI buildFromMap(Map<String, ? extends Object> values) throws IllegalArgumentException, UriBuilderException {
        return this.buildFromMap(true, values);
    }

    @Override
    public URI buildFromEncodedMap(Map<String, ? extends Object> values) throws IllegalArgumentException, UriBuilderException {
        return this.buildFromMap(false, values);
    }

    private URI buildFromMap(boolean escapePercent, Map<String, ? extends Object> values) throws IllegalArgumentException, UriBuilderException {
        if (logger.isTraceEnabled()) {
            logger.trace("buildFromMap({}, {})", escapePercent, values);
        }
        Set<String> names = this.getVariableNamesList();
        if (values == null || names.size() > values.size()) {
            throw new IllegalArgumentException(Messages.getMessage("missingVariable", "values"));
        }
        logger.trace("names are {}", names);
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        for (String name : names) {
            Object value = values.get(name);
            if (value == null) {
                throw new IllegalArgumentException(Messages.getMessage("variableIsNull", name));
            }
            if (valuesMap.get(name) != null) continue;
            String valueToPut = value.toString();
            if (escapePercent) {
                valueToPut = this.escapePercent(valueToPut);
            }
            valuesMap.put(name, valueToPut);
            logger.trace("name {} set to value {}", (Object)name, (Object)valueToPut);
        }
        return this.buildInternal(valuesMap);
    }

    private String escapePercent(String string) {
        logger.trace("escapePercent({}) entry", (Object)string);
        StringBuilder out = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '%') {
                out.append("%25");
                continue;
            }
            out.append(c);
        }
        String ret = out.toString();
        logger.trace("escapePercent() return {}", (Object)ret);
        return ret;
    }

    @Override
    public UriBuilder clone() {
        logger.trace("clone() entry");
        UriBuilderImpl uriBuilder = new UriBuilderImpl();
        uriBuilder.scheme(this.scheme);
        uriBuilder.userInfo(this.userInfo);
        uriBuilder.host(this.host);
        uriBuilder.port(this.port);
        uriBuilder.fragment(this.fragment);
        uriBuilder.segments(this.segments);
        uriBuilder.query(this.query);
        logger.trace("clone() exit returning {}", uriBuilder);
        return uriBuilder;
    }

    private void query(MultivaluedMap<String, String> query2) {
        logger.trace("query({}) entry", query2);
        if (query2 == null) {
            logger.trace("query exit");
            return;
        }
        this.query = ((MultivaluedMapImpl)query2).clone();
        logger.trace("query exit");
    }

    private void segments(List<PathSegment> pathSegments) {
        logger.trace("segments({}) entry", pathSegments);
        if (pathSegments == null) {
            logger.trace("segments() exit");
            return;
        }
        this.segments = new ArrayList<PathSegment>();
        for (PathSegment segment : pathSegments) {
            this.segments.add(((PathSegmentImpl)segment).clone());
        }
        logger.trace("segments() exit");
    }

    @Override
    public UriBuilder fragment(String fragment) {
        logger.trace("fragment({}) entry", (Object)fragment);
        this.fragment = fragment;
        logger.trace("fragment() exit");
        return this;
    }

    @Override
    public UriBuilder host(String host) throws IllegalArgumentException {
        logger.trace("host({}) entry", (Object)host);
        if ("".equals(host)) {
            throw new IllegalArgumentException(Messages.getMessage("variableIsEmpty", "host"));
        }
        this.host = host;
        logger.trace("host() exit");
        return this;
    }

    @Override
    public UriBuilder matrixParam(String name, Object ... values) throws IllegalArgumentException {
        if (logger.isTraceEnabled()) {
            logger.trace("matrixParam({}, {}) entry", (Object)name, values == null ? null : Arrays.asList(values));
        }
        if (name == null) {
            throw new IllegalArgumentException(Messages.getMessage("variableIsNull", "name"));
        }
        if (values == null) {
            throw new IllegalArgumentException(Messages.getMessage("variableIsNull", "values"));
        }
        PathSegmentImpl lastSegment = this.getLastPathSegment();
        for (Object value : values) {
            lastSegment.getMatrixParameters().add(name, value.toString());
            if (!logger.isTraceEnabled()) continue;
            logger.trace("lastSegment add({}, {})", (Object)name, (Object)value.toString());
        }
        logger.trace("matrixParam exit");
        return this;
    }

    private PathSegmentImpl getLastPathSegment() {
        logger.trace("getLastPathSegment() entry");
        List<PathSegment> pathSegments = this.getPathSegments();
        logger.trace("getPathSegments() is {}", pathSegments);
        PathSegmentImpl lastSegment = null;
        int lastSegmentIndex = pathSegments.size() - 1;
        if (lastSegmentIndex >= 0) {
            lastSegment = (PathSegmentImpl)pathSegments.get(lastSegmentIndex);
        } else {
            lastSegment = new PathSegmentImpl("");
            pathSegments.add(lastSegment);
        }
        logger.trace("getLastPathSegment() returning {}", lastSegment);
        return lastSegment;
    }

    @Override
    public UriBuilder path(String path) throws IllegalArgumentException {
        logger.trace("path({}) entry", (Object)path);
        if (path == null) {
            throw new IllegalArgumentException(Messages.getMessage("variableIsNull", "path"));
        }
        if ("".equals(path)) {
            return this;
        }
        if (this.isFirstCall) {
            String[] segments;
            this.isFirstCall = false;
            if (path.indexOf(":") != -1 && (segments = path.split(":", 2)).length == 2 && segments[0].length() > 0 && segments[0].indexOf("{") == -1) {
                String scheme = segments[0];
                if ((segments = segments[1].split("#", 2))[0].length() > 0) {
                    String schemeSpecificPart = segments[0];
                    String fragment = null;
                    if (segments.length == 2) {
                        fragment = segments[1];
                    }
                    this.scheme(scheme);
                    this.schemeSpecificPart(schemeSpecificPart);
                    this.fragment(fragment);
                    logger.trace("replacePath() exit");
                    return this;
                }
            }
        }
        String _path = path;
        if (path.startsWith("//")) {
            if (path.length() > 2) {
                _path = path.substring(2);
                this.getPathSegments().add(new PathSegmentImpl("/"));
            } else {
                logger.trace("path() exit");
                return this;
            }
        }
        List<PathSegment> list = UriHelper.parsePath(_path);
        logger.trace("path is {}", list);
        for (PathSegment segment : list) {
            this.segment(segment.getPath());
            MultivaluedMap<String, String> matrixParameters = segment.getMatrixParameters();
            for (String matrix : matrixParameters.keySet()) {
                this.matrixParam(matrix, ((List)matrixParameters.get(matrix)).toArray());
            }
        }
        logger.trace("path() exit");
        return this;
    }

    @Override
    public UriBuilder path(Class resource) throws IllegalArgumentException {
        logger.trace("path({}) entry", resource);
        if (resource == null) {
            throw new IllegalArgumentException(Messages.getMessage("variableIsNull", "resource"));
        }
        this.isFirstCall = false;
        Path pathAnnotation = resource.getAnnotation(Path.class);
        if (pathAnnotation == null) {
            throw new IllegalArgumentException(Messages.getMessage("resourceNotAnnotated", "@javax.ws.rs.Path", resource));
        }
        String path = pathAnnotation.value();
        logger.trace("path annotation value is {}", (Object)path);
        this.path(path);
        logger.trace("path() exit");
        return this;
    }

    @Override
    public UriBuilder path(Method method) throws IllegalArgumentException {
        logger.trace("path({}) entry", method);
        if (method == null) {
            throw new IllegalArgumentException(Messages.getMessage("variableIsNull", "method"));
        }
        Path pathAnnotation = method.getAnnotation(Path.class);
        if (pathAnnotation == null) {
            throw new IllegalArgumentException(Messages.getMessage("methodNotAnnotated", "@javax.ws.rs.Path", method));
        }
        String path = pathAnnotation.value();
        logger.trace("path method annotation is {}", (Object)path);
        this.path(path);
        logger.trace("path() exit");
        return this;
    }

    @Override
    public UriBuilder path(Class resource, String method) throws IllegalArgumentException {
        Method[] methods;
        logger.trace("path({}, {}) entry", resource, (Object)method);
        if (resource == null) {
            throw new IllegalArgumentException(Messages.getMessage("variableIsNull", "resource"));
        }
        if (method == null) {
            throw new IllegalArgumentException(Messages.getMessage("variableIsNull", "method"));
        }
        Method foundMethod = null;
        for (Method m : methods = resource.getDeclaredMethods()) {
            Path pathAnnotation;
            if (!m.getName().equals(method) || (pathAnnotation = m.getAnnotation(Path.class)) == null) continue;
            if (foundMethod != null) {
                throw new IllegalArgumentException(Messages.getMessage("moreThanOneMethodAnnotated", "@javax.ws.rs.Path", method, resource));
            }
            foundMethod = m;
        }
        if (foundMethod == null) {
            throw new IllegalArgumentException(Messages.getMessage("noMethodAnnotated", "@javax.ws.rs.Path", method, resource));
        }
        this.path(foundMethod);
        logger.trace("path() exit");
        return this;
    }

    @Override
    public UriBuilder port(int port) throws IllegalArgumentException {
        if (logger.isTraceEnabled()) {
            logger.trace("port({}) entry", port);
        }
        if (port < -1) {
            throw new IllegalArgumentException(Messages.getMessage("invalidPort", String.valueOf(port)));
        }
        this.port = port;
        logger.trace("port() exit");
        return this;
    }

    @Override
    public UriBuilder queryParam(String name, Object ... values) throws IllegalArgumentException {
        if (logger.isTraceEnabled()) {
            logger.trace("queryParam({}, {}) entry", (Object)name, values == null ? null : Arrays.asList(values));
        }
        if (name == null) {
            throw new IllegalArgumentException(Messages.getMessage("variableIsNull", "name"));
        }
        if (values == null) {
            throw new IllegalArgumentException(Messages.getMessage("variableIsNull", "values"));
        }
        MultivaluedMap<String, String> query2 = this.getQuery();
        logger.trace("query map is {}", query2);
        for (Object value : values) {
            if (value == null) {
                throw new IllegalArgumentException(Messages.getMessage("variableIsNull", "value"));
            }
            query2.add(name, value != null ? value.toString() : null);
        }
        logger.trace("queryParam() exit");
        return this;
    }

    @Override
    public UriBuilder replaceMatrix(String matrix) throws IllegalArgumentException {
        logger.trace("replaceMatrix({}) entry", (Object)matrix);
        PathSegmentImpl lastPathSegment = this.getLastPathSegment();
        lastPathSegment.clearAllMatrixParameters();
        PathSegmentImpl tmpPathSegment = new PathSegmentImpl("", matrix);
        MultivaluedMap<String, String> matrixParameters = tmpPathSegment.getMatrixParameters();
        for (String param : matrixParameters.keySet()) {
            List matrixValues = (List)matrixParameters.get(param);
            this.matrixParam(param, matrixValues.toArray());
        }
        logger.trace("replaceMatrix() exit");
        return this;
    }

    @Override
    public UriBuilder replaceMatrixParam(String name, Object ... values) throws IllegalArgumentException {
        if (logger.isTraceEnabled()) {
            logger.trace("replaceMatrixParam({}, {})", (Object)name, values == null ? null : Arrays.asList(values));
        }
        if (name == null) {
            throw new IllegalArgumentException(Messages.getMessage("variableIsNull", "name"));
        }
        PathSegmentImpl lastPathSegment = this.getLastPathSegment();
        if (values == null || values.length == 0) {
            lastPathSegment.clearMatrixParameter(name);
        } else {
            List valuesList = (List)lastPathSegment.getMatrixParameters().get(name);
            if (valuesList != null) {
                valuesList.clear();
            }
            this.matrixParam(name, values);
        }
        logger.trace("replaceMatrixParam() exit");
        return this;
    }

    @Override
    public UriBuilder replacePath(String path) {
        String[] segments;
        logger.trace("replacePath({}) entry", (Object)path);
        if (this.isFirstCall) {
            this.isFirstCall = false;
            if (path == null) {
                throw new IllegalArgumentException(Messages.getMessage("variableIsNull", "path"));
            }
        }
        if (path == null) {
            logger.trace("path is null. resetting");
            this.reset();
            logger.trace("replacePath() exit");
            return this;
        }
        this.getPathSegments().clear();
        if (path.indexOf(":") != -1 && (segments = path.split(":", 2)).length == 2 && segments[0].length() > 0 && segments[0].indexOf("{") == -1) {
            String scheme = segments[0];
            if ((segments = segments[1].split("#", 2))[0].length() > 0) {
                String schemeSpecificPart = segments[0];
                String fragment = null;
                if (segments.length == 2) {
                    fragment = segments[1];
                }
                this.scheme(scheme);
                this.schemeSpecificPart(schemeSpecificPart);
                this.fragment(fragment);
                logger.trace("replacePath() exit");
                return this;
            }
        }
        if (path != null && !"".equals(path)) {
            this.path(path);
        }
        logger.trace("replacePath() exit");
        return this;
    }

    @Override
    public UriBuilder replaceQuery(String query2) throws IllegalArgumentException {
        logger.trace("replaceQuery({}) entry", (Object)query2);
        this.getQuery().clear();
        if (query2 != null) {
            query2 = query2.replaceAll(" ", "%20");
            MultivaluedMap<String, String> queries = UriHelper.parseQuery(query2);
            logger.trace("queries after parsing: {}", queries);
            MultivaluedMap<String, String> queryValues = this.getQuery();
            for (String name : queries.keySet()) {
                List values = (List)queries.get(name);
                for (String v : values) {
                    if (v == null) {
                        queryValues.add(name, null);
                        continue;
                    }
                    this.queryParam(name, v);
                }
            }
        }
        logger.trace("replaceQuery() exit");
        return this;
    }

    @Override
    public UriBuilder replaceQueryParam(String name, Object ... values) throws IllegalArgumentException {
        if (logger.isTraceEnabled()) {
            logger.trace("replaceQueryParam({}, {}) entry", (Object)name, values == null ? null : Arrays.asList(values));
        }
        if (name == null) {
            throw new IllegalArgumentException(Messages.getMessage("variableIsNull", "name"));
        }
        this.getQuery().remove(name);
        if (values != null) {
            this.queryParam(name, values);
        }
        logger.trace("replaceQueryParam() exit");
        return this;
    }

    @Override
    public UriBuilder scheme(String scheme) throws IllegalArgumentException {
        logger.trace("scheme({}) entry", (Object)scheme);
        this.scheme = scheme;
        logger.trace("scheme() exit");
        return this;
    }

    @Override
    public UriBuilder schemeSpecificPart(String ssp) throws IllegalArgumentException {
        logger.trace("schemeSpecificPart({}) entry", (Object)ssp);
        if (ssp == null) {
            throw new IllegalArgumentException(Messages.getMessage("variableIsNull", "ssp"));
        }
        if (!ssp.startsWith("/")) {
            this.schemeSpecificPart = ssp;
            return this;
        }
        URI uri = null;
        try {
            uri = new URI(this.scheme, ssp, this.fragment);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(Messages.getMessage("isInvalid", "schemeSpecificPart", this.schemeSpecificPart), e);
        }
        this.resetSchemeSpecificPart();
        if (uri.getRawUserInfo() != null) {
            this.userInfo(UriEncoder.decodeString(uri.getRawUserInfo()));
        }
        if (uri.getHost() != null) {
            this.host(UriEncoder.decodeString(uri.getHost()));
        }
        if (uri.getPort() != -1) {
            this.port(uri.getPort());
        }
        if (uri.getRawPath() != null) {
            String path = uri.getRawPath();
            if (this.host == null && uri.getRawAuthority() != null) {
                path = UriEncoder.decodeString(uri.getRawAuthority()) + "/" + path;
            }
            this.path(UriEncoder.decodeString(path));
        }
        logger.trace("schemeSpecificPart() exit");
        return this;
    }

    @Override
    public UriBuilder segment(String ... segments) throws IllegalArgumentException {
        if (logger.isTraceEnabled()) {
            logger.trace("segment({}) entry", segments == null ? null : Arrays.asList(segments));
        }
        if (segments == null) {
            throw new IllegalArgumentException(Messages.getMessage("variableIsNull", "segments"));
        }
        List<PathSegment> pathSegments = this.getPathSegments();
        for (int i = 0; i < segments.length; ++i) {
            if (segments[i] == null) {
                throw new IllegalArgumentException(Messages.getMessage("segmentAtIndexIsNull", String.valueOf(i)));
            }
            if (segments[i].contains("/")) {
                String segValue = segments[i].replace("/", "%2F");
                pathSegments.add(new PathSegmentImpl(segValue));
                continue;
            }
            pathSegments.add(new PathSegmentImpl(segments[i]));
        }
        logger.trace("segment() exit");
        return this;
    }

    @Override
    public UriBuilder userInfo(String ui) {
        logger.trace("userInfo({}) entry", (Object)ui);
        this.userInfo = ui;
        logger.trace("userInfo() exit");
        return this;
    }

    @Override
    public UriBuilder uri(URI uri) throws IllegalArgumentException {
        logger.trace("Entering uri({})", uri);
        if (uri == null) {
            throw new IllegalArgumentException(Messages.getMessage("variableIsNull", "uri"));
        }
        this.isFirstCall = false;
        if (uri.getScheme() != null) {
            logger.trace("Constructing scheme");
            this.scheme(uri.getScheme());
        }
        if (uri.getRawUserInfo() != null) {
            logger.trace("Constructing userInfo");
            this.userInfo(uri.getRawUserInfo());
        }
        if (uri.getHost() != null) {
            logger.trace("Constructing host");
            this.host(uri.getHost());
        }
        if (uri.getPort() != -1) {
            logger.trace("Constructing port");
            this.port(uri.getPort());
        }
        if (uri.getRawPath() != null) {
            logger.trace("Constructing rawPath");
            this.path(uri.getRawPath());
        }
        if (uri.getRawQuery() != null) {
            logger.trace("Constructing rawQuery");
            this.replaceQuery(uri.getRawQuery());
        }
        if (uri.getRawFragment() != null) {
            logger.trace("Constructing fragment");
            this.fragment(uri.getRawFragment());
        }
        if (uri.getRawSchemeSpecificPart() != null) {
            logger.trace("Constructing schemeSpecificPart");
            this.schemeSpecificPart(uri.getRawSchemeSpecificPart());
        }
        logger.trace("uri() exit");
        return this;
    }
}

