/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.utils;

import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.wink.common.model.JAXBUnmarshalOptions;
import org.apache.wink.common.model.XmlFormattingOptions;

public class JAXBUtils {
    public static Marshaller createMarshaller(JAXBContext ctx, XmlFormattingOptions xfo) {
        Marshaller marshaller = null;
        try {
            marshaller = ctx.createMarshaller();
            JAXBUtils.setXmlFormattingOptions(marshaller, xfo);
        }
        catch (JAXBException e) {
            throw new WebApplicationException(e);
        }
        return marshaller;
    }

    public static Marshaller createMarshaller(JAXBContext ctx) {
        return JAXBUtils.createMarshaller(ctx, XmlFormattingOptions.getDefaultXmlFormattingOptions());
    }

    public static Unmarshaller createUnmarshaller(JAXBContext ctx) {
        Unmarshaller unmarshaller = null;
        try {
            unmarshaller = ctx.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new WebApplicationException(e);
        }
        return unmarshaller;
    }

    public static void setXmlFormattingOptions(Marshaller marshaller, XmlFormattingOptions xfo) {
        if (xfo == null) {
            return;
        }
        try {
            Map<String, Object> properties = xfo.getProperties();
            for (String key : properties.keySet()) {
                marshaller.setProperty(key, properties.get(key));
            }
        }
        catch (Exception e) {
            throw new WebApplicationException(e);
        }
    }

    public static void setJAXBUnmarshalOptions(Unmarshaller unmarshaller, JAXBUnmarshalOptions options) {
        if (options == null) {
            return;
        }
        try {
            Map<String, Object> properties = options.getProperties();
            for (String key : properties.keySet()) {
                unmarshaller.setProperty(key, properties.get(key));
            }
        }
        catch (Exception e) {
            throw new WebApplicationException(e);
        }
    }
}

