/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.dto;

import com.ibm.team.scm.common.internal.dto2.CustomAttributeEntry;
import com.ibm.team.scm.common.internal.dto2.ScmDto2Factory;
import java.sql.Timestamp;

public interface ICustomAttributeEntry {
    public static final CustomAttributeFactory FACTORY = new CustomAttributeFactory();

    public String getAttributeName();

    public Object getAttributeValue();

    public static class CustomAttributeFactory {
        private CustomAttributeFactory() {
        }

        public ICustomAttributeEntry newInstance(String name, Object value) {
            CustomAttributeEntry attr = ScmDto2Factory.eINSTANCE.createCustomAttributeEntry();
            attr.setAttributeName(name);
            if (value instanceof String) {
                attr.setStringValue((String)value);
            } else if (value instanceof Timestamp) {
                attr.setTimeValue((Timestamp)value);
            } else if (value instanceof Integer) {
                attr.setIntValue((Integer)value);
            } else if (value instanceof Boolean) {
                attr.setBooleanValue((Boolean)value);
            } else {
                throw new RuntimeException("Invalid Attribute type is passed in " + value.getClass().getName());
            }
            return attr;
        }
    }
}

