/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.ItemHandle;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.Change;
import com.ibm.team.scm.common.internal.ChangeSet;
import com.ibm.team.scm.common.internal.VersionableHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ConfigUtil {
    private ConfigUtil() {
    }

    public static List<? extends IItemHandle> retainAll(List<? extends IItemHandle> items, List<? extends IItemHandle> itemsToRetain) {
        if (items == null || itemsToRetain == null) {
            throw new IllegalArgumentException();
        }
        Map resultMap = ConfigUtil.tableForItems(items);
        resultMap.keySet().retainAll(ConfigUtil.getItemIds(itemsToRetain));
        ArrayList<IItemHandle> result = new ArrayList<IItemHandle>(resultMap.size());
        for (IItemHandle iItemHandle : items) {
            UUID itemId = iItemHandle.getItemId();
            if (!resultMap.containsKey(itemId)) continue;
            result.add((IItemHandle)resultMap.get(itemId));
        }
        return result;
    }

    public static Map<UUID, IChange> changeSetToMap(ChangeSet changeSet) {
        HashMap<UUID, IChange> result = new HashMap<UUID, IChange>((int)((double)changeSet.changes().size() / 0.75));
        for (Change change : changeSet.changes()) {
            result.put(change.getItem().getItemId(), change);
        }
        return result;
    }

    public static Set affectedItemIds(ChangeSet changeSet) {
        HashSet<UUID> result = new HashSet<UUID>((int)((double)changeSet.changes().size() / 0.75));
        for (Change change : changeSet.changes()) {
            result.add(change.getItem().getItemId());
        }
        return result;
    }

    public static Set affectedItemIds(Collection changeSets) {
        HashSet<UUID> result = new HashSet<UUID>();
        for (ChangeSet changeSet : changeSets) {
            for (Change change : changeSet.changes()) {
                result.add(change.getItem().getItemId());
            }
        }
        return result;
    }

    public static Map affectedItemsMap(Collection changeSets) {
        HashMap<UUID, VersionableHandle> result = new HashMap<UUID, VersionableHandle>();
        for (ChangeSet changeSet : changeSets) {
            for (Change change : changeSet.changes()) {
                VersionableHandle itemHandle = (VersionableHandle)change.getItem();
                result.put(itemHandle.getItemId(), itemHandle);
            }
        }
        return result;
    }

    public static Set<UUID> getItemIds(Collection itemHandles) {
        if (itemHandles == null) {
            throw new IllegalArgumentException();
        }
        HashSet<UUID> result = new HashSet<UUID>((int)((double)itemHandles.size() / 0.75));
        for (ItemHandle itemHandle : itemHandles) {
            if (itemHandle == null) {
                throw new IllegalArgumentException();
            }
            result.add(itemHandle.getItemId());
        }
        return result;
    }

    public static Map tableForItems(Collection itemHandles) {
        if (itemHandles == null) {
            throw new IllegalArgumentException();
        }
        HashMap<UUID, ItemHandle> result = new HashMap<UUID, ItemHandle>(itemHandles.size() * 4 / 3);
        for (ItemHandle itemHandle : itemHandles) {
            ItemHandle x = result.put(itemHandle.getItemId(), itemHandle);
            if (x == null) continue;
            throw new IllegalArgumentException();
        }
        return result;
    }

    public static Map tableForItemsTolerateDuplicates(Collection itemHandles) {
        if (itemHandles == null) {
            throw new IllegalArgumentException();
        }
        HashMap<UUID, ItemHandle> result = new HashMap<UUID, ItemHandle>(itemHandles.size() * 4 / 3);
        for (ItemHandle itemHandle : itemHandles) {
            result.put(itemHandle.getItemId(), itemHandle);
        }
        return result;
    }

    public static boolean overlappingChangeSets(ChangeSet changeSet1, ChangeSet changeSet2) {
        Map<UUID, IChange> m1 = ConfigUtil.changeSetToMap(changeSet1);
        for (Change change : changeSet2.changes()) {
            UUID itemId = change.getItem().getItemId();
            if (!m1.containsKey(itemId)) continue;
            return true;
        }
        return false;
    }

    public static boolean overlappingChangeSets(Map changeSet1, Map changeSet2) {
        for (Map.Entry entry : changeSet2.entrySet()) {
            UUID itemId = (UUID)entry.getKey();
            if (!changeSet1.containsKey(itemId)) continue;
            return true;
        }
        return false;
    }

    public static List<List<ChangeSet>> partitionChangeSets(List changeSets) {
        int[] equiv = new int[changeSets.size()];
        int i = 0;
        while (i < equiv.length) {
            equiv[i] = -1;
            ++i;
        }
        HashMap<UUID, Integer> itemToChangeSetPosition = new HashMap<UUID, Integer>();
        int changeSetPosition = 0;
        for (ChangeSet changeSet : changeSets) {
            for (Change change : changeSet.changes()) {
                int x;
                UUID itemId = change.getItem().getItemId();
                Integer owningChangeSetPosition = (Integer)itemToChangeSetPosition.get(itemId);
                if (owningChangeSetPosition == null) {
                    itemToChangeSetPosition.put(itemId, changeSetPosition);
                    continue;
                }
                int i2 = x = owningChangeSetPosition.intValue();
                while (equiv[i2] >= 0) {
                    i2 = equiv[i2];
                }
                int j = changeSetPosition;
                while (equiv[j] >= 0) {
                    j = equiv[j];
                }
                if (i2 == j) continue;
                equiv[j] = i2;
            }
            ++changeSetPosition;
        }
        List[] sparsePartitions = new List[changeSets.size()];
        int partitionCount = 0;
        int i3 = 0;
        while (i3 < equiv.length) {
            int j = i3;
            while (equiv[j] >= 0) {
                j = equiv[j];
            }
            ArrayList partition = sparsePartitions[j];
            if (partition == null) {
                sparsePartitions[j] = partition = new ArrayList();
                ++partitionCount;
            }
            partition.add(changeSets.get(i3));
            ++i3;
        }
        ArrayList<List<ChangeSet>> result = new ArrayList<List<ChangeSet>>(partitionCount);
        int i4 = 0;
        while (i4 < sparsePartitions.length) {
            if (sparsePartitions[i4] != null) {
                result.add(sparsePartitions[i4]);
            }
            ++i4;
        }
        return result;
    }

    public static <T extends IItemHandle> Map<UUID, T> tableForItemStates(List<T> stateHandles) {
        HashMap<UUID, IItemHandle> result = new HashMap<UUID, IItemHandle>();
        for (IItemHandle i : stateHandles) {
            if (!i.hasStateId()) {
                throw new IllegalArgumentException();
            }
            result.put(i.getStateId(), i);
        }
        return result;
    }

    public static Change findChange(ChangeSet cs, IVersionableHandle item) {
        for (Change c : cs.changes()) {
            if (!c.item().sameItemId((IItemHandle)item)) continue;
            return c;
        }
        return null;
    }

    public static long calculateActiveState(Collection<? extends IChangeSetHandle> activeChangeSets) {
        long result = 0L;
        for (IChangeSetHandle iChangeSetHandle : activeChangeSets) {
            result = 31L * result + (long)iChangeSetHandle.getStateId().hashCode();
        }
        return result;
    }
}

