/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.rest;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.util.LocationUtil;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.util.SCMItemUtil;
import com.ibm.team.scm.common.location.SCMLocationUtil;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class ScmRestService2PathHelper {
    Map<IItemType, String> iItemType2Segment = new HashMap<IItemType, String>();

    public ScmRestService2PathHelper() {
        this(null);
    }

    public ScmRestService2PathHelper(Map<IItemType, String> additionalMappings) {
        this.iItemType2Segment.put(IBaseline.ITEM_TYPE, "baselineId/");
        this.iItemType2Segment.put(IBaselineSet.ITEM_TYPE, "baselineId/");
        this.iItemType2Segment.put(IChangeSet.ITEM_TYPE, "changeSetId/");
        this.iItemType2Segment.put(IComponent.ITEM_TYPE, "componentId/");
        this.iItemType2Segment.put(IWorkspace.ITEM_TYPE, "workspaceId/");
        this.iItemType2Segment.put(IFolder.ITEM_TYPE, "id/");
        if (additionalMappings != null) {
            this.iItemType2Segment.putAll(additionalMappings);
        }
    }

    public String computeUriPath(IItemHandle ... handles) {
        StringBuffer buf = new StringBuffer();
        this.appendUriSegments(buf, handles);
        return buf.toString();
    }

    private StringBuffer appendUriSegments(StringBuffer buf, IItemHandle ... handles) {
        boolean needSlash = false;
        IItemHandle[] iItemHandleArray = handles;
        int n = handles.length;
        int n2 = 0;
        while (n2 < n) {
            IItemHandle itemHandle = iItemHandleArray[n2];
            if (itemHandle != null) {
                if (needSlash) {
                    buf.append("/");
                } else {
                    needSlash = true;
                }
                IItemType itemType = itemHandle.getItemType();
                String segment = this.iItemType2Segment.get(itemType);
                if (segment == null) {
                    throw new IllegalArgumentException(NLS.bind((String)"unsupported item type: {0}", (Object)itemType, (Object[])new Object[0]));
                }
                buf.append(segment);
                buf.append(SCMLocationUtil.getItemIdString(itemHandle));
            }
            ++n2;
        }
        return buf;
    }

    public String computeVersionableUriPath(IBaselineHandle baselineHandle, IVersionableHandle versionableHandle) throws TeamRepositoryException {
        StringBuffer buf = new StringBuffer();
        this.appendUriSegments(buf, new IItemHandle[]{baselineHandle});
        buf.append("/");
        this.appendVersionableUriSegments(buf, versionableHandle);
        return buf.toString();
    }

    public String computeVersionableUriPath(IBaselineSetHandle snapshotHandle, IComponentHandle componentHandle, IVersionableHandle versionableHandle) throws TeamRepositoryException {
        StringBuffer buf = new StringBuffer();
        this.appendUriSegments(buf, new IItemHandle[]{snapshotHandle, componentHandle});
        buf.append("/");
        this.appendVersionableUriSegments(buf, versionableHandle);
        return buf.toString();
    }

    private StringBuffer appendVersionableUriSegments(StringBuffer buf, IVersionableHandle versionableHandle) throws TeamRepositoryException {
        buf.append("id/");
        String encodedPathSegment = SCMLocationUtil.getEncodedRelativeVersionableLocationSegment(versionableHandle);
        buf.append(encodedPathSegment);
        return buf;
    }

    public String computeVersionableUriPath(IWorkspaceHandle workspaceHandle, IComponentHandle componentHandle, String ... segments) throws TeamRepositoryException {
        String[] encodedSegments = new String[segments.length];
        int i = 0;
        try {
            String[] stringArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                encodedSegments[i++] = LocationUtil.encode((String)segment);
                ++n2;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new TeamRepositoryException(e.getMessage(), (Throwable)e);
        }
        return this.computeVersionableUriPathUsingEncodedSegments(workspaceHandle, componentHandle, encodedSegments);
    }

    public String computeVersionableUriPathUsingEncodedSegments(IWorkspaceHandle workspaceHandle, IComponentHandle componentHandle, String ... segments) throws TeamRepositoryException {
        String relativePath = SCMLocationUtil.join("/", segments);
        StringBuffer buf = new StringBuffer();
        this.appendUriSegments(buf, new IItemHandle[]{workspaceHandle, componentHandle});
        buf.append("/").append("path/").append(relativePath);
        return buf.toString();
    }

    public String computeVersionableUriPath(IWorkspaceHandle workspaceHandle, IComponentHandle componentHandle, IVersionableHandle versionableHandle) throws TeamRepositoryException {
        StringBuffer buf = new StringBuffer();
        this.appendUriSegments(buf, new IItemHandle[]{workspaceHandle, componentHandle});
        buf.append("/");
        this.appendVersionableUriSegments(buf, versionableHandle);
        return buf.toString();
    }

    public String computeVersionableUriPath(IComponentHandle componentHandle, IVersionableHandle versionableHandle) throws TeamRepositoryException {
        StringBuffer buf = new StringBuffer();
        this.appendUriSegments(buf, new IItemHandle[]{componentHandle});
        buf.append("/");
        this.appendVersionableUriSegments(buf, versionableHandle);
        return buf.toString();
    }

    public String getVersionableIdString(IVersionableHandle versionableHandle, IItemType itemType) {
        StringBuffer buf = new StringBuffer(itemType.getNamespaceURI());
        buf.append(".");
        buf.append(itemType.getName());
        buf.append("/");
        buf.append(SCMLocationUtil.getItemIdString((IItemHandle)versionableHandle));
        return buf.toString();
    }

    public String computeChangeSetUriPath(IItemHandle contextHandle, IChangeSetHandle changeSetHandle, IVersionableHandle versionableHandle) throws TeamRepositoryException {
        StringBuffer buf = new StringBuffer();
        this.appendUriSegments(buf, new IItemHandle[]{contextHandle, changeSetHandle});
        if (versionableHandle != null) {
            buf.append("/");
            this.appendVersionableUriSegments(buf, SCMItemUtil.newVersionableHandle(versionableHandle, false));
        }
        return buf.toString();
    }
}

