/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.subcomponents;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IHierarchyNode;
import com.ibm.team.scm.common.IHierarchyResult;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.dto.BaselineHierarchyNode;
import com.ibm.team.scm.common.internal.dto.ComponentHierarchyNode;
import com.ibm.team.scm.common.internal.dto.HierarchyNode;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.subcomponents.UuidUtils;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public final class SubcomponentCommonUtils {
    private static final String SUBCOMPONENT_INFO_FILE_NAME = ".subcomponent_info";
    private static final String SUBCOMPONENT_INFO_CONTENT_TYPE = "application/vnd.com.ibm.team.rtc.scm.subcomponent";
    private static final String CHARSET_NAME = "US-ASCII";
    private static final long UUID_ADJUSTMENT_INTERVAL_IN_MILLISECONDS = new GregorianCalendar(1970, 0, 1, 0, 0, 0).getTime().getTime() - new GregorianCalendar(1770, 0, 1, 0, 0, 0).getTime().getTime();

    private SubcomponentCommonUtils() {
        throw new RuntimeException("Do not create instances of " + this.getClass().getName());
    }

    private static Charset charset() {
        return Charset.forName(CHARSET_NAME);
    }

    public static String infoFileName() {
        return SUBCOMPONENT_INFO_FILE_NAME;
    }

    public static String contentType() {
        return SUBCOMPONENT_INFO_CONTENT_TYPE;
    }

    public static Collection<IComponentHandle> readSubcomponentData(byte[] data) {
        String dataStr = new String(data, SubcomponentCommonUtils.charset());
        ArrayList<IComponentHandle> subcomponents = NewCollection.arrayList();
        String[] stringArray = dataStr.split("\\s*\\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!id.isEmpty()) {
                try {
                    subcomponents.add((IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(UUID.valueOf((String)id), null));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            ++n2;
        }
        return subcomponents;
    }

    public static Collection<UUID> toUUIDs(Collection<? extends IItemHandle> handles) {
        if (handles == null) {
            return Collections.emptySet();
        }
        HashSet<UUID> result = NewCollection.hashSet(handles.size() * 2);
        for (IItemHandle iItemHandle : handles) {
            result.add(iItemHandle.getItemId());
        }
        return result;
    }

    public static Collection<UUID> toUUIDs(IItemHandle ... handles) {
        return SubcomponentCommonUtils.toUUIDs(Arrays.asList(handles));
    }

    public static Collection<UUID> determineRoots(Map<UUID, Collection<IComponentHandle>> subcomponentStructure) {
        if (subcomponentStructure == null) {
            throw new IllegalArgumentException("subcomponentStructure is required");
        }
        HashSet<UUID> roots = NewCollection.hashSet(subcomponentStructure.keySet());
        for (Map.Entry<UUID, Collection<IComponentHandle>> entry : subcomponentStructure.entrySet()) {
            for (IComponentHandle iComponentHandle : entry.getValue()) {
                UUID subcomponentId = iComponentHandle.getItemId();
                roots.remove(subcomponentId);
            }
        }
        HashSet<UUID> inCycles = NewCollection.hashSet(subcomponentStructure.keySet());
        for (UUID root : roots) {
            SubcomponentCommonUtils.removeHierarchy(inCycles, root, subcomponentStructure);
        }
        if (!inCycles.isEmpty()) {
            HashSet pseudoRoots = NewCollection.hashSet();
            while (!inCycles.isEmpty()) {
                UUID uUID = SubcomponentCommonUtils.pickPseudoRoot(inCycles, subcomponentStructure);
                SubcomponentCommonUtils.removeHierarchy(inCycles, uUID, subcomponentStructure);
                pseudoRoots.add(uUID);
            }
            roots.addAll(pseudoRoots);
        }
        return roots;
    }

    public static Collection<UUID> determineUniqueHierarchy(Collection<UUID> roots, Map<UUID, Collection<IComponentHandle>> subcomponentStructure) {
        if (subcomponentStructure == null) {
            throw new IllegalArgumentException("subcomponentStructure is required");
        }
        if (roots == null) {
            throw new IllegalArgumentException("roots is required");
        }
        HashSet descendants = NewCollection.hashSet();
        Queue nodesToVisit = NewCollection.arrayQueue();
        nodesToVisit.addAll(roots);
        while (!nodesToVisit.isEmpty()) {
            UUID node = (UUID)nodesToVisit.remove();
            if (descendants.contains(node)) continue;
            nodesToVisit.addAll(SubcomponentCommonUtils.toUUIDs(subcomponentStructure.get(node)));
            descendants.add(node);
        }
        HashSet<UUID> result = NewCollection.hashSet(descendants);
        HashSet visited = NewCollection.hashSet();
        nodesToVisit.addAll(subcomponentStructure.keySet());
        nodesToVisit.removeAll(descendants);
        while (!nodesToVisit.isEmpty()) {
            UUID node = (UUID)nodesToVisit.remove();
            if (!visited.add(node)) continue;
            Collection<UUID> children = SubcomponentCommonUtils.toUUIDs(subcomponentStructure.get(node));
            children.removeAll(roots);
            result.removeAll(children);
            nodesToVisit.addAll(children);
        }
        return result;
    }

    private static void removeHierarchy(Collection<UUID> inCycles, UUID root, Map<UUID, Collection<IComponentHandle>> subcomponentStructure) {
        HashSet visited = NewCollection.hashSet();
        Queue toVisit = NewCollection.arrayQueue();
        toVisit.add(root);
        while (!toVisit.isEmpty()) {
            UUID current = (UUID)toVisit.remove();
            if (visited.contains(current)) continue;
            inCycles.remove(current);
            visited.add(current);
            Collection<IComponentHandle> subcomponents = subcomponentStructure.get(current);
            if (subcomponents == null) continue;
            Collection<UUID> subcomponentIdIds = SubcomponentCommonUtils.toUUIDs(subcomponents);
            subcomponentIdIds.removeAll(visited);
            toVisit.addAll(subcomponentIdIds);
        }
    }

    private static UUID pickPseudoRoot(Collection<UUID> inCycles, Map<UUID, Collection<IComponentHandle>> subcomponentStructure) {
        Queue partialPaths = NewCollection.arrayQueue();
        Queue<List<UUID>> completedPaths = NewCollection.priorityQueue(new Comparator<List<UUID>>(){

            @Override
            public int compare(List<UUID> path1, List<UUID> path2) {
                return Integer.valueOf(path1.size()).compareTo(path2.size());
            }
        });
        for (UUID startingPoint : inCycles) {
            ArrayList path = NewCollection.arrayList();
            path.add(startingPoint);
            partialPaths.add(path);
        }
        while (!partialPaths.isEmpty()) {
            List candidatePath = (List)partialPaths.remove();
            Collection<UUID> nextSteps = SubcomponentCommonUtils.nextSteps(candidatePath, subcomponentStructure);
            UUID startingPoint = (UUID)candidatePath.get(0);
            for (UUID next : nextSteps) {
                if (next.equals((Object)startingPoint)) {
                    completedPaths.add(candidatePath);
                    return (UUID)candidatePath.get(0);
                }
                if (candidatePath.contains(next)) continue;
                List nextPath = NewCollection.arrayList(candidatePath);
                nextPath.add(next);
                partialPaths.add(nextPath);
            }
        }
        return completedPaths.remove().get(0);
    }

    private static Collection<UUID> nextSteps(List<UUID> candidatePath, Map<UUID, Collection<IComponentHandle>> subcomponentStructure) {
        UUID last = candidatePath.get(candidatePath.size() - 1);
        Collection<IComponentHandle> subcomponents = subcomponentStructure.get(last);
        return subcomponents == null ? Collections.emptySet() : SubcomponentCommonUtils.toUUIDs(subcomponents);
    }

    public static <N extends HierarchyNode, H extends IItemHandle> N createHierarchyNode(IWorkspaceHandle workspace, H baselineOrComponentHandle, List<UUID> ancestorPath, Map<UUID, Collection<H>> subcomponentStructure, Set<UUID> visited, int[] topOfCycleResult) {
        ComponentHierarchyNode componentHierarchyNode = null;
        BaselineHierarchyNode baselineHierarchyNode = null;
        HierarchyNode result = null;
        Comparator<Object> componentComparator = null;
        if (baselineOrComponentHandle instanceof IBaseline) {
            IBaseline baseline = (IBaseline)baselineOrComponentHandle;
            baselineHierarchyNode = ScmDtoFactory.eINSTANCE.createBaselineHierarchyNode();
            baselineHierarchyNode.setBaseline(baseline);
            baselineHierarchyNode.setComponent(baseline.getComponent());
            result = baselineHierarchyNode;
            componentComparator = new Comparator<IBaseline>(){

                @Override
                public int compare(IBaseline object1, IBaseline object2) {
                    return object1.getComponent().getItemId().compareTo((Object)object2.getItemId());
                }
            };
        } else if (baselineOrComponentHandle instanceof IComponentHandle) {
            IComponentHandle component = (IComponentHandle)baselineOrComponentHandle;
            componentHierarchyNode = ScmDtoFactory.eINSTANCE.createComponentHierarchyNode();
            componentHierarchyNode.setComponent(component);
            result = componentHierarchyNode;
            componentComparator = new Comparator<IComponentHandle>(){

                @Override
                public int compare(IComponentHandle object1, IComponentHandle object2) {
                    return object1.getItemId().compareTo((Object)object2.getItemId());
                }
            };
        } else {
            throw new IllegalArgumentException();
        }
        result.getAncestorPath().addAll(ancestorPath);
        result.setInCycle(false);
        result.setBranchContainsCycles(false);
        UUID parentId = baselineOrComponentHandle.getItemId();
        visited = NewCollection.hashSet(visited);
        if (!visited.add(parentId)) {
            result.setInCycle(true);
            result.setBranchContainsCycles(true);
            topOfCycleResult[0] = ancestorPath.indexOf(parentId);
        } else {
            visited = Collections.unmodifiableSet(visited);
            List<UUID> childPath = NewCollection.arrayList(ancestorPath);
            childPath.add(parentId);
            Collection<H> children = subcomponentStructure.get(parentId);
            if (children != null) {
                ArrayList<H> sortedChildren = new ArrayList<H>(children);
                Collections.sort(sortedChildren, componentComparator);
                for (IItemHandle child : sortedChildren) {
                    int topIndex;
                    int[] topOfChildsCycle = new int[]{Integer.MAX_VALUE};
                    N childNode = SubcomponentCommonUtils.createHierarchyNode(workspace, child, childPath, subcomponentStructure, visited, topOfChildsCycle);
                    if (componentHierarchyNode != null) {
                        componentHierarchyNode.getChildren().add(childNode);
                    } else {
                        baselineHierarchyNode.getChildren().add(childNode);
                    }
                    if (!childNode.isBranchContainsCycles()) continue;
                    result.setBranchContainsCycles(true);
                    if (topOfChildsCycle[0] > ancestorPath.size()) continue;
                    result.setInCycle(true);
                    topOfCycleResult[0] = topIndex = Math.min(topOfCycleResult[0], topOfChildsCycle[0]);
                }
            }
        }
        return (N)result;
    }

    public static void getHierarchyToMaps(IHierarchyResult hierarchy, Map<UUID, Collection<IItemHandle>> parentToChildrenMap, Map<UUID, Collection<IItemHandle>> childrenToParentsMap, Map<UUID, IItemHandle> flattenedElementsMap) {
        HierarchyToMapVisitor hierarchyToMapVisitor = new HierarchyToMapVisitor(parentToChildrenMap, childrenToParentsMap, flattenedElementsMap);
        SubcomponentCommonUtils.visitHierarchy(hierarchy, (IHierarchyVisitor)hierarchyToMapVisitor);
    }

    public static UUID getDataFileID(IComponentHandle component) {
        long[] parts = UuidUtils.unpackUUID(component.getItemId());
        parts[0] = parts[0] & 0xFFFFFFFFFFFFFFFL;
        parts[0] = parts[0] - UUID_ADJUSTMENT_INTERVAL_IN_MILLISECONDS * 10000L;
        parts[0] = parts[0] | 0x1000000000000000L;
        parts[1] = parts[1] ^ 0xFFL;
        return UuidUtils.packUUID(parts);
    }

    public static void visitHierarchy(IHierarchyNode node, IHierarchyVisitor visitor) {
        if (visitor.stopAllVisiting()) {
            return;
        }
        if (!visitor.visit(node)) {
            return;
        }
        for (IHierarchyNode child : node.getChildren()) {
            SubcomponentCommonUtils.visitHierarchy(child, visitor);
        }
    }

    public static void visitHierarchy(IHierarchyResult hierarchy, IHierarchyVisitor visitor) {
        for (IHierarchyNode node : hierarchy.getRoots()) {
            if (visitor.stopAllVisiting()) {
                return;
            }
            SubcomponentCommonUtils.visitHierarchy(node, visitor);
        }
    }

    public static Collection<IComponentHandle> inMultipleHierarchies(Map<UUID, IComponentHandle> searchComponents, Map<UUID, Collection<IComponentHandle>> structure, Map<UUID, Collection<IComponentHandle>> localStructure) {
        Map<UUID, Set<UUID>> parentStructure = SubcomponentCommonUtils.getParentStructure(structure);
        Map<UUID, Set<UUID>> localParentStructure = SubcomponentCommonUtils.getParentStructure(localStructure);
        HashMap<UUID, IComponentHandle> result = new HashMap<UUID, IComponentHandle>();
        for (Map.Entry<UUID, IComponentHandle> entry : searchComponents.entrySet()) {
            UUID uuid = entry.getKey();
            Queue nodesToVisit = NewCollection.arrayQueue();
            nodesToVisit.add(uuid);
            HashSet<UUID> visited = new HashSet<UUID>();
            while (!nodesToVisit.isEmpty()) {
                UUID node = (UUID)nodesToVisit.poll();
                if (visited.contains(node)) continue;
                visited.add(node);
                Collection parentCollection = parentStructure.get(node);
                if (parentCollection == null) continue;
                for (UUID handleItemId : parentCollection) {
                    Set<UUID> localParentCollection = localParentStructure.get(node);
                    if (localParentCollection != null) {
                        for (UUID componentUUID : parentCollection) {
                            if (localParentCollection.contains(componentUUID)) continue;
                            result.put(uuid, entry.getValue());
                        }
                    } else if (parentCollection.size() > 1) {
                        result.put(uuid, entry.getValue());
                        continue;
                    }
                    nodesToVisit.add(handleItemId);
                }
            }
        }
        return result.values();
    }

    private static Map<UUID, Set<UUID>> getParentStructure(Map<UUID, Collection<IComponentHandle>> structure) {
        HashMap<UUID, Set<UUID>> result = new HashMap<UUID, Set<UUID>>();
        for (UUID uuid : structure.keySet()) {
            Collection<IComponentHandle> subComponentsInHierarchy = structure.get(uuid);
            for (IComponentHandle handle : subComponentsInHierarchy) {
                UUID itemId = handle.getItemId();
                HashSet<UUID> parents = (HashSet<UUID>)result.get(itemId);
                if (parents == null) {
                    parents = new HashSet<UUID>();
                    result.put(itemId, parents);
                }
                parents.add(uuid);
            }
        }
        return result;
    }

    private static class HierarchyToMapVisitor
    extends IHierarchyVisitor {
        private Map<UUID, Collection<IItemHandle>> parentToChildrenMap;
        private Map<UUID, Collection<IItemHandle>> childToParentsMap;
        private Map<UUID, IItemHandle> flattenedElementsMap;

        public HierarchyToMapVisitor(Map<UUID, Collection<IItemHandle>> parentToChildrenMap, Map<UUID, Collection<IItemHandle>> childToParentsMap, Map<UUID, IItemHandle> flattenedElementsMap) {
            this.parentToChildrenMap = parentToChildrenMap;
            this.childToParentsMap = childToParentsMap;
            this.flattenedElementsMap = flattenedElementsMap;
        }

        @Override
        public boolean visit(IHierarchyNode node) {
            this.getParentToChildrenMap(node, this.parentToChildrenMap);
            this.getChildToParentsMap(node, this.childToParentsMap);
            this.getFlattenedElementsMap(node, this.flattenedElementsMap);
            return true;
        }

        private void getParentToChildrenMap(IHierarchyNode node, Map<UUID, Collection<IItemHandle>> parentToChildren) {
            UUID parentUuid = node.getElementHandle().getItemId();
            Collection<IItemHandle> childrenList = parentToChildren.get(parentUuid);
            if (childrenList == null) {
                childrenList = new ArrayList<IItemHandle>();
                parentToChildren.put(parentUuid, childrenList);
            }
            HashMap<UUID, Object> childrenSet = new HashMap<UUID, Object>();
            for (IItemHandle childHandle : childrenList) {
                childrenSet.put(childHandle.getItemId(), childHandle);
            }
            Collection children = node.getChildren();
            for (IHierarchyNode childNode : children) {
                Object childHandle = childNode.getElementHandle();
                UUID childUuid = childHandle.getItemId();
                childrenSet.put(childUuid, childHandle);
            }
            childrenList.clear();
            childrenList.addAll(childrenSet.values());
        }

        private void getChildToParentsMap(IHierarchyNode parentNode, Map<UUID, Collection<IItemHandle>> childToParents) {
            UUID parentUuid;
            Object parentHandle = parentNode.getElementHandle();
            if (parentNode.getAncestorPath().isEmpty() && !childToParents.containsKey(parentUuid = parentHandle.getItemId())) {
                childToParents.put(parentUuid, new ArrayList());
            }
            for (IHierarchyNode childNode : parentNode.getChildren()) {
                UUID childUuid = childNode.getElementHandle().getItemId();
                Collection<IItemHandle> parentList = childToParents.get(childUuid);
                if (parentList == null) {
                    parentList = new ArrayList<IItemHandle>();
                    childToParents.put(childUuid, parentList);
                }
                boolean parentFound = false;
                for (IItemHandle otherParent : parentList) {
                    if (!otherParent.sameItemId(parentHandle)) continue;
                    parentFound = true;
                    break;
                }
                if (parentFound) continue;
                parentList.add((IItemHandle)parentHandle);
            }
        }

        public void getFlattenedElementsMap(IHierarchyNode node, Map<UUID, IItemHandle> flattenedElements) {
            Object handle = node.getElementHandle();
            flattenedElements.put(handle.getItemId(), (IItemHandle)handle);
        }
    }

    public static abstract class IHierarchyVisitor {
        public abstract boolean visit(IHierarchyNode var1);

        public boolean stopAllVisiting() {
            return false;
        }
    }
}

