/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.subcomponents;

import com.ibm.team.repository.common.UUID;

final class UuidUtils {
    private static final char MAX_UUID_CHAR = '\u0080';
    private static final char UUID_STARTS_WITH = '_';
    private static final int UUID_CHAR_LENGTH = 23;
    private static char[] LASTCHAR_DIGITS = "AQgw".toCharArray();
    private static final char[] BASE64_DIGITS = "-0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz".toCharArray();
    private static final int[] DIGIT_MAP = UuidUtils.computeInverseMap(BASE64_DIGITS);
    private static final int[] LASTCHAR_DIGIT_MAP = UuidUtils.computeInverseMap(LASTCHAR_DIGITS);

    private UuidUtils() {
        throw new RuntimeException("Do not create instances of " + this.getClass().getName());
    }

    static UUID packUUID(long[] parts) {
        char[] result = new char[23];
        result[0] = 95;
        long localLsb = parts[1];
        result[22] = LASTCHAR_DIGITS[(int)(localLsb & 3L)];
        localLsb >>>= 2;
        int i = 21;
        while (i >= 12) {
            result[i] = BASE64_DIGITS[(int)(localLsb & 0x3FL)];
            localLsb >>>= 6;
            --i;
        }
        long localMsb = parts[0];
        result[11] = BASE64_DIGITS[(int)(localLsb | (localMsb & 0xFL) << 2)];
        localMsb >>>= 4;
        int i2 = 10;
        while (i2 != 0) {
            result[i2] = BASE64_DIGITS[(int)(localMsb & 0x3FL)];
            localMsb >>>= 6;
            --i2;
        }
        return UUID.valueOf((String)new String(result));
    }

    static long[] unpackUUID(UUID id) {
        long nextBits;
        char next;
        char[] trimmedValue = id.getUuidValue().trim().toCharArray();
        long msb = 0L;
        int idx = 1;
        while (idx < 11) {
            next = trimmedValue[idx];
            nextBits = DIGIT_MAP[next];
            msb <<= 6;
            msb |= nextBits;
            ++idx;
        }
        next = trimmedValue[11];
        nextBits = DIGIT_MAP[next];
        msb <<= 4;
        msb |= nextBits >> 2;
        long lsb = nextBits & 3L;
        int idx2 = 12;
        while (idx2 < 22) {
            next = trimmedValue[idx2];
            nextBits = DIGIT_MAP[next];
            lsb <<= 6;
            lsb |= nextBits;
            ++idx2;
        }
        next = trimmedValue[22];
        nextBits = LASTCHAR_DIGIT_MAP[next];
        lsb <<= 2;
        return new long[]{msb, lsb |= nextBits};
    }

    private static int[] computeInverseMap(char[] digits) {
        int[] digitMap = new int[129];
        int i = 0;
        while (i < digitMap.length) {
            digitMap[i] = -1;
            ++i;
        }
        i = 0;
        while (i < digits.length) {
            char c = digits[i];
            if (c > '\u0080') {
                throw new IllegalStateException();
            }
            digitMap[c] = i++;
        }
        return digitMap;
    }
}

