/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.common.internal.util;

import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.validation.IItemValidator;
import com.ibm.team.repository.common.validation.IStringSizeConstraintErrorStatus;
import com.ibm.team.repository.common.validation.PropertyConstraintException;
import org.eclipse.core.runtime.IStatus;

public class ValidationUtils {
    public static void checkPropertyConstraints(IItem item) throws PropertyConstraintException {
        IStatus status = IItemValidator.INSTANCE.validateConstraints(item);
        if (!status.isOK()) {
            PropertyConstraintException e = new PropertyConstraintException(status.getMessage());
            e.setData((Object)item);
            throw e;
        }
    }

    public static String truncate(IType type, String propertyName, String value) {
        if (value == null) {
            return value;
        }
        IStatus status = IItemValidator.INSTANCE.validateAttribute(type, propertyName, (Object)value);
        if (status instanceof IStringSizeConstraintErrorStatus) {
            long maxSize = ((IStringSizeConstraintErrorStatus)status).getMaxSize();
            String truncated = value.substring(0, (int)Math.min((long)value.length(), maxSize));
            do {
                truncated = ValidationUtils.endAtWordBoundary(truncated);
                status = IItemValidator.INSTANCE.validateAttribute(type, propertyName, (Object)truncated);
            } while (truncated.length() > 0 && status instanceof IStringSizeConstraintErrorStatus);
            return truncated;
        }
        return value;
    }

    private static String endAtWordBoundary(String string) {
        int space = string.lastIndexOf(32);
        if (space > 0) {
            return string.substring(0, space);
        }
        if (string.length() > 1) {
            return string.substring(0, string.length() - 1);
        }
        return "";
    }
}

