/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.common.internal.setup.builders;

import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IProcessItem;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.IRole;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.process.common.internal.setup.builders.AbstractProcessBuilder;
import com.ibm.team.process.common.internal.setup.builders.IProcessBuilderContext;
import com.ibm.team.process.common.internal.setup.builders.ProjectAreaBuilder;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.common.internal.setup.builders.BuildContext;
import com.ibm.team.rtc.common.internal.setup.builders.ValueKey;
import java.util.HashMap;
import java.util.Map;

public class TeamAreaBuilder
extends AbstractProcessBuilder<ITeamArea> {
    private static final ValueKey<Boolean> ARCHIVED_KEY = new ValueKey(String.valueOf(TeamAreaBuilder.class.getName()) + ".archived");
    private static final ValueKey<String> NAME_KEY = new ValueKey(String.valueOf(TeamAreaBuilder.class.getName()) + ".name");
    private static final ValueKey<IProjectArea> PROJECT_AREA_KEY = new ValueKey(String.valueOf(TeamAreaBuilder.class.getName()) + ".projectArea");
    private static final ValueKey<Map<IContributorHandle, IRole[]>> MEMBERS_KEY = new ValueKey(String.valueOf(ProjectAreaBuilder.class.getName()) + ".member");
    private static final ValueKey<IDevelopmentLine> DEVELOPMENT_LINE_KEY = new ValueKey(String.valueOf(TeamAreaBuilder.class.getName()) + ".developmentLine");

    public TeamAreaBuilder(IProcessBuilderContext buildContext) {
        super(buildContext);
        this.setBuilderValue(MEMBERS_KEY, new HashMap());
    }

    public TeamAreaBuilder name(String name) {
        this.setBuilderValue(NAME_KEY, name);
        return this;
    }

    public TeamAreaBuilder archived(boolean archived) {
        this.setBuilderValue(ARCHIVED_KEY, archived);
        return this;
    }

    public TeamAreaBuilder member(IContributorHandle contributor, IRole ... roles) {
        this.getBuilderValue(MEMBERS_KEY).put(contributor, roles);
        return this;
    }

    public TeamAreaBuilder member(IContributorHandle contributor1, IContributorHandle contributor2, IContributorHandle ... contributors) {
        this.member(contributor1, new IRole[0]);
        this.member(contributor2, new IRole[0]);
        IContributorHandle[] iContributorHandleArray = contributors;
        int n = contributors.length;
        int n2 = 0;
        while (n2 < n) {
            IContributorHandle contributor = iContributorHandleArray[n2];
            this.member(contributor, new IRole[0]);
            ++n2;
        }
        return this;
    }

    public TeamAreaBuilder projectArea(IProjectArea projectArea) {
        this.setBuilderValue(PROJECT_AREA_KEY, projectArea);
        return this;
    }

    public TeamAreaBuilder teamArea(TeamAreaBuilder teamAreaBuilder) {
        this.addChildBuilder(teamAreaBuilder);
        return this;
    }

    public TeamAreaBuilder developmentLine(IDevelopmentLine developmentLine) {
        this.setBuilderValue(DEVELOPMENT_LINE_KEY, developmentLine);
        return this;
    }

    @Override
    protected BuildContext contributeToContext(ITeamArea artifact, BuildContext context) {
        BuildContext result = super.contributeToContext(artifact, context);
        result.setProperty(BuildContext.TEAM_AREA, artifact);
        return result;
    }

    @Override
    protected ITeamArea doArtifactSave(BuildContext context) throws TeamRepositoryException {
        if (!context.isPropertySet(BuildContext.PROJECT_AREA)) {
            if (this.artifactExists()) {
                context.setProperty(BuildContext.PROJECT_AREA, (IProjectArea)((IProjectArea)this.getContext().resolve((IItemHandle)((ITeamArea)this.getExistingArtifact()).getProjectArea())).getWorkingCopy());
            } else if (this.isBuilderValueSet(PROJECT_AREA_KEY)) {
                context.setProperty(BuildContext.PROJECT_AREA, this.getBuilderValue(PROJECT_AREA_KEY));
            }
        }
        return this.doArtifactBuild(context);
    }

    @Override
    protected ITeamArea doArtifactBuild(BuildContext context) {
        ITeamArea teamArea = (ITeamArea)this.artifact(ITeamArea.ITEM_TYPE);
        IProjectArea projectArea = this.getBuilderValue(PROJECT_AREA_KEY, context.getProperty(BuildContext.PROJECT_AREA));
        teamArea.setProjectArea((IProjectAreaHandle)(projectArea != null ? projectArea : teamArea.getProjectArea()));
        teamArea.setName(this.chooseValue(NAME_KEY, teamArea.getName(), UUID.generate().getUuidValue()));
        teamArea.setArchived(this.chooseValue(ARCHIVED_KEY, false).booleanValue());
        for (Map.Entry<IContributorHandle, IRole[]> member : this.getBuilderValue(MEMBERS_KEY).entrySet()) {
            teamArea.addMember(member.getKey());
            teamArea.addRoleAssignments(member.getKey(), member.getValue());
        }
        if (projectArea != null) {
            projectArea = (IProjectArea)projectArea.getWorkingCopy();
            ITeamArea parent = context.getProperty(BuildContext.TEAM_AREA);
            ITeamAreaHierarchy hierarchy = projectArea.getTeamAreaHierarchy();
            if (parent == null) {
                IDevelopmentLine devLine = this.getBuilderValue(DEVELOPMENT_LINE_KEY, context.getProperty(BuildContext.DEVELOPMENT_LINE));
                IDevelopmentLineHandle fallback = projectArea.getDevelopmentLines().length > 0 ? projectArea.getDevelopmentLines()[0] : null;
                hierarchy.addRoot((ITeamAreaHandle)teamArea, (IDevelopmentLineHandle)(devLine != null ? devLine : fallback));
            } else {
                hierarchy.addChild((ITeamAreaHandle)parent, (ITeamAreaHandle)teamArea);
            }
            context.updateItem((IItem)projectArea);
        }
        return teamArea;
    }

    @Override
    protected IProcessItem getParentArtifact(ITeamArea teamArea) {
        return (IProcessItem)teamArea.getProjectArea();
    }
}

