/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.common.notification;

import com.ibm.team.build.common.notification.NotificationCriteria;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.process.common.ModelElement;
import java.util.ArrayList;
import java.util.List;

public class NotificationCriteriaFromProjectConfigHelper {
    public static final String NOTIFICATION_PROJECT_CONFIGURATION_DATA_ID = "com.ibm.team.build.configuration.notification";
    public static final String NAMESPACE_ATTRIBUTE_NAME = "xmlns";
    public static final String NAMESPACE_ATTRIBUTE_VALUE = "http://com.ibm.team.build/notification";
    public static final String CRITERIAS_NODE_NAME = "criterias";
    public static final String CRITERIA_NODE_NAME = "criteria";
    public static final String CRITERIA_LABEL_ATTRIBUTE_NAME = "label";
    public static final String CRITERIA_ENABLED_ATTRIBUTE_NAME = "enabled";
    public static final String CRITERIA_PERSONAL_ATTRIBUTE_NAME = "personal";
    public static final String CRITERIA_COMPLETED_ATTRIBUTE_NAME = "completed";
    public static final String CRITERIA_ABANDONED_ATTRIBUTE_NAME = "abandoned";
    public static final String CRITERIA_TRUE_ATTRIBUTE_VALUE = "true";
    public static final String CRITERIA_ALWAYS_ATTRIBUTE_VALUE = "always";
    public static final String CRITERIA_ERRORS_ATTRIBUTE_VALUE = "errors";
    public static final String CRITERIA_SUCCESS_ATTRIBUTE_VALUE = "success";
    public static final String CRITERIA_IGNORE_ATTRIBUTE_VALUE = "ignore";
    public static final String EMAILS_NODE_NAME = "emails";
    public static final String EMAIL_NODE_NAME = "email";
    public static final String EMAIL_ADDRESS_ATTRIBUTE_NAME = "address";
    public static final String USERS_NODE_NAME = "users";
    public static final String USERS_SCM_ATTRIBUTE_NAME = "scm";
    public static final String USERS_REQUEST_ATTRIBUTE_NAME = "request";
    public static final String USERS_TRUE_ATTRIBUTE_VALUE = "true";
    public static final String USER_NODE_NAME = "user";
    public static final String USER_ID_ATTRIBUTE_NAME = "id";
    public static final String ROLES_NODE_NAME = "roles";
    public static final String ROLE_NODE_NAME = "role";
    public static final String ROLE_ID_ATTRIBUTE_NAME = "id";

    public static List<NotificationCriteria> getAllCriterias(ModelElement configurationData) {
        ArrayList<NotificationCriteria> criteriaList = new ArrayList<NotificationCriteria>();
        ArrayList<ModelElement> criteriasElement = new ArrayList<ModelElement>();
        if (CRITERIAS_NODE_NAME.equalsIgnoreCase(configurationData.getName())) {
            criteriasElement.add(configurationData);
        }
        List elements = criteriasElement.isEmpty() ? configurationData.getChildElements() : criteriasElement;
        for (Object element : elements) {
            ModelElement modelElement = (ModelElement)element;
            if (!CRITERIAS_NODE_NAME.equalsIgnoreCase(modelElement.getName())) continue;
            List criterias = modelElement.getChildElements();
            for (Object object : criterias) {
                NotificationCriteria retrievedCriteria;
                ModelElement criteria = (ModelElement)object;
                if (!criteria.getName().equalsIgnoreCase(CRITERIA_NODE_NAME) || (retrievedCriteria = NotificationCriteriaFromProjectConfigHelper.getCriteria(criteria)) == null) continue;
                criteriaList.add(retrievedCriteria);
            }
        }
        return criteriaList;
    }

    public static NotificationCriteria getCriteria(ModelElement modelElement) {
        NotificationCriteria criteria = null;
        if (modelElement.getName().equalsIgnoreCase(CRITERIA_NODE_NAME)) {
            criteria = new NotificationCriteria();
            String value = modelElement.getAttribute(CRITERIA_LABEL_ATTRIBUTE_NAME);
            if (value == null) {
                criteria.setCriteriaName("");
            } else {
                criteria.setCriteriaName(value);
            }
            value = modelElement.getAttribute(CRITERIA_ENABLED_ATTRIBUTE_NAME);
            if (value == null) {
                criteria.setEnabled(false);
            } else {
                criteria.setEnabled(value.equalsIgnoreCase("true"));
            }
            value = modelElement.getAttribute(CRITERIA_PERSONAL_ATTRIBUTE_NAME);
            if (value == null) {
                criteria.setPersonalCriteria(false);
            } else {
                criteria.setPersonalCriteria(value.equalsIgnoreCase("true"));
            }
            value = modelElement.getAttribute(CRITERIA_COMPLETED_ATTRIBUTE_NAME);
            if (value == null) {
                criteria.setNotifyCompletedCondition(NotificationCriteria.NotifyCondition.NEVER);
            } else if (value.equalsIgnoreCase(CRITERIA_ALWAYS_ATTRIBUTE_VALUE)) {
                criteria.setNotifyCompletedCondition(NotificationCriteria.NotifyCondition.ALWAYS);
            } else if (value.equalsIgnoreCase(CRITERIA_ERRORS_ATTRIBUTE_VALUE)) {
                criteria.setNotifyCompletedCondition(NotificationCriteria.NotifyCondition.ON_ERROR);
            } else {
                criteria.setNotifyCompletedCondition(NotificationCriteria.NotifyCondition.NEVER);
            }
            value = modelElement.getAttribute(CRITERIA_ABANDONED_ATTRIBUTE_NAME);
            if (value == null) {
                criteria.setNotifyAbandonedCondition(NotificationCriteria.NotifyCondition.NEVER);
            } else if (value.equalsIgnoreCase(CRITERIA_ALWAYS_ATTRIBUTE_VALUE)) {
                criteria.setNotifyAbandonedCondition(NotificationCriteria.NotifyCondition.ALWAYS);
            } else if (value.equalsIgnoreCase(CRITERIA_ERRORS_ATTRIBUTE_VALUE)) {
                criteria.setNotifyAbandonedCondition(NotificationCriteria.NotifyCondition.ON_ERROR);
            } else {
                criteria.setNotifyAbandonedCondition(NotificationCriteria.NotifyCondition.NEVER);
            }
            List elements = modelElement.getChildElements();
            for (Object object : elements) {
                ModelElement element = (ModelElement)object;
                String name = element.getName();
                if (name.equalsIgnoreCase(EMAILS_NODE_NAME)) {
                    criteria.setEmails(NotificationCriteriaFromProjectConfigHelper.getEmails(element));
                    continue;
                }
                if (name.equalsIgnoreCase(USERS_NODE_NAME)) {
                    criteria.setNotifySCM("true".equalsIgnoreCase(element.getAttribute(USERS_SCM_ATTRIBUTE_NAME)));
                    criteria.setNotifyRequestor("true".equalsIgnoreCase(element.getAttribute(USERS_REQUEST_ATTRIBUTE_NAME)));
                    criteria.setUsers(NotificationCriteriaFromProjectConfigHelper.getUsers(element));
                    continue;
                }
                if (!name.equalsIgnoreCase(ROLES_NODE_NAME)) continue;
                criteria.setRoles(NotificationCriteriaFromProjectConfigHelper.getRoles(element));
            }
        }
        return criteria;
    }

    private static String[] getAttributes(ModelElement modelElement, String nodeName, String attributeName) {
        List elements = modelElement.getChildElements();
        ArrayList<String> attributeValues = new ArrayList<String>(elements.size());
        for (Object object : elements) {
            String value;
            ModelElement element = (ModelElement)object;
            if (!element.getName().equalsIgnoreCase(nodeName) || (value = element.getAttribute(attributeName)) == null) continue;
            attributeValues.add(value);
        }
        return attributeValues.toArray(new String[attributeValues.size()]);
    }

    private static String[] getEmails(ModelElement modelElement) {
        return NotificationCriteriaFromProjectConfigHelper.getAttributes(modelElement, EMAIL_NODE_NAME, EMAIL_ADDRESS_ATTRIBUTE_NAME);
    }

    private static String[] getUsers(ModelElement modelElement) {
        return NotificationCriteriaFromProjectConfigHelper.getAttributes(modelElement, USER_NODE_NAME, "id");
    }

    private static String[] getRoles(ModelElement modelElement) {
        return NotificationCriteriaFromProjectConfigHelper.getAttributes(modelElement, ROLE_NODE_NAME, "id");
    }

    public static void saveCriteriasIntoMemento(String configurationDataId, IMemento memento, List<NotificationCriteria> criterias) {
        memento.putString("id", configurationDataId);
        memento.putString(NAMESPACE_ATTRIBUTE_NAME, NAMESPACE_ATTRIBUTE_VALUE);
        IMemento criteriasMemento = memento.createChild(CRITERIAS_NODE_NAME);
        for (NotificationCriteria criteria : criterias) {
            IMemento criteriaMemento = criteriasMemento.createChild(CRITERIA_NODE_NAME);
            criteriaMemento.putString(CRITERIA_LABEL_ATTRIBUTE_NAME, criteria.getCriteriaName());
            criteriaMemento.putBoolean(CRITERIA_ENABLED_ATTRIBUTE_NAME, criteria.isEnabled());
            criteriaMemento.putBoolean(CRITERIA_PERSONAL_ATTRIBUTE_NAME, criteria.isPersonalCriteria());
            switch (criteria.getNotifyCompletedCondition()) {
                case NEVER: {
                    criteriaMemento.putString(CRITERIA_COMPLETED_ATTRIBUTE_NAME, CRITERIA_IGNORE_ATTRIBUTE_VALUE);
                    break;
                }
                case ON_ERROR: {
                    criteriaMemento.putString(CRITERIA_COMPLETED_ATTRIBUTE_NAME, CRITERIA_ERRORS_ATTRIBUTE_VALUE);
                    break;
                }
                case ALWAYS: {
                    criteriaMemento.putString(CRITERIA_COMPLETED_ATTRIBUTE_NAME, CRITERIA_ALWAYS_ATTRIBUTE_VALUE);
                }
            }
            switch (criteria.getNotifyAbandonedCondition()) {
                case NEVER: {
                    criteriaMemento.putString(CRITERIA_ABANDONED_ATTRIBUTE_NAME, CRITERIA_IGNORE_ATTRIBUTE_VALUE);
                    break;
                }
                case ON_ERROR: {
                    criteriaMemento.putString(CRITERIA_ABANDONED_ATTRIBUTE_NAME, CRITERIA_ERRORS_ATTRIBUTE_VALUE);
                    break;
                }
                case ALWAYS: {
                    criteriaMemento.putString(CRITERIA_ABANDONED_ATTRIBUTE_NAME, CRITERIA_ALWAYS_ATTRIBUTE_VALUE);
                }
            }
            if (criteria.getEmails().length != 0) {
                NotificationCriteriaFromProjectConfigHelper.populateEmails(criteria, criteriaMemento.createChild(EMAILS_NODE_NAME));
            }
            IMemento usersMemento = criteriaMemento.createChild(USERS_NODE_NAME);
            usersMemento.putBoolean(USERS_SCM_ATTRIBUTE_NAME, criteria.isNotifySCM());
            usersMemento.putBoolean(USERS_REQUEST_ATTRIBUTE_NAME, criteria.isNotifyRequestor());
            if (criteria.getUsers().length != 0) {
                NotificationCriteriaFromProjectConfigHelper.populateUsers(criteria, usersMemento);
            }
            if (criteria.getRoles().length == 0) continue;
            NotificationCriteriaFromProjectConfigHelper.populateRoles(criteria, criteriaMemento.createChild(ROLES_NODE_NAME));
        }
    }

    private static void populateStrings(String[] strings, IMemento parentMemento, String nodeName, String attributeName) {
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            IMemento memento = parentMemento.createChild(nodeName);
            memento.putString(attributeName, string);
            ++n2;
        }
    }

    private static void populateEmails(NotificationCriteria criteria, IMemento emailsMemento) {
        NotificationCriteriaFromProjectConfigHelper.populateStrings(criteria.getEmails(), emailsMemento, EMAIL_NODE_NAME, EMAIL_ADDRESS_ATTRIBUTE_NAME);
    }

    private static void populateUsers(NotificationCriteria criteria, IMemento emailsMemento) {
        NotificationCriteriaFromProjectConfigHelper.populateStrings(criteria.getUsers(), emailsMemento, USER_NODE_NAME, "id");
    }

    private static void populateRoles(NotificationCriteria criteria, IMemento emailsMemento) {
        NotificationCriteriaFromProjectConfigHelper.populateStrings(criteria.getRoles(), emailsMemento, ROLE_NODE_NAME, "id");
    }
}

