/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common;

import com.ibm.team.repository.common.internal.util.StringUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Version
implements Comparable<Version> {
    private String in;
    private int[] parts;
    private static ConcurrentMap<String, Version> PARSED = new ConcurrentHashMap<String, Version>(10, 0.75f, 4);
    private static String DEFAULT_VERSION = "0";

    public static Version getVersion(String in) {
        Version old;
        Version v;
        if (in == null) {
            in = DEFAULT_VERSION;
        }
        if ((v = (Version)PARSED.get(in)) == null && (old = PARSED.putIfAbsent(in, v = new Version(in))) != null) {
            v = old;
        }
        return v;
    }

    public Version(String in) {
        if (in == null) {
            in = DEFAULT_VERSION;
        }
        this.in = in;
        this.parts = Version.parse(in);
    }

    public Version(int ... v) {
        this.in = StringUtils.join(v, ".");
        this.parts = v;
    }

    public boolean isAtLeast(int ... v) {
        return this.isAtLeast(new Version(v));
    }

    public boolean isAtLeast(String v) {
        return this.isAtLeast(Version.getVersion(v));
    }

    public boolean isAtLeast(Version v) {
        return this.compareTo(v) >= 0;
    }

    public boolean isGreaterThan(Version v) {
        return this.compareTo(v) > 0;
    }

    private static final int[] parse(String in) {
        String[] p = in.split("\\.");
        int[] parts = new int[p.length];
        int i = 0;
        while (i < parts.length) {
            parts[i] = p[i].isEmpty() ? 0 : Integer.parseInt(p[i]);
            ++i;
        }
        return parts;
    }

    public String toString() {
        return this.in;
    }

    @Override
    public int compareTo(Version v) {
        if (this == v) {
            return 0;
        }
        int i = 0;
        while (i < Math.min(this.parts.length, v.parts.length)) {
            if (this.parts[i] < v.parts[i]) {
                return -1;
            }
            if (this.parts[i] > v.parts[i]) {
                return 1;
            }
            ++i;
        }
        if (v.parts.length > this.parts.length) {
            i = this.parts.length;
            while (i < v.parts.length) {
                if (v.parts[i] > 0) {
                    return -1;
                }
                ++i;
            }
        }
        if (v.parts.length < this.parts.length) {
            i = v.parts.length;
            while (i < this.parts.length) {
                if (this.parts[i] > 0) {
                    return 1;
                }
                ++i;
            }
        }
        return 0;
    }

    public boolean equals(Object v) {
        if (v instanceof Version) {
            return this.compareTo((Version)v) == 0;
        }
        return false;
    }

    public int hashCode() {
        return this.in.hashCode();
    }
}

