/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.MetronomeEventModel;
import com.ibm.team.repository.client.IStatistics;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.IPropertyChangeEvent;
import com.ibm.team.repository.common.IItemType;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class MetronomeModel
extends EventSource
implements IListener,
ITeamRepositoryService.IRepositoryServiceListener {
    private static volatile MetronomeModel INSTANCE;
    private final ConcurrentHashMap<IStatistics, RepoStats> repoStatistics = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MetronomeModel getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<MetronomeModel> clazz = MetronomeModel.class;
        synchronized (MetronomeModel.class) {
            if (INSTANCE != null) return INSTANCE;
            MetronomeModel model = new MetronomeModel();
            model.init();
            INSTANCE = model;
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITeamRepository watch(ITeamRepository repo) {
        if (repo == null) {
            return null;
        }
        Class<MetronomeModel> clazz = MetronomeModel.class;
        synchronized (MetronomeModel.class) {
            if (INSTANCE == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return repo;
            }
            INSTANCE.addedRepository(repo);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return repo;
        }
    }

    private MetronomeModel() {
    }

    private void init() {
        ITeamRepositoryService rs = TeamPlatform.getTeamRepositoryService();
        rs.addRepositoryServiceListener((ITeamRepositoryService.IRepositoryServiceListener)this);
        ITeamRepository[] repo = rs.getTeamRepositories();
        int i = 0;
        while (i < repo.length) {
            this.addedRepository(repo[i]);
            ++i;
        }
    }

    public void addedRepository(ITeamRepository repository) {
        RepoStats rs;
        MetronomeEventModel.addRepositoryToInstance(repository);
        IStatistics stats = repository.statistics();
        if (!this.repoStatistics.containsKey(stats) && this.repoStatistics.putIfAbsent(stats, rs = new RepoStats()) == null) {
            stats.addGenericListener((Object)"com.ibm.team.repository.statistics.serviceMethod", (IListener)this);
            stats.addGenericListener((Object)"com.ibm.team.repository.statistics.itemType", (IListener)this);
        }
    }

    public void removedRepository(ITeamRepository repository) {
        IStatistics stats = repository.statistics();
        RepoStats rs = this.repoStatistics.remove(stats);
        if (rs != null) {
            stats.removeGenericListener((Object)"com.ibm.team.repository.statistics.serviceMethod", (IListener)this);
            stats.removeGenericListener((Object)"com.ibm.team.repository.statistics.itemType", (IListener)this);
        }
    }

    public void handleEvents(List events) {
        for (IPropertyChangeEvent event : events) {
            IItemType itemType;
            ConcurrentHashMap<IItemType, ItemTypeStats> itemTypes;
            IStatistics stats = (IStatistics)event.getEventSource();
            RepoStats rs = this.repoStatistics.get(stats);
            if (rs == null) continue;
            Object obj = event.getObject();
            if (obj instanceof Method) {
                long worstSoFar;
                MethodStats old;
                ConcurrentHashMap<Method, MethodStats> methods;
                MethodStats ms;
                ServiceStats old2;
                ConcurrentHashMap<Class<?>, ServiceStats> services = rs.services;
                Method method = (Method)obj;
                Class<?> service = method.getDeclaringClass();
                ServiceStats ss = services.get(service);
                if (ss == null && (old2 = services.putIfAbsent(service, ss = new ServiceStats())) != null) {
                    ss = old2;
                }
                if ((ms = (methods = ss.methods).get(method)) == null && (old = methods.putIfAbsent(method, ms = new MethodStats(method))) != null) {
                    ms = old;
                }
                Long timeBefore = (Long)event.getOldValue();
                Long timeAfter = (Long)event.getNewValue();
                long elapsedTime = timeAfter - timeBefore;
                while ((worstSoFar = ms.worstElapsedTimeSoFar.get()) < elapsedTime && !ms.worstElapsedTimeSoFar.compareAndSet(worstSoFar, elapsedTime)) {
                }
            } else if (obj instanceof IItemType && !(itemTypes = rs.itemTypes).containsKey(itemType = (IItemType)obj)) {
                ItemTypeStats itemTypeStats = new ItemTypeStats(itemType);
                itemTypes.putIfAbsent(itemType, itemTypeStats);
            }
            if (!this.hasGenericListeners()) continue;
            this.queueEvent(event);
        }
    }

    public Class<?>[] getServices(IStatistics statistics) {
        RepoStats rs = this.repoStatistics.get(statistics);
        if (rs == null) {
            return new Class[0];
        }
        Set services = rs.services.keySet();
        return services.toArray(new Class[services.size()]);
    }

    public Method[] getMethods(IStatistics statistics, Class<?> service) {
        RepoStats rs = this.repoStatistics.get(statistics);
        if (rs == null) {
            return new Method[0];
        }
        ServiceStats ss = rs.services.get(service);
        Set methods = ss.methods.keySet();
        return methods.toArray(new Method[methods.size()]);
    }

    public IItemType[] getItemTypes(IStatistics statistics) {
        RepoStats rs = this.repoStatistics.get(statistics);
        if (rs == null) {
            return new IItemType[0];
        }
        Set itemTypes = rs.itemTypes.keySet();
        return itemTypes.toArray(new IItemType[itemTypes.size()]);
    }

    public String[] getServiceData(IStatistics statistics, Class<?> service) {
        long serviceCallCount = this.getServiceCallCount(statistics, service);
        double serviceElapstedTime = (double)this.getServiceElapsedTime(statistics, service) / 1000.0;
        long serviceTimeRatio = this.getServiceTimeRatio(statistics, service);
        double serviceAverageTime = this.getServiceAverageTime(statistics, service) / 1000.0;
        double serviceWorstTime = (double)this.getServiceWorstTime(statistics, service) / 1000.0;
        return new String[]{this.getServiceName(service), Long.toString(serviceCallCount), Double.toString(serviceElapstedTime), Long.toString(serviceTimeRatio), Double.toString(serviceAverageTime), Double.toString(serviceWorstTime), this.getFullServiceName(service)};
    }

    public String[] getMethodData(IStatistics statistics, Class<?> service, Method method) {
        return new String[]{this.getMethodName(method), Long.toString(this.getMethodCallCount(statistics, service, method)), Double.toString((double)this.getMethodElapsedTime(statistics, service, method) / 1000.0), Long.toString(this.getMethodTimeRatio(statistics, service, method)), Double.toString(this.getMethodAverageTime(statistics, service, method) / 1000.0), Double.toString((double)this.getMethodWorstTime(statistics, service, method) / 1000.0), this.getFullMethodName(method)};
    }

    public String[] getItemTypeData(IStatistics statistics, IItemType itemType) {
        return new String[]{this.getItemTypeName(itemType), Long.toString(this.getItemCount(statistics, itemType)), Long.toString(this.getItemSize(statistics, itemType)), Long.toString(this.getItemSizeRatio(statistics, itemType)), Long.toString(this.getItemHits(statistics, itemType)), Long.toString(this.getItemMisses(statistics, itemType)), Long.toString(this.getItemRefreshes(statistics, itemType))};
    }

    public String getMethodName(Method method) {
        return method.getName();
    }

    public String getFullMethodName(Method method) {
        return String.valueOf(method.getDeclaringClass().getName()) + "." + method.getName();
    }

    public String getServiceName(Class<?> service) {
        String fullServiceName = this.getFullServiceName(service);
        return fullServiceName.substring(fullServiceName.lastIndexOf(46) + 1);
    }

    private String getFullServiceName(Class<?> service) {
        return service.getName();
    }

    public long getServiceCallCount(IStatistics statistics, Class<?> service) {
        RepoStats rs = this.repoStatistics.get(statistics);
        if (rs == null) {
            return 0L;
        }
        long count = 0L;
        ServiceStats ss = rs.services.get(service);
        for (MethodStats ms : ss.methods.values()) {
            count += this.getMethodCallCount(statistics, ms);
        }
        return count;
    }

    public long getServiceRetryCount(IStatistics statistics, Class<?> service) {
        RepoStats rs = this.repoStatistics.get(statistics);
        if (rs == null) {
            return 0L;
        }
        long count = 0L;
        ServiceStats ss = rs.services.get(service);
        for (MethodStats ms : ss.methods.values()) {
            count += this.getMethodRetryCount(statistics, ms);
        }
        return count;
    }

    public long getServiceElapsedTime(IStatistics statistics, Class<?> service) {
        RepoStats rs = this.repoStatistics.get(statistics);
        if (rs == null) {
            return 0L;
        }
        long count = 0L;
        ServiceStats ss = rs.services.get(service);
        for (MethodStats ms : ss.methods.values()) {
            count += this.getMethodElapsedTime(statistics, ms);
        }
        return count;
    }

    public long getServiceTimeRatio(IStatistics statistics, Class<?> service) {
        return Math.round((double)this.getServiceElapsedTime(statistics, service) / (double)this.getTotalElapsedTime(statistics) * 100.0);
    }

    private double getServiceAverageTime(IStatistics statistics, Class<?> service) {
        return Math.round((double)this.getServiceElapsedTime(statistics, service) / (double)this.getServiceCallCount(statistics, service));
    }

    public long getServiceWorstTime(IStatistics statistics, Class<?> service) {
        RepoStats rs = this.repoStatistics.get(statistics);
        if (rs == null) {
            return 0L;
        }
        ServiceStats ss = rs.services.get(service);
        Iterator<MethodStats> it = ss.methods.values().iterator();
        long worstSoFar = Long.MIN_VALUE;
        while (it.hasNext()) {
            MethodStats ms = it.next();
            long value = ms.worstElapsedTimeSoFar.get();
            if (worstSoFar >= value) continue;
            worstSoFar = value;
        }
        return worstSoFar;
    }

    public long getMethodCallCount(IStatistics statistics, Class<?> service, Method method) {
        RepoStats rs = this.repoStatistics.get(statistics);
        if (rs == null) {
            return 0L;
        }
        ServiceStats ss = rs.services.get(service);
        MethodStats ms = ss.methods.get(method);
        return this.getMethodCallCount(statistics, ms);
    }

    public long getMethodRetryCount(IStatistics statistics, Class<?> service, Method method) {
        RepoStats rs = this.repoStatistics.get(statistics);
        if (rs == null) {
            return 0L;
        }
        ServiceStats ss = rs.services.get(service);
        MethodStats ms = ss.methods.get(method);
        return this.getMethodRetryCount(statistics, ms);
    }

    private long getMethodCallCount(IStatistics statistics, MethodStats ms) {
        return statistics.getServiceMethodCallCount(ms.method) - ms.callCountWhenLastReset;
    }

    private long getMethodRetryCount(IStatistics statistics, MethodStats ms) {
        return statistics.getServiceMethodRetryCount(ms.method) - ms.retryCountWhenLastReset;
    }

    public long getMethodElapsedTime(IStatistics statistics, Class<?> service, Method method) {
        RepoStats rs = this.repoStatistics.get(statistics);
        if (rs == null) {
            return 0L;
        }
        ServiceStats ss = rs.services.get(service);
        MethodStats ms = ss.methods.get(method);
        return this.getMethodElapsedTime(statistics, ms);
    }

    private long getMethodElapsedTime(IStatistics statistics, MethodStats ms) {
        return statistics.getServiceMethodElapsedTime(ms.method) - ms.elapsedTimeWhenLastReset;
    }

    private long getMethodTimeRatio(IStatistics statistics, Class<?> service, Method method) {
        return Math.round((double)this.getMethodElapsedTime(statistics, service, method) / (double)this.getTotalElapsedTime(statistics) * 100.0);
    }

    private double getMethodAverageTime(IStatistics statistics, Class<?> service, Method method) {
        return Math.round((double)this.getMethodElapsedTime(statistics, service, method) / (double)this.getMethodCallCount(statistics, service, method));
    }

    public long getMethodWorstTime(IStatistics statistics, Class<?> service, Method method) {
        RepoStats rs = this.repoStatistics.get(statistics);
        if (rs == null) {
            return 0L;
        }
        ServiceStats ss = rs.services.get(service);
        MethodStats ms = ss.methods.get(method);
        return ms.worstElapsedTimeSoFar.get();
    }

    public String getItemTypeName(IItemType itemType) {
        return String.valueOf(itemType.getNamespaceURI()) + "#" + itemType.getName();
    }

    public long getItemCount(IStatistics statistics, IItemType itemType) {
        return statistics.getItemTypeCacheCount(itemType);
    }

    public long getItemSize(IStatistics statistics, IItemType itemType) {
        return statistics.getItemTypeCacheSize(itemType);
    }

    private long getItemSizeRatio(IStatistics statistics, IItemType itemType) {
        return Math.round((double)this.getItemSize(statistics, itemType) / (double)this.getTotalCacheSize(statistics) * 100.0);
    }

    public long getItemHits(IStatistics statistics, IItemType itemType) {
        RepoStats rs = this.repoStatistics.get(statistics);
        if (rs == null) {
            return 0L;
        }
        ItemTypeStats itemTypes = rs.itemTypes.get(itemType);
        return statistics.getItemTypeCacheHits(itemType) - itemTypes.cacheHitsWhenLastReset;
    }

    public long getItemMisses(IStatistics statistics, IItemType itemType) {
        RepoStats rs = this.repoStatistics.get(statistics);
        if (rs == null) {
            return 0L;
        }
        ItemTypeStats itemTypes = rs.itemTypes.get(itemType);
        return statistics.getItemTypeCacheMisses(itemType) - itemTypes.cacheMissesWhenLastReset;
    }

    public long getItemRefreshes(IStatistics statistics, IItemType itemType) {
        RepoStats rs = this.repoStatistics.get(statistics);
        if (rs == null) {
            return 0L;
        }
        ItemTypeStats itemTypes = rs.itemTypes.get(itemType);
        return statistics.getItemTypeCacheRefreshes(itemType) - itemTypes.cacheRefreshesWhenLastReset;
    }

    public long getTotalMethodCount(IStatistics statistics) {
        RepoStats rs = this.repoStatistics.get(statistics);
        if (rs == null) {
            return 0L;
        }
        return statistics.getTotalServiceCallCount() - rs.totalCallCountWhenLastReset;
    }

    public long getTotalMethodRetries(IStatistics statistics) {
        RepoStats rs = this.repoStatistics.get(statistics);
        if (rs == null) {
            return 0L;
        }
        return statistics.getTotalServiceRetryCount() - rs.totalRetryCountWhenLastReset;
    }

    public long getTotalElapsedTime(IStatistics statistics) {
        RepoStats rs = this.repoStatistics.get(statistics);
        if (rs == null) {
            return 0L;
        }
        return statistics.getTotalServiceElapsedTime() - rs.totalElapsedTimeWhenLastReset;
    }

    public long getTotalItemCount(IStatistics statistics) {
        return statistics.getTotalCacheCount();
    }

    public long getTotalCacheSize(IStatistics statistics) {
        return statistics.getTotalCacheSize();
    }

    public void resetServiceMethodStats(IStatistics statistics) {
        RepoStats rs = this.repoStatistics.get(statistics);
        if (rs == null) {
            return;
        }
        rs.totalCallCountWhenLastReset = statistics.getTotalServiceCallCount();
        rs.totalRetryCountWhenLastReset = statistics.getTotalServiceRetryCount();
        rs.totalElapsedTimeWhenLastReset = statistics.getTotalServiceElapsedTime();
        for (ServiceStats ss : rs.services.values()) {
            ConcurrentHashMap<Method, MethodStats> methods = ss.methods;
            for (MethodStats ms : methods.values()) {
                ms.callCountWhenLastReset = statistics.getServiceMethodCallCount(ms.method);
                ms.retryCountWhenLastReset = statistics.getServiceMethodRetryCount(ms.method);
                ms.elapsedTimeWhenLastReset = statistics.getServiceMethodElapsedTime(ms.method);
                ms.worstElapsedTimeSoFar.set(0L);
            }
        }
    }

    public void resetItemTypeStats(IStatistics statistics) {
        RepoStats rs = this.repoStatistics.get(statistics);
        if (rs == null) {
            return;
        }
        for (ItemTypeStats is : rs.itemTypes.values()) {
            is.cacheHitsWhenLastReset = statistics.getItemTypeCacheHits(is.itemType);
            is.cacheMissesWhenLastReset = statistics.getItemTypeCacheMisses(is.itemType);
            is.cacheRefreshesWhenLastReset = statistics.getItemTypeCacheRefreshes(is.itemType);
        }
    }

    private class ItemTypeStats {
        final IItemType itemType;
        long cacheHitsWhenLastReset;
        long cacheMissesWhenLastReset;
        long cacheRefreshesWhenLastReset;

        ItemTypeStats(IItemType itemType) {
            this.itemType = itemType;
            this.cacheHitsWhenLastReset = 0L;
            this.cacheMissesWhenLastReset = 0L;
            this.cacheRefreshesWhenLastReset = 0L;
        }
    }

    private class MethodStats {
        final Method method;
        long callCountWhenLastReset;
        long retryCountWhenLastReset;
        long elapsedTimeWhenLastReset;
        final AtomicLong worstElapsedTimeSoFar;

        MethodStats(Method method) {
            this.method = method;
            this.callCountWhenLastReset = 0L;
            this.retryCountWhenLastReset = 0L;
            this.elapsedTimeWhenLastReset = 0L;
            this.worstElapsedTimeSoFar = new AtomicLong(0L);
        }
    }

    private class RepoStats {
        final ConcurrentHashMap<Class<?>, ServiceStats> services = new ConcurrentHashMap();
        final ConcurrentHashMap<IItemType, ItemTypeStats> itemTypes = new ConcurrentHashMap();
        long totalCallCountWhenLastReset = 0L;
        long totalRetryCountWhenLastReset = 0L;
        long totalElapsedTimeWhenLastReset = 0L;

        RepoStats() {
        }
    }

    private class ServiceStats {
        final ConcurrentHashMap<Method, MethodStats> methods = new ConcurrentHashMap();

        ServiceStats() {
        }
    }
}

