/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.repository.common.LogFactory;

public class ReadWriteLock {
    private final LockStatus status = new LockStatus();
    private final ThreadLocal<LockStatus> threadStatus = new ThreadLocal<LockStatus>(){

        @Override
        protected synchronized LockStatus initialValue() {
            return new LockStatus();
        }
    };

    public void acquireRead() {
        this.acquireRead(true);
    }

    public boolean tryAcquireRead() {
        return this.acquireRead(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean acquireRead(boolean doWait) {
        LockStatus threadStatus = this.threadStatus.get();
        boolean interrupted = false;
        LockStatus lockStatus = this.status;
        synchronized (lockStatus) {
            while (true) {
                if (this.status.writes == threadStatus.writes) {
                    ++this.status.reads;
                    break;
                }
                if (!doWait) {
                    return false;
                }
                try {
                    this.status.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    LogFactory.getLog((String)ReadWriteLock.class.getName()).warn((Object)"We were interrupted", (Throwable)e);
                }
            }
        }
        ++threadStatus.reads;
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return true;
    }

    public void acquireWrite() {
        this.acquireWrite(true);
    }

    public boolean tryAcquireWrite() {
        return this.acquireWrite(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean acquireWrite(boolean doWait) {
        LockStatus threadStatus = this.threadStatus.get();
        if (threadStatus.reads != 0) {
            throw new IllegalStateException("nesting of write lock inside read lock is illegal");
        }
        boolean interrupted = false;
        LockStatus lockStatus = this.status;
        synchronized (lockStatus) {
            while (true) {
                if (this.status.reads == 0 && this.status.writes == threadStatus.writes) {
                    ++this.status.writes;
                    break;
                }
                if (!doWait) {
                    return false;
                }
                try {
                    this.status.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    LogFactory.getLog((String)ReadWriteLock.class.getName()).warn((Object)"We were interrupted", (Throwable)e);
                }
            }
        }
        ++threadStatus.writes;
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean release() {
        boolean available;
        LockStatus threadStatus = this.threadStatus.get();
        if (threadStatus.reads != 0) {
            LockStatus lockStatus = this.status;
            synchronized (lockStatus) {
                --this.status.reads;
                available = this.status.reads == 0;
                this.status.notifyAll();
            }
            --threadStatus.reads;
            available = available && threadStatus.writes == 0;
        } else if (threadStatus.writes != 0) {
            LockStatus lockStatus = this.status;
            synchronized (lockStatus) {
                --this.status.writes;
                this.status.notifyAll();
            }
            --threadStatus.writes;
            available = threadStatus.writes == 0;
        } else {
            throw new IllegalStateException("releasing an unlocked lock is illegal");
        }
        return available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reads() {
        LockStatus lockStatus = this.status;
        synchronized (lockStatus) {
            return this.status.reads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writes() {
        LockStatus lockStatus = this.status;
        synchronized (lockStatus) {
            return this.status.writes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int locks() {
        LockStatus lockStatus = this.status;
        synchronized (lockStatus) {
            return this.status.reads + this.status.writes;
        }
    }

    public int threadReads() {
        return this.threadStatus.get().reads;
    }

    public int threadWrites() {
        return this.threadStatus.get().writes;
    }

    public int threadLocks() {
        LockStatus s = this.threadStatus.get();
        return s.reads + s.writes;
    }

    public String toString() {
        return "reads: " + this.threadReads() + "/" + this.reads() + " - writes: " + this.threadWrites() + "/" + this.writes();
    }

    private static class LockStatus {
        public int reads = 0;
        public int writes = 0;

        private LockStatus() {
        }
    }
}

