/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.checkin;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IFileContentManagerSession;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LinkInfo;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.MetadataProperties;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.api.storage.IRetryRequest;
import com.ibm.team.filesystem.client.internal.checkin.ChangeSetChooser;
import com.ibm.team.filesystem.client.internal.checkin.CheckinUploadData;
import com.ibm.team.filesystem.client.internal.checkin.CheckinUploadHandler;
import com.ibm.team.filesystem.client.internal.checkin.DeletedPredecessorUploadFailure;
import com.ibm.team.filesystem.client.internal.checkin.EncodingUploadFailure;
import com.ibm.team.filesystem.client.internal.checkin.LineDelimiterUploadFailure;
import com.ibm.team.filesystem.client.internal.checkin.LocalChangeCheckinRequest;
import com.ibm.team.filesystem.client.internal.checkin.ShareableCheckinRequest;
import com.ibm.team.filesystem.client.internal.checkin.UploadFailure;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChange;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.NonCancellingProgressMonitor;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.filesystem.common.internal.FileItem;
import com.ibm.team.filesystem.common.internal.FilesystemFactory;
import com.ibm.team.filesystem.common.internal.SymbolicLink;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.ConfigurationDescriptor;
import com.ibm.team.scm.client.internal.IConfigurationDescriptor;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.FolderEntryConflictException;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.ICurrentPatch;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableChange;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.LocaleUtil;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.IItemUpdateReport;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.internal.Folder;
import com.ibm.team.scm.common.internal.ScmFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class NewCheckInOperation
extends FileSystemOperation
implements ICheckinOperation {
    private final Collection<ComponentCheckInRequest> componentRequests = new LinkedList<ComponentCheckInRequest>();
    protected final Map<UUID, IChangeSetHandle> changeSetsCommitted = new HashMap<UUID, IChangeSetHandle>();
    protected final CommitDilemmaHandler commitProblemHandler;
    private boolean refreshBeforeRun = false;
    private Map<UUID, Map<UUID, IVersionable>> savedVersionable = new HashMap<UUID, Map<UUID, IVersionable>>();
    private Shed backupShed;
    private final IRepositoryResolver resolver;
    private boolean nonAtomicCommitIsAnOption = true;
    private int uploadLimit = 200;

    @Override
    public Collection<IChangeSetHandle> getCommittedChangeSets() {
        return this.changeSetsCommitted.values();
    }

    public NewCheckInOperation(CommitDilemmaHandler commitProblemHandler, IRepositoryResolver resolver) {
        super(commitProblemHandler == null ? CommitDilemmaHandler.getDefault() : commitProblemHandler);
        if (resolver == null) {
            throw new IllegalArgumentException();
        }
        this.commitProblemHandler = commitProblemHandler == null ? CommitDilemmaHandler.getDefault() : commitProblemHandler;
        this.resolver = resolver;
        this.backupShed = new Shed(this.commitProblemHandler.getBackupDilemmaHandler());
    }

    @Override
    public void requestCheckin(IShareable[] toCommit, IChangeSetHandle changeSet, String commentForNewChangeSet, IProgressMonitor progress) throws FileSystemException {
        if (toCommit == null) {
            throw new IllegalArgumentException("Call requestCheckin() with just the workspace/component");
        }
        HashMap grouped = new HashMap();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.NewCheckInOperation_GETTING_READY_TO_UPLOAD, (int)(toCommit.length * 6));
        monitor.subTask(Messages.NewCheckInOperation_ORDERING_CHANGES_TO_LOCAL_FILES_AND_FOLDERS);
        IShareable[] iShareableArray = toCommit;
        int n = toCommit.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository;
            IShare share;
            IShareable shareable = iShareableArray[n2];
            HashMap<ConfigurationFacade, LinkedList<IShareable>> configs = (HashMap<ConfigurationFacade, LinkedList<IShareable>>)grouped.get(shareable.getSandbox());
            if (configs == null) {
                configs = new HashMap<ConfigurationFacade, LinkedList<IShareable>>();
                grouped.put(shareable.getSandbox(), configs);
            }
            if ((share = shareable.getShare((IProgressMonitor)monitor.newChild(1))) == null) {
                throw new FileSystemException(Messages.NewCheckInOperation_MISSING_SHARE);
            }
            try {
                repository = this.resolver.getRepoFor(null, share.getSharingDescriptor().getRepositoryId());
            }
            catch (TeamRepositoryException teamRepositoryException) {
                throw new FileSystemException(NLS.bind((String)Messages.NewCheckInOperation_26, (Object)shareable.getLocalPath().toString(), (Object[])new Object[]{share.getSharingDescriptor().getConnectionName()}));
            }
            ConfigurationFacade descriptor = null;
            descriptor = new ConfigurationFacade(repository, share.getSharingDescriptor());
            LinkedList<IShareable> shareables = (LinkedList<IShareable>)configs.get((Object)descriptor);
            if (shareables == null) {
                shareables = new LinkedList<IShareable>();
                configs.put(descriptor, shareables);
            }
            shareables.add(shareable);
            ++n2;
        }
        if (changeSet != null) {
            monitor.setWorkRemaining(grouped.size() * 2);
            monitor.subTask(Messages.NewCheckInOperation_ENSURE_CHANGESET_SANE);
            for (Map.Entry group : grouped.entrySet()) {
                this.validateChangeset(((HashMap)group.getValue()).keySet(), changeSet, monitor.newChild(1));
            }
        }
        monitor.subTask(Messages.NewCheckInOperation_ORDERING_CHANGES_TO_FILES);
        monitor.setWorkRemaining(grouped.size());
        for (Map.Entry group : grouped.entrySet()) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor.newChild(1), (int)(((HashMap)group.getValue()).size() * 2));
            for (Map.Entry req : ((HashMap)group.getValue()).entrySet()) {
                IWorkspaceConnection wsConn;
                try {
                    IConnection conn = ((ConfigurationFacade)((Object)req.getKey())).getConnection((IProgressMonitor)subMonitor.newChild(1));
                    if (!(conn instanceof IWorkspaceConnection)) {
                        throw new FileSystemException(Messages.NewCheckInOperation_25);
                    }
                    wsConn = (IWorkspaceConnection)conn;
                }
                catch (TeamRepositoryException e) {
                    throw new FileSystemException(Messages.NewCheckInOperation_COULD_NOT_GET_CONNECTION, e);
                }
                IComponentHandle myComponent = ((ConfigurationFacade)((Object)req.getKey())).getComponentHandle();
                this.validateShareableRequest((ISandbox)group.getKey(), (IConnection)wsConn, myComponent, (List)req.getValue(), (IProgressMonitor)subMonitor.newChild(1));
                IShareable[] shareables = ((List)req.getValue()).toArray(new IShareable[((List)req.getValue()).size()]);
                this.componentRequests.add(new ShareableCheckinRequest(wsConn, myComponent, (ISandbox)group.getKey(), shareables, changeSet, commentForNewChangeSet));
            }
        }
    }

    private void validateChangeset(Set<ConfigurationFacade> configs, IChangeSetHandle changeSet, SubMonitor monitor) throws FileSystemException {
        monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)configs.size());
        for (ConfigurationFacade desc : configs) {
            IChangeSet cs;
            try {
                cs = (IChangeSet)desc.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)changeSet, 0, (IProgressMonitor)monitor.newChild(1));
            }
            catch (TeamRepositoryException e) {
                throw new FileSystemException(Messages.NewCheckInOperation_FAILURE_GETTING_COMPLETE_ITEM_STATE, e);
            }
            if (desc.getComponentHandle().sameItemId((IItemHandle)cs.getComponent())) continue;
            throw new FileSystemException(Messages.NewCheckInOperation_INCONSISTENT_COMPONENT);
        }
    }

    @Override
    public void requestCheckin(ILocalChange[] toCommit, IChangeSetHandle changeSet, String commentForNewChangeSet, IProgressMonitor progress) throws FileSystemException {
        if (toCommit == null) {
            throw new IllegalArgumentException("Call requestCheckin() with just the workspace/component");
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(toCommit.length * 2));
        HashMap grouped = new HashMap();
        ILocalChange[] iLocalChangeArray = toCommit;
        int n = toCommit.length;
        int n2 = 0;
        while (n2 < n) {
            ITeamRepository repository;
            IShareable shareable;
            ILocalChange change = iLocalChangeArray[n2];
            ILocation cfaPath = ((LocalChange)change).getCfaRoot();
            HashMap<ConfigurationFacade, LinkedList<ILocalChange>> connections = (HashMap<ConfigurationFacade, LinkedList<ILocalChange>>)grouped.get(cfaPath);
            if (connections == null) {
                connections = new HashMap<ConfigurationFacade, LinkedList<ILocalChange>>();
                grouped.put(cfaPath, connections);
            }
            if ((shareable = change.getShareable()) == null) {
                throw new FileSystemException(Messages.NewCheckInOperation_MISSING_FILE_OR_FOLDER_FOR_CHANGE);
            }
            IShare desc = SharingManager.getInstance().getShare(shareable.getSandbox().getRoot(), change.getConnection(), change.getComponent(), change.getTarget(), (IProgressMonitor)monitor.newChild(1));
            if (desc == null) {
                throw new FileSystemException(Messages.NewCheckInOperation_NOT_SHARED);
            }
            try {
                repository = this.resolver.getRepoFor(null, desc.getSharingDescriptor().getRepositoryId());
            }
            catch (TeamRepositoryException e) {
                throw new FileSystemException(NLS.bind((String)Messages.NewCheckInOperation_24, (Object)shareable.getLocalPath().toString(), (Object[])new Object[]{desc.getSharingDescriptor().getConnectionName()}), e);
            }
            ConfigurationFacade configurationDescriptor = new ConfigurationFacade(repository, desc.getSharingDescriptor());
            LinkedList<ILocalChange> changes = (LinkedList<ILocalChange>)connections.get((Object)configurationDescriptor);
            if (changes == null) {
                changes = new LinkedList<ILocalChange>();
                connections.put(configurationDescriptor, changes);
            }
            changes.add(change);
            ++n2;
        }
        if (changeSet != null) {
            monitor.setWorkRemaining(grouped.size() * 2);
            monitor.subTask(Messages.NewCheckInOperation_ENSURE_CHANGESET_SANE);
            for (Map.Entry group : grouped.entrySet()) {
                this.validateChangeset(((HashMap)group.getValue()).keySet(), changeSet, monitor.newChild(1));
            }
        }
        monitor.setWorkRemaining(grouped.size());
        for (Map.Entry group : grouped.entrySet()) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor.newChild(1), (int)(((HashMap)group.getValue()).size() * 2));
            for (Map.Entry req : ((HashMap)group.getValue()).entrySet()) {
                IWorkspaceConnection wsConn;
                try {
                    IConnection conn = ((ConfigurationFacade)((Object)req.getKey())).getConnection((IProgressMonitor)subMonitor.newChild(1));
                    if (conn == null) {
                        IShare share;
                        ILocalChange change;
                        String error = Messages.NewCheckInOperation_27;
                        if (!((List)req.getValue()).isEmpty() && (change = (ILocalChange)((List)req.getValue()).get(0)).getShareable() != null && (share = change.getShareable().getShare((IProgressMonitor)subMonitor.newChild(1))) != null) {
                            error = NLS.bind((String)Messages.NewCheckInOperation_28, (Object)share.getSharingDescriptor().getConnectionName(), (Object[])new Object[0]);
                        }
                        throw new FileSystemException(error);
                    }
                    if (!(conn instanceof IWorkspaceConnection)) {
                        throw new IllegalArgumentException("Attempt to commit into a non-workspace connection");
                    }
                    wsConn = (IWorkspaceConnection)conn;
                }
                catch (TeamRepositoryException e) {
                    throw new FileSystemException(Messages.NewCheckInOperation_COULD_NOT_GET_CONNECTION, e);
                }
                IComponentHandle myComponent = ((ConfigurationFacade)((Object)req.getKey())).getComponentHandle();
                this.componentRequests.add(new LocalChangeCheckinRequest(wsConn, myComponent, new Sandbox((ILocation)group.getKey()), ((List)req.getValue()).toArray(new ILocalChange[((List)req.getValue()).size()]), changeSet, commentForNewChangeSet));
            }
        }
    }

    static ISchedulingRule generateRuleFor(IWorkspaceConnection wsConn, IComponentHandle component, ILocalChange[] changes, IProgressMonitor monitor) throws FileSystemException {
        HashSet<IShare> shares = new HashSet<IShare>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)changes.length);
        ILocalChange[] iLocalChangeArray = changes;
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange change = iLocalChangeArray[n2];
            IShare share = change.getShareable().getShare((IProgressMonitor)progress.newChild(1));
            ISharingDescriptor desc = share.getSharingDescriptor();
            if (desc.getConnectionHandle().sameItemId((IItemHandle)wsConn.getContextHandle()) && desc.getComponent().sameItemId((IItemHandle)component)) {
                shares.add(share);
            }
            ++n2;
        }
        ArrayList<IShareable> roots = new ArrayList<IShareable>(shares.size());
        for (IShare share : shares) {
            roots.add(share.getShareable());
        }
        return SharingManager.getInstance().makeSchedulingRuleForIDE(roots);
    }

    private void validateShareableRequest(ISandbox sandbox, IConnection workspace, IComponentHandle component, List<IShareable> shareables, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)shareables.size());
        for (IShareable shareable : shareables) {
            if (!shareable.getSandbox().equals(sandbox)) {
                throw new IllegalArgumentException("Shareable " + shareable.getFullPath().toString() + " does not have the same root path as Sandbox (" + sandbox.getRoot() + ")");
            }
            IShare share = shareable.getShare((IProgressMonitor)progress.newChild(1));
            if (share == null) {
                throw new IllegalArgumentException("Shareable " + shareable + " has no share");
            }
            if (share.getSharingDescriptor().getComponent().sameItemId((IItemHandle)component)) continue;
            throw new IllegalArgumentException("Shareable " + shareable + " is not in component " + component);
        }
    }

    private List<WorkspaceCheckInRequest> groupRequestsByConnection() {
        HashMap groupedRequests = new HashMap();
        for (ComponentCheckInRequest req : this.componentRequests) {
            IWorkspaceConnection conn = req.getWorkspace();
            UUID connId = conn.getContextHandle().getItemId();
            CollectionUtil.addToMapOfLists(groupedRequests, (Object)connId, (Object)req);
        }
        ArrayList<WorkspaceCheckInRequest> bulkRequests = new ArrayList<WorkspaceCheckInRequest>(groupedRequests.size());
        for (List reqs : groupedRequests.values()) {
            bulkRequests.add(new WorkspaceCheckInRequest(reqs));
        }
        return bulkRequests;
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.NewCheckInOperation_0, (int)100);
        mon.setTaskName(Messages.NewCheckInOperation_1);
        final HashSet<ConfigurationFacade> workspaceLocks = new HashSet<ConfigurationFacade>();
        for (ComponentCheckInRequest req : this.componentRequests) {
            ConfigurationFacade desc = new ConfigurationFacade((IConnection)req.getWorkspace(), req.getComponent());
            workspaceLocks.add(desc);
        }
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            @Override
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    ICopyFileAreaManager.ICopyFileAreaLockRequestFactory factory = ICopyFileAreaManager.instance.lockRequestFactory();
                    ICopyFileAreasLock cfaLock = ICopyFileAreaManager.instance.lock(Collections.singleton(factory.getLockRequest(workspaceLocks, true)), (IProgressMonitor)mon.newChild(1));
                    try {
                        ArrayList<IAuditable> determinants = new ArrayList<IAuditable>();
                        SubMonitor subProgress = mon.newChild(98);
                        subProgress.setWorkRemaining(NewCheckInOperation.this.componentRequests.size() * 10);
                        List workspaceReqs = NewCheckInOperation.this.groupRequestsByConnection();
                        for (WorkspaceCheckInRequest workspaceReq : workspaceReqs) {
                            for (ComponentCheckInRequest compReq : workspaceReq.reqs) {
                                if (compReq.getTracker() == null) continue;
                                compReq.validate((IProgressMonitor)subProgress.newChild(1));
                            }
                            NewCheckInOperation.this.runRequest(workspaceReq, determinants, subProgress.newChild(9));
                        }
                    }
                    finally {
                        cfaLock.release((IProgressMonitor)mon.newChild(1));
                    }
                }
                catch (FileSystemException e) {
                    throw new InvocationTargetException((Throwable)((Object)e));
                }
                catch (TeamRepositoryException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        FlowNodeLock jazzWorkspaceLock = WorkspaceLockUtil.acquireWrite(workspaceLocks, (IProgressMonitor)mon.newChild(1));
        try {
            this.runWithinFileSystemLock(runnableWithProgress, Messages.NewCheckInOperation_21, (IProgressMonitor)mon.newChild(99));
        }
        finally {
            WorkspaceLockUtil.release(jazzWorkspaceLock);
        }
        this.commitProblemHandler.commitComplete();
        mon.done();
    }

    protected void runRequest(WorkspaceCheckInRequest workspaceReq, Collection<IAuditable> determinants, SubMonitor mon) throws FileSystemException, TeamRepositoryException {
        String checkInMsg = NLS.bind((String)Messages.NewCheckInOperation_2, (Object)workspaceReq.getWorkspace().getResolvedWorkspace().getName(), (Object[])new Object[0]);
        mon = SubMonitor.convert((IProgressMonitor)mon, (String)checkInMsg, (int)(100 + workspaceReq.reqs.size()));
        this.determineChangesAndVerifyInSync(workspaceReq, (IProgressMonitor)mon.newChild(1));
        int ct = 0;
        for (ComponentCheckInRequest compReq : workspaceReq.reqs) {
            SubMonitor iterMon = mon.newChild(1);
            iterMon.subTask(NLS.bind((String)Messages.NewCheckInOperation_FINDING_LOCAL_CHANGES, (Object)ct++, (Object[])new Object[]{workspaceReq.reqs.size()}));
            iterMon.setWorkRemaining(100);
            IWorkspaceConnection workspace = compReq.getWorkspace();
            IComponentHandle component = compReq.getComponent();
            ChangeSetChooser organizer = new ChangeSetChooser(workspace, determinants);
            HashMap<UUID, IChangeSetHandle> changeSetsToCommit = new HashMap<UUID, IChangeSetHandle>();
            HashMap<UUID, Set<ILocalChange>> changesToCommit = new HashMap<UUID, Set<ILocalChange>>();
            iterMon.setWorkRemaining(compReq.allChanges.size() + 8);
            for (ILocalChange change : compReq.allChanges) {
                UUID key;
                IChangeSetHandle bestChangeSet = organizer.getBestChangeSet(component, change.getTarget(), compReq.getPreferredChangeSet(), (IProgressMonitor)iterMon.newChild(1));
                if (bestChangeSet != null) {
                    key = bestChangeSet.getItemId();
                    changeSetsToCommit.put(key, bestChangeSet);
                } else {
                    key = null;
                }
                Set<ILocalChange> changes = changesToCommit.get(key);
                if (changes == null) {
                    changes = new HashSet<ILocalChange>();
                    changesToCommit.put(key, changes);
                }
                changes.add(change);
            }
            iterMon.worked(8);
            this.checkCancelled((IProgressMonitor)iterMon);
            compReq.setChangesToCommit(changesToCommit);
            compReq.setChangeSetsToCommit(changeSetsToCommit);
        }
        this.commitChanges(workspaceReq, checkInMsg, (IProgressMonitor)mon.newChild(99));
    }

    private void determineChangesAndVerifyInSync(WorkspaceCheckInRequest workspaceReq, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (int)(workspaceReq.reqs.size() * 2 + 10));
        int ct = 1;
        DilemmaHandler problemHandler = this.getDilemmaHandler();
        if (!(problemHandler instanceof CommitDilemmaHandler)) {
            problemHandler = CommitDilemmaHandler.getDefault();
        }
        IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(((CommitDilemmaHandler)problemHandler).getOutOfSyncDilemmaHandler());
        for (ComponentCheckInRequest compReq : workspaceReq.reqs) {
            SubMonitor iterMon = mon.newChild(1);
            iterMon.subTask(NLS.bind((String)Messages.NewCheckInOperation_FINDING_LOCAL_CHANGES, (Object)ct++, (Object[])new Object[]{workspaceReq.reqs.size()}));
            iterMon.setWorkRemaining(100);
            ILocalChange[] toCommit = compReq.getChanges(this.getRefreshBeforeRun(), (IProgressMonitor)iterMon.newChild(10));
            compReq.allChanges = new HashSet();
            ILocalChange[] iLocalChangeArray = toCommit;
            int n = toCommit.length;
            int n2 = 0;
            while (n2 < n) {
                ILocalChange chg = iLocalChangeArray[n2];
                compReq.allChanges.add(chg);
                ++n2;
            }
            ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(compReq.getSandbox().getRoot());
            if (cfa == null) {
                this.collectStatus(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.NewCheckInOperation_19, (Object)compReq.getSandbox().getRoot().toString(), (Object[])new Object[0]), null));
            }
            IWorkspaceConnection workspace = compReq.getWorkspace();
            HashSet<IShare> toVerify = new HashSet<IShare>();
            SharingManager sharingManager = SharingManager.getInstance();
            SubMonitor subProgress = iterMon.newChild(10);
            subProgress.setWorkRemaining(toCommit.length);
            int i = 0;
            while (i < toCommit.length) {
                IShare share = null;
                ILocalChange localChange = toCommit[i];
                share = localChange.isType(16) ? sharingManager.getShare(cfa.getRoot(), localChange.getResultingPath(), (IProgressMonitor)subProgress.newChild(1)) : (localChange.isType(4) ? sharingManager.getShare(cfa.getRoot(), localChange.getConnection(), localChange.getComponent(), localChange.getTarget(), (IProgressMonitor)subProgress.newChild(1)) : sharingManager.getShare(cfa.getRoot(), localChange.getPath(), (IProgressMonitor)subProgress.newChild(1)));
                if (share != null) {
                    toVerify.add(share);
                } else {
                    LoggingHelper.log((IStatus)new Status(2, "com.ibm.team.filesystem.client", NLS.bind((String)"Could not get share for ILocalChange {0}", (Object)String.valueOf(localChange), (Object[])new Object[0])));
                }
                ++i;
            }
            subProgress.done();
            if (!this.verifyInSyncEnabled() || ((CommitDilemmaHandler)problemHandler).getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync() || toVerify.isEmpty()) continue;
            verifyOp.addToVerify((IConnection)workspace, toVerify);
        }
        if (this.verifyInSyncEnabled() && !((CommitDilemmaHandler)problemHandler).getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
            verifyOp.run((IProgressMonitor)mon.newChild(10));
        }
        ct = 0;
        for (ComponentCheckInRequest compReq : workspaceReq.reqs) {
            mon.subTask(NLS.bind((String)Messages.NewCheckInOperation_FINDING_LOCAL_CHANGES, (Object)ct++, (Object[])new Object[]{workspaceReq.reqs.size()}));
            ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(compReq.getSandbox().getRoot());
            compReq.allChanges = this.addRequiredChanges(cfa, compReq, compReq.allChanges, compReq.getTracker(), (IProgressMonitor)mon.newChild(1));
        }
    }

    private void commitChanges(WorkspaceCheckInRequest workspaceReq, String checkInMsg, IProgressMonitor progress) throws FileSystemException, TeamRepositoryException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        CancellationMonitor cMon = new CancellationMonitor((IProgressMonitor)mon);
        IWorkspaceConnection workspace = workspaceReq.getWorkspace();
        boolean isNonAtomicCommitAllowed = this.nonAtomicCommitIsAnOption;
        CheckinUploadData uploadData = new CheckinUploadData();
        int numUploads = 0;
        int numChanges = 0;
        SubMonitor iterMon = mon.newChild(1).setWorkRemaining(workspaceReq.reqs.size());
        ArrayList<IStatus> sessionStatuses = new ArrayList<IStatus>();
        for (ComponentCheckInRequest compReq : workspaceReq.reqs) {
            boolean serverSupportsSymbolicLinks = FileSystemCore.getFileSystemManager(compReq.getWorkspace().teamRepository()).serverSupportsSymbolicLinks((IProgressMonitor)iterMon.newChild(1));
            numChanges += compReq.allChanges.size();
            ICurrentPatch currentPatch = workspace.getCurrentPatch(compReq.component);
            ArrayList<IShareable> nonPatchContent = new ArrayList<IShareable>();
            for (ILocalChange chg : compReq.allChanges) {
                IVersionableChange patchChange;
                if (compReq.isTargetPatchCheckIn() && (patchChange = currentPatch.getVersionableChange(chg.getTarget().getItemId())) == null) {
                    nonPatchContent.add(chg.getShareable());
                }
                if (chg.getTarget() instanceof IFileItemHandle && !chg.isType(16) && (chg.getType() & 3) != 0) {
                    ++numUploads;
                    continue;
                }
                if (serverSupportsSymbolicLinks || !(chg.getTarget() instanceof ISymbolicLinkHandle)) continue;
                IStatus status = FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)Messages.NewCheckInOperation_20, (Object)chg.getPath().toString(), (Object[])new Object[0]), null);
                sessionStatuses.add(status);
            }
            if (nonPatchContent.isEmpty()) continue;
            int instruction = this.commitProblemHandler.nonPatchShareables(nonPatchContent);
            switch (instruction) {
                case 1: {
                    throw new OperationCanceledException();
                }
                case 2: {
                    throw new FileSystemException(Messages.NewCheckInOperation_UNRELATED_CHANGE);
                }
            }
        }
        isNonAtomicCommitAllowed = this.nonAtomicCommitIsAnOption && numUploads >= this.uploadLimit && isNonAtomicCommitAllowed;
        if (!isNonAtomicCommitAllowed && !sessionStatuses.isEmpty()) {
            RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_22, sessionStatuses.toArray(new IStatus[sessionStatuses.size()]));
        }
        if (numUploads != 0) {
            IFileContentManagerSession session = FileSystemCore.getContentManager(workspace.teamRepository()).createSession(NLS.bind((String)Messages.NewCheckInOperation_3, (Object)workspace.getName(), (Object[])new Object[0]), true, numUploads, (IProgressMonitor)mon.newChild(40));
            for (ComponentCheckInRequest compReq : workspaceReq.reqs) {
                ICopyFileArea cfa = compReq.getCfa();
                for (Object chg : compReq.allChanges) {
                    if (!(chg.getTarget() instanceof IFileItemHandle) || chg.isType(16) || (chg.getType() & 3) == 0) continue;
                    CheckinUploadHandler uh = new CheckinUploadHandler(cfa, compReq, (ILocalChange)chg, !isNonAtomicCommitAllowed, uploadData, cMon);
                    try {
                        session.storeContent(uh);
                    }
                    catch (TeamRepositoryException teamRepositoryException) {}
                }
            }
            session.join();
            this.doRetries(session, uploadData, mon.newChild(10));
            this.doDilemmaHandling(workspace, isNonAtomicCommitAllowed, session, sessionStatuses, uploadData, mon.newChild(20));
            Collection<CheckinUploadHandler> filesNeedingConversion = uploadData.clearFilesNeedingConversion();
            SubMonitor subProgress = mon.newChild(4);
            subProgress.setWorkRemaining(filesNeedingConversion.size());
            for (CheckinUploadHandler uh : filesNeedingConversion) {
                try {
                    uh.convert(this.backupShed, (IProgressMonitor)subProgress.newChild(1));
                }
                catch (FileSystemException e) {
                    if (isNonAtomicCommitAllowed) {
                        sessionStatuses.add(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
                        continue;
                    }
                    throw e;
                }
            }
        }
        HashMap<UUID, Map<UUID, ILocalChange>> changes = new HashMap<UUID, Map<UUID, ILocalChange>>();
        ArrayList<ILocalChange> allLocalChangesCommitted = new ArrayList<ILocalChange>(numChanges);
        HashMap<UUID, IChangeSetHandle> changeSets = new HashMap<UUID, IChangeSetHandle>();
        HashMap configOps = new HashMap();
        this.checkCancelled((IProgressMonitor)mon);
        mon = SubMonitor.convert((IProgressMonitor)new NonCancellingProgressMonitor((IProgressMonitor)mon));
        SubMonitor subProgress = mon.newChild(5);
        subProgress.setWorkRemaining(numChanges * 2 + workspaceReq.reqs.size());
        SymbolicLinkDetails linkWarnings = new SymbolicLinkDetails();
        for (ComponentCheckInRequest compReq : workspaceReq.reqs) {
            boolean bl = FileSystemCore.getFileSystemManager(compReq.getWorkspace().teamRepository()).serverSupportsSymbolicLinks((IProgressMonitor)iterMon.newChild(1));
            for (Map.Entry entry : compReq.changesToCommit.entrySet()) {
                IChangeSetHandle cs;
                Collection allChanges = (Collection)entry.getValue();
                ArrayList allOps = new ArrayList(allChanges.size());
                SubMonitor iterProgress = subProgress.newChild(1).setWorkRemaining(allChanges.size());
                for (ILocalChange chg : allChanges) {
                    if (!this.addConfigOp(compReq.getCfa(), uploadData, compReq, chg, workspace.configurationOpFactory(), allOps, bl, linkWarnings, (IProgressMonitor)iterProgress.newChild(1))) continue;
                    allLocalChangesCommitted.add(chg);
                }
                if (allOps.isEmpty()) continue;
                for (ILocalChange changeToCommit : allChanges) {
                    if (changeToCommit.isCanceled() || (changeToCommit.getType() & 0x10) != 0) continue;
                    LinkedHashMap<UUID, ILocalChange> localChanges = (LinkedHashMap<UUID, ILocalChange>)changes.get(compReq.getComponent().getItemId());
                    if (localChanges == null) {
                        localChanges = new LinkedHashMap<UUID, ILocalChange>(numChanges * 4 / 3);
                        changes.put(compReq.getComponent().getItemId(), localChanges);
                    }
                    localChanges.put(changeToCommit.getTarget().getItemId(), changeToCommit);
                }
                if (entry.getKey() == null) {
                    IComponentHandle component = compReq.getComponent();
                    cs = workspace.getCurrentChangeSet(component);
                    if (cs == null) {
                        String comment = compReq.getCommentForNewChangeSet();
                        if (comment == null) {
                            comment = "";
                        }
                        cs = workspace.createChangeSet(component, comment, true, (IProgressMonitor)subProgress.newChild(1));
                    }
                } else {
                    cs = (IChangeSetHandle)compReq.changeSetsToCommit.get(entry.getKey());
                }
                changeSets.put(cs.getItemId(), cs);
                Collection existingOps = (Collection)configOps.get(cs.getItemId());
                if (existingOps == null) {
                    configOps.put(cs.getItemId(), allOps);
                    continue;
                }
                existingOps.addAll(allOps);
            }
        }
        subProgress.done();
        mon.setTaskName(checkInMsg);
        mon.setWorkRemaining(70);
        if (!changeSets.isEmpty()) {
            ArrayList<IChangeSetHandle> changeSetsToCommit = new ArrayList<IChangeSetHandle>(changeSets.size());
            ArrayList<Collection> configOpsToCommit = new ArrayList<Collection>();
            for (Map.Entry entry : changeSets.entrySet()) {
                changeSetsToCommit.add((IChangeSetHandle)entry.getValue());
                configOpsToCommit.add((Collection)configOps.get(entry.getKey()));
            }
            try {
                IUpdateReport iUpdateReport = workspace.commit(changeSetsToCommit, configOpsToCommit, (IProgressMonitor)mon.newChild(50));
                this.changeSetsCommitted.putAll(changeSets);
                HashSet<IShare> hashSet = new HashSet<IShare>();
                this.updateMetadata(workspaceReq, uploadData, iUpdateReport, changes, hashSet, (IProgressMonitor)mon.newChild(5));
                this.savedVersionable = new HashMap<UUID, Map<UUID, IVersionable>>();
                uploadData.clearUploadInfo();
                LocalChangeManager lcm = (LocalChangeManager)FileSystemCore.getSharingManager().getLocalChangeManager();
                lcm.commitChanges(allLocalChangesCommitted.toArray(new ILocalChange[allLocalChangesCommitted.size()]));
                if (!iUpdateReport.incidentalResolutionUpdates().isEmpty()) {
                    UpdateOperation op = new UpdateOperation(workspace, Collections.singletonList(iUpdateReport), 2, this.commitProblemHandler, null);
                    this.disableVerifyInSync(op);
                    op.run((IProgressMonitor)mon.newChild(5));
                }
                this.updateCFAConfigState(workspaceReq, allLocalChangesCommitted, iUpdateReport, hashSet, (IProgressMonitor)mon.newChild(10));
            }
            catch (FolderEntryConflictException folderEntryConflictException) {
                IStatus iStatus = FileSystemStatusUtil.getStatusFor(folderEntryConflictException);
                this.collectStatus(iStatus);
            }
        }
        if (!linkWarnings.isEmpty()) {
            this.commitProblemHandler.linkWarnings(linkWarnings.isAnyBroken(), linkWarnings.isAnyNonInteroperable(), linkWarnings.getShareables(), linkWarnings.getTargets(), linkWarnings.getDirectoryLinks(), linkWarnings.getBroken(), linkWarnings.getNonInteroperable());
        }
        IStatus[] failures = uploadData.getUploadFailureStatuses();
        IStatus[] moreErrors = this.getErrors();
        IStatus[] iStatusArray = sessionStatuses.toArray(new IStatus[sessionStatuses.size() + failures.length + moreErrors.length]);
        System.arraycopy(failures, 0, iStatusArray, sessionStatuses.size(), failures.length);
        System.arraycopy(moreErrors, 0, iStatusArray, sessionStatuses.size() + failures.length, moreErrors.length);
        RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_6, iStatusArray);
        mon.done();
    }

    private void doRetries(IFileContentManagerSession session, CheckinUploadData uploadData, SubMonitor mon) throws TeamRepositoryException {
        Collection<CheckinUploadData.RetryRequest> retryRequests = uploadData.getAndResetRetryRequests();
        mon.beginTask(Messages.NewCheckInOperation_OUT_OF_SYNC_STATUS_MESSAGE, retryRequests.size());
        for (CheckinUploadData.RetryRequest req : retryRequests) {
            try {
                IRetryRequest.RetryDirection direction = req.getBeforeRetry().run(this.commitProblemHandler, (IProgressMonitor)mon.newChild(1));
                if (IRetryRequest.RetryDirection.RETRY == direction) {
                    session.storeContent(req.getUpload());
                    continue;
                }
                uploadData.skipped(new UploadFailure(req.getUpload().getShareable(), req.getUpload(), null));
            }
            catch (InvocationTargetException e) {
                uploadData.uploadFailure(new UploadFailure(req.getUpload().getShareable(), req.getUpload(), e.getTargetException()));
            }
            catch (TeamRepositoryException e) {
                uploadData.uploadFailure(new UploadFailure(req.getUpload().getShareable(), req.getUpload(), e));
            }
        }
        session.join();
    }

    private void doDilemmaHandling(IWorkspaceConnection workspace, boolean isNonAtomicCommitAllowed, IFileContentManagerSession session, List<IStatus> sessionStatuses, CheckinUploadData uploadData, SubMonitor mon) throws FileSystemException, TeamRepositoryException {
        boolean moreContentUploaded;
        int paranoiaCount = 0;
        do {
            moreContentUploaded = false;
            IStatus[] uploadFailureStatuses = uploadData.getUploadFailureStatuses();
            IStatus[] statuses = session.getErrorStatus();
            IStatus[] allErrors = new IStatus[sessionStatuses.size() + uploadFailureStatuses.length + statuses.length];
            allErrors = sessionStatuses.toArray(allErrors);
            System.arraycopy(uploadFailureStatuses, 0, allErrors, sessionStatuses.size(), uploadFailureStatuses.length);
            System.arraycopy(statuses, 0, allErrors, sessionStatuses.size() + uploadFailureStatuses.length, statuses.length);
            if (isNonAtomicCommitAllowed) {
                this.checkCancellationStatus(allErrors);
            } else if (allErrors.length > 0) {
                RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_4, allErrors);
            }
            session = null;
            Collection<LineDelimiterUploadFailure> lineDelimiterFailures = uploadData.clearLineDelimiterFailures();
            Collection<EncodingUploadFailure> encodingFailures = uploadData.clearEncodingFailures();
            Collection<DeletedPredecessorUploadFailure> deletedPredecessorFailures = uploadData.clearDeletedPrecessorFailures();
            if (!(lineDelimiterFailures.isEmpty() && encodingFailures.isEmpty() && deletedPredecessorFailures.isEmpty())) {
                mon.setWorkRemaining(100);
                session = FileSystemCore.getContentManager(workspace.teamRepository()).createSession(NLS.bind((String)Messages.NewCheckInOperation_3, (Object)workspace.getName(), (Object[])new Object[0]), true, lineDelimiterFailures.size() + encodingFailures.size() + deletedPredecessorFailures.size(), (IProgressMonitor)mon.newChild(40));
                try {
                    if (!deletedPredecessorFailures.isEmpty()) {
                        ArrayList<IShareable> arrayList = new ArrayList<IShareable>(deletedPredecessorFailures.size());
                        for (DeletedPredecessorUploadFailure failure : deletedPredecessorFailures) {
                            arrayList.add(failure.getShareable());
                        }
                        int reaction = this.commitProblemHandler.predecessorContentDeletedErrors(arrayList);
                        if (reaction == 1) {
                            throw new OperationCanceledException();
                        }
                        if (reaction == 3) {
                            for (UploadFailure uploadFailure : deletedPredecessorFailures) {
                                uploadData.skipped(uploadFailure);
                            }
                            session.decrementTransferCount(deletedPredecessorFailures.size());
                        } else if (reaction == 0) {
                            for (DeletedPredecessorUploadFailure deletedPredecessorUploadFailure : deletedPredecessorFailures) {
                                try {
                                    deletedPredecessorUploadFailure.allowUploadWithDeletedPredecessorContent();
                                    session.storeContent(deletedPredecessorUploadFailure.getUploadHandler());
                                    moreContentUploaded = true;
                                }
                                catch (TeamRepositoryException teamRepositoryException) {}
                            }
                        } else {
                            for (UploadFailure uploadFailure : deletedPredecessorFailures) {
                                uploadData.uploadFailure(uploadFailure);
                            }
                            for (LineDelimiterUploadFailure lineDelimiterUploadFailure : lineDelimiterFailures) {
                                uploadData.uploadFailure(lineDelimiterUploadFailure);
                            }
                            for (EncodingUploadFailure encodingUploadFailure : encodingFailures) {
                                uploadData.uploadFailure(encodingUploadFailure);
                            }
                            uploadFailureStatuses = uploadData.getUploadFailureStatuses();
                            RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_4, uploadFailureStatuses);
                        }
                    }
                    if (!lineDelimiterFailures.isEmpty()) {
                        int n = this.commitProblemHandler.lineDelimiterErrors(lineDelimiterFailures, (IProgressMonitor)mon.newChild(1));
                        if (n == 1) {
                            throw new OperationCanceledException();
                        }
                        if (n == 3 && isNonAtomicCommitAllowed) {
                            for (LineDelimiterUploadFailure failure : lineDelimiterFailures) {
                                uploadData.uploadFailure(failure);
                            }
                            session.decrementTransferCount(lineDelimiterFailures.size());
                        } else if (n == 0) {
                            mon.setWorkRemaining(100);
                            for (LineDelimiterUploadFailure failure : lineDelimiterFailures) {
                                if (failure.isSkipFailure()) {
                                    uploadData.uploadFailure(failure);
                                    session.decrementTransferCount(1L);
                                    continue;
                                }
                                try {
                                    session.storeContent(failure.getUploadHandler());
                                    moreContentUploaded = true;
                                }
                                catch (TeamRepositoryException teamRepositoryException) {}
                            }
                        } else if (n == 100) {
                            session.decrementTransferCount(lineDelimiterFailures.size());
                        } else {
                            for (LineDelimiterUploadFailure failure : lineDelimiterFailures) {
                                uploadData.uploadFailure(failure);
                            }
                            for (EncodingUploadFailure failure : encodingFailures) {
                                uploadData.uploadFailure(failure);
                            }
                            uploadFailureStatuses = uploadData.getUploadFailureStatuses();
                            RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_4, uploadFailureStatuses);
                        }
                    }
                    if (!encodingFailures.isEmpty()) {
                        int n = this.commitProblemHandler.encodingErrors(encodingFailures, (IProgressMonitor)mon.newChild(1));
                        if (n == 1) {
                            throw new OperationCanceledException();
                        }
                        if (n == 3 && isNonAtomicCommitAllowed) {
                            for (EncodingUploadFailure failure : encodingFailures) {
                                uploadData.uploadFailure(failure);
                            }
                            session.decrementTransferCount(encodingFailures.size());
                        } else if (n == 0) {
                            mon.setWorkRemaining(100);
                            if (!isNonAtomicCommitAllowed) {
                                for (EncodingUploadFailure failure : encodingFailures) {
                                    if (failure.isIgnoreEncoding() || !failure.getEncoding().equals(failure.getAlternativeEncoding())) continue;
                                    uploadData.uploadFailure(failure);
                                }
                                uploadFailureStatuses = uploadData.getUploadFailureStatuses();
                                RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_4, uploadFailureStatuses);
                            }
                            for (EncodingUploadFailure failure : encodingFailures) {
                                if (failure.isSkipFailure()) {
                                    uploadData.uploadFailure(failure);
                                    session.decrementTransferCount(1L);
                                    continue;
                                }
                                try {
                                    session.storeContent(failure.getUploadHandler());
                                    moreContentUploaded = true;
                                }
                                catch (TeamRepositoryException teamRepositoryException) {}
                            }
                        } else {
                            for (EncodingUploadFailure failure : encodingFailures) {
                                uploadData.uploadFailure(failure);
                            }
                            uploadFailureStatuses = uploadData.getUploadFailureStatuses();
                            RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_4, uploadFailureStatuses);
                        }
                    }
                }
                finally {
                    if (session != null && moreContentUploaded) {
                        session.join();
                        this.doRetries(session, uploadData, mon);
                    }
                }
            }
            if (++paranoiaCount < 500) continue;
            for (UploadFailure uploadFailure : deletedPredecessorFailures) {
                uploadData.uploadFailure(uploadFailure);
            }
            for (LineDelimiterUploadFailure lineDelimiterUploadFailure : lineDelimiterFailures) {
                uploadData.uploadFailure(lineDelimiterUploadFailure);
            }
            for (EncodingUploadFailure encodingUploadFailure : encodingFailures) {
                uploadData.uploadFailure(encodingUploadFailure);
            }
            uploadFailureStatuses = uploadData.getUploadFailureStatuses();
            RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_4, uploadFailureStatuses);
        } while (moreContentUploaded && paranoiaCount < 500);
    }

    private void checkCancellationStatus(IStatus[] errorStatus) {
        IStatus[] iStatusArray = errorStatus;
        int n = errorStatus.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status = iStatusArray[n2];
            if (status.matches(8)) {
                throw new OperationCanceledException();
            }
            ++n2;
        }
    }

    private boolean addConfigOp(ICopyFileArea cfa, CheckinUploadData uploadData, ComponentCheckInRequest req, ILocalChange chg, IWorkspaceConnection.IConfigurationOpFactory configOpFactory, Collection<? super IWorkspaceConnection.IConfigurationOp> allOps, boolean serverSupportsSymbolicLinks, SymbolicLinkDetails linkWarnings, IProgressMonitor mon) throws FileSystemException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)10);
        IComponentHandle component = req.getComponent();
        IWorkspaceConnection workspace = req.getWorkspace();
        boolean toBeCommitted = true;
        if (chg.isType(4)) {
            if (chg.getTarget() instanceof IFolderHandle) {
                allOps.add((IWorkspaceConnection.IConfigurationOp)configOpFactory.deleteSubtree((IFolderHandle)chg.getTarget()));
            } else {
                allOps.add((IWorkspaceConnection.IConfigurationOp)configOpFactory.delete(chg.getTarget()));
            }
        } else if (uploadData.isUploadFailed(chg.getComponent(), chg.getTarget()) || uploadData.wasSkipped(component, chg.getTarget())) {
            toBeCommitted = false;
        } else if (!chg.isType(16)) {
            String name;
            UUID componentItemId = chg.getComponent().getItemId();
            Map<UUID, IVersionable> versionables = this.savedVersionable.get(componentItemId);
            if (versionables == null) {
                versionables = new HashMap<UUID, IVersionable>();
                this.savedVersionable.put(componentItemId, versionables);
            }
            InverseFileItemInfo info = cfa.getItemInfo(chg.getTarget(), component, (IContextHandle)workspace.getResolvedWorkspace(), true);
            Map<String, String> currentProperties = new MetadataProperties(info.getOriginalProperties(), info.getChangedProperties(), info.getRemovedProperties()).getCurrentProperties();
            if (chg.getShareable() != null && chg.getShareable().isShare((IProgressMonitor)progress.newChild(1)) && info.isLoadedWithAnotherName()) {
                name = info.getName();
                if (name == null) {
                    name = "";
                }
            } else {
                name = info.getLocalName();
            }
            if (chg.getTarget() instanceof IFolderHandle) {
                Folder folder = ScmFactory.eINSTANCE.createFolder();
                folder.initNew();
                folder.setItemId(chg.getTarget().getItemId());
                folder.setParent(info.getLocalParent());
                folder.setName(name);
                folder.getProperties().putAll(currentProperties);
                allOps.add((IWorkspaceConnection.IConfigurationOp)configOpFactory.save((IVersionable)folder));
                versionables.put(folder.getItemId(), (IVersionable)folder);
            } else if (chg.getTarget() instanceof IFileItemHandle) {
                FileItem file = FilesystemFactory.eINSTANCE.createFileItem();
                file.initNew();
                file.setItemId(chg.getTarget().getItemId());
                file.setParent(info.getLocalParent());
                file.setName(name);
                IShareable shareable = uploadData.getShareable(component, chg.getTarget());
                if (shareable == null) {
                    shareable = chg.getShareable();
                }
                IFileStorage storage = ((Shareable)shareable).getFileStorage();
                boolean isExecutable = storage.isExecutable((IProgressMonitor)progress.newChild(1));
                file.setExecutable(isExecutable);
                long localTimeStamp = storage.getLocalTimeStamp();
                if (localTimeStamp < 0L) {
                    localTimeStamp = System.currentTimeMillis();
                }
                file.setFileTimestamp(new Date(localTimeStamp));
                file.getProperties().putAll(currentProperties);
                FileContent content = uploadData.getContent(component, chg.getTarget());
                if (content != null) {
                    file.setContent((IFileContent)content);
                    String currentContentType = uploadData.getContentType(component, chg.getTarget());
                    file.setContentType(currentContentType);
                } else if (info.getHash() != null) {
                    content = FilesystemFactory.eINSTANCE.createFileContent();
                    ContentHash predecessorHintHash = info.getStoredPredecessorHintHash();
                    content.setPredecessorHint(predecessorHintHash);
                    content.setLineDelimiter(info.getOriginalLineDelimiter());
                    content.setSize(info.getStoredSize());
                    content.setCharacterEncoding(info.getStoredEncoding());
                    content.setHash(info.getStoredHash());
                    content.setLineDelimiterCount(info.getStoredNumLineDelimiters());
                    content.setOriginalContainingState(info.getVersionableHandle());
                    file.setContent((IFileContent)content);
                    file.setContentType(info.getContentType());
                } else {
                    throw new IllegalStateException();
                }
                allOps.add((IWorkspaceConnection.IConfigurationOp)configOpFactory.save((IVersionable)file));
                versionables.put(file.getItemId(), (IVersionable)file);
            } else if (chg.getTarget() instanceof ISymbolicLinkHandle) {
                if (serverSupportsSymbolicLinks) {
                    SymbolicLink symbolicLink = FilesystemFactory.eINSTANCE.createSymbolicLink();
                    symbolicLink.initNew();
                    symbolicLink.setItemId(chg.getTarget().getItemId());
                    symbolicLink.setParent(info.getLocalParent());
                    symbolicLink.setName(name);
                    IShareable shareable = chg.getShareable();
                    IFileStorage storage = ((Shareable)shareable).getFileStorage();
                    symbolicLink.setLinkTimestamp(new Date(storage.getLocalTimeStamp()));
                    symbolicLink.getProperties().putAll(currentProperties);
                    LinkInfo targetInfo = storage.getLinkInfo((IProgressMonitor)progress.newChild(1));
                    boolean isDirectoryLink = ((Shareable)chg.getShareable()).getFileItemInfo((IProgressMonitor)progress.newChild(1)).isDirectoryLink();
                    linkWarnings.push(shareable, targetInfo.getTarget(), isDirectoryLink, storage.isBrokenLink((IProgressMonitor)progress.newChild(1)), !storage.isInteroperableLink(targetInfo, isDirectoryLink, (IProgressMonitor)progress.newChild(1)));
                    symbolicLink.setTarget(targetInfo.getTarget());
                    symbolicLink.setIsDirectoryLink(isDirectoryLink);
                    allOps.add((IWorkspaceConnection.IConfigurationOp)configOpFactory.save((IVersionable)symbolicLink));
                    versionables.put(symbolicLink.getItemId(), (IVersionable)symbolicLink);
                } else {
                    toBeCommitted = false;
                }
            }
        }
        return toBeCommitted;
    }

    private Set<ILocalChange> addRequiredChanges(ICopyFileArea cfa, ComponentCheckInRequest req, Set<ILocalChange> changesToBeCommitted, LocalChangeTracker lct, IProgressMonitor monitor) throws FileSystemException {
        ArrayList<ILocalChange> toCommit = new ArrayList<ILocalChange>(changesToBeCommitted);
        HashSet<ILocalChange> changes = new HashSet<ILocalChange>(changesToBeCommitted.size() * 4 / 3);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)toCommit.size());
        while (!toCommit.isEmpty()) {
            ILocalChange change = (ILocalChange)toCommit.remove(toCommit.size() - 1);
            if (change.isCanceled()) {
                progress.worked(1);
                continue;
            }
            changes.add(change);
            if (change.getCounterpart() != null) {
                changes.add(change.getCounterpart());
                if (change.isType(16)) {
                    change = change.getCounterpart();
                }
                this.addDependentChangesForNewParent(cfa, req, change, toCommit, changes, lct);
            } else if (change.isType(2)) {
                this.addDependentChangesForNewParent(cfa, req, change, toCommit, changes, lct);
            } else if (change.isType(4)) {
                this.addDependentChangesForDeletion(cfa, req, change, toCommit, changes, lct);
            }
            progress.setWorkRemaining(toCommit.size() + 1);
            progress.worked(1);
        }
        progress.done();
        return changes;
    }

    private void addDependentChangesForDeletion(ICopyFileArea cfa, ComponentCheckInRequest req, ILocalChange change, List<ILocalChange> toCommit, Set<ILocalChange> changes, LocalChangeTracker lct) throws FileSystemException {
        if (!(change.getTarget() instanceof IFolderHandle)) {
            return;
        }
        IComponentHandle component = req.getComponent();
        IWorkspaceConnection workspace = req.getWorkspace();
        InverseFileItemInfo info = cfa.getItemInfo(change.getTarget(), component, workspace.getContextHandle(), true);
        ArrayList<IVersionableHandle> toVisit = new ArrayList<IVersionableHandle>(info.getRemoteChildren().values());
        while (!toVisit.isEmpty()) {
            IVersionableHandle item = (IVersionableHandle)toVisit.remove(toVisit.size() - 1);
            ILocalChange chg = lct.getPendingChange(item);
            if (chg.getType() != 0) {
                Assert.isTrue((boolean)chg.isType(8));
                if (!changes.add(chg)) continue;
                toCommit.add(chg);
                continue;
            }
            if (!(item instanceof IFolderHandle)) continue;
            info = cfa.getItemInfo(item, component, workspace.getContextHandle(), true);
            toVisit.addAll(info.getRemoteChildren().values());
        }
    }

    private void addDependentChangesForNewParent(ICopyFileArea cfa, ComponentCheckInRequest req, ILocalChange change, List<ILocalChange> toCommit, Set<ILocalChange> changes, LocalChangeTracker lct) throws FileSystemException {
        IFolderHandle parent;
        ILocalChange dep = this.getDependentChangeForNewParent(cfa, req, change, lct);
        if (dep != null && changes.add(dep)) {
            toCommit.add(dep);
        }
        if ((dep = lct.getPendingChange((IVersionableHandle)(parent = change.getTargetParent()))).isType(2) && changes.add(dep)) {
            toCommit.add(dep);
        }
    }

    private ILocalChange getDependentChangeForNewParent(ICopyFileArea cfa, ComponentCheckInRequest req, ILocalChange change, LocalChangeTracker lct) throws FileSystemException {
        IVersionableHandle conflicting;
        IFolderHandle parent = change.getTargetParent();
        if (lct.getPendingChange((IVersionableHandle)parent).isType(2)) {
            return null;
        }
        IComponentHandle component = req.getComponent();
        IWorkspaceConnection workspace = req.getWorkspace();
        String name = change.getResultingPath().getName();
        InverseFileItemInfo info = cfa.getItemInfo((IVersionableHandle)parent, component, workspace.getContextHandle(), false);
        if (info == null) {
            return null;
        }
        if (cfa.isCaseSensitive()) {
            conflicting = info.getRemoteChildren().get(name);
        } else {
            conflicting = null;
            name = LocaleUtil.localeSafeNormalization((String)name);
            for (Map.Entry<String, IVersionableHandle> e : info.getRemoteChildren().entrySet()) {
                String rName = LocaleUtil.localeSafeNormalization((String)e.getKey());
                if (!name.equals(rName)) continue;
                conflicting = e.getValue();
                break;
            }
        }
        if (conflicting == null || conflicting.sameItemId((IItemHandle)parent)) {
            return null;
        }
        ILocalChange dep = lct.getPendingChange(conflicting);
        Assert.isTrue(((dep.getType() & 0xC) != 0 ? 1 : 0) != 0);
        return dep;
    }

    private void updateMetadata(WorkspaceCheckInRequest workspaceReq, CheckinUploadData uploadData, IUpdateReport updateReport, Map<UUID, Map<UUID, ILocalChange>> changes, Set<IShare> inconsistentShares, IProgressMonitor monitor) throws FileSystemException {
        Collection<ICopyFileArea> cfas;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceConnection workspace = workspaceReq.getWorkspace();
        progress.setWorkRemaining(updateReport.updates().size() * 2);
        int completed = 0;
        int size = updateReport.updates().size();
        for (IItemUpdateReport report : updateReport.updates()) {
            IComponentHandle component = report.getComponent();
            if (uploadData.wasSkipped(component, report.item())) continue;
            SubMonitor loopMon = progress.newChild(1);
            cfas = this.getCfasContaining(workspaceReq, component, progress.newChild(1));
            if (cfas.isEmpty()) continue;
            boolean multiCFA = cfas.size() > 1;
            loopMon.subTask(NLS.bind((String)Messages.NewCheckInOperation_8, (Object)(++completed), (Object[])new Object[]{size * (multiCFA ? 2 : 1)}));
            ICopyFileArea cfa = null;
            if (!multiCFA) {
                cfa = cfas.iterator().next();
            }
            try {
                FileItemInfoProxy info;
                InverseFileItemInfo oldInfo;
                if (report.getNewCurrentState() == null) continue;
                ILocalChange change = changes.get(component.getItemId()).remove(report.item().getItemId());
                if (multiCFA) {
                    cfa = this.findCFA(cfas, workspace, report.getComponent(), report.item(), change, inconsistentShares, (IProgressMonitor)loopMon.newChild(1));
                }
                IVersionable versionable = this.savedVersionable.get(report.getComponent().getItemId()).get(report.item().getItemId());
                MetadataProperties properties = new MetadataProperties(versionable.getUserProperties());
                if (report.item() instanceof IFolderHandle) {
                    if (change == null || (change.getType() & 0xA) == 0) {
                        oldInfo = cfa.getItemInfo(report.item(), report.getComponent(), (IContextHandle)workspace.getResolvedWorkspace(), true);
                        if (change != null && !oldInfo.isLoadedWithAnotherName() && oldInfo.getName() != null && !oldInfo.getName().equals(change.getPath().getName())) {
                            throw new IllegalStateException("Name should have been " + oldInfo.getName() + " but the path is " + change.getPath());
                        }
                        info = new FileItemInfoProxy(oldInfo);
                        info.setItemState(report.getNewCurrentState());
                    } else {
                        info = new FileItemInfoProxy(report.getNewCurrentState(), change.getTargetParent(), change.getResultingPath().getName(), false);
                    }
                } else if (report.item() instanceof IFileItemHandle) {
                    Long contentSize;
                    oldInfo = cfa.getItemInfo(report.item(), report.getComponent(), (IContextHandle)workspace.getResolvedWorkspace(), false);
                    if (oldInfo != null) {
                        info = new FileItemInfoProxy(oldInfo);
                        info.setItemState(report.getNewCurrentState());
                        if ((change.getType() & 0xA) == 0) {
                            if (!oldInfo.getName().equals(change.getPath().getName()) && !oldInfo.isLoadedWithAnotherName()) {
                                throw new IllegalStateException("Name should have been " + oldInfo.getName() + " but the path is " + change.getPath());
                            }
                        } else {
                            info.changeIdentity(change.getTargetParent(), change.getResultingPath().getName());
                        }
                    } else {
                        info = new FileItemInfoProxy(report.getNewCurrentState(), change.getTargetParent(), change.getResultingPath().getName());
                    }
                    if ((contentSize = uploadData.getLocalContentSize(component, (IVersionableHandle)versionable)) != null) {
                        ContentHash hash = uploadData.getLocalHashCode(component, (IVersionableHandle)versionable);
                        long contentLength = contentSize;
                        Long modTime = uploadData.getModTime(component, (IVersionableHandle)versionable);
                        FileContent contentUploaded = uploadData.getContent(component, (IVersionableHandle)versionable);
                        info.setContentInfo(modTime, hash, contentLength, contentUploaded);
                    }
                } else {
                    oldInfo = cfa.getItemInfo(report.item(), report.getComponent(), (IContextHandle)workspace.getResolvedWorkspace(), false);
                    ISymbolicLink link = (ISymbolicLink)versionable;
                    if (oldInfo != null) {
                        info = new FileItemInfoProxy(oldInfo);
                        info.setItemState(report.getNewCurrentState());
                        if ((change.getType() & 0xA) == 0) {
                            if (!oldInfo.getName().equals(change.getPath().getName()) && !oldInfo.isLoadedWithAnotherName()) {
                                throw new IllegalStateException("Name should have been " + oldInfo.getName() + " but the path is " + change.getPath());
                            }
                        } else {
                            info.changeIdentity(change.getTargetParent(), change.getResultingPath().getName());
                        }
                    } else {
                        info = new FileItemInfoProxy(report.getNewCurrentState(), change.getTargetParent(), change.getResultingPath().getName());
                    }
                    String target = link.getTarget();
                    target = ((Shareable)change.getShareable()).getFileStorage().convertTargetIntoLocalForm(target);
                    info.setTarget(((Shareable)change.getShareable()).getFileStorage().getModificationStamp(), link.getTarget(), target, link.isDirectoryLink());
                }
                info.setProperties(versionable);
                assert (change.getResultingPath() != null);
                cfa.setItemMetaData(change.getResultingPath(), info.getFileItemInfo(), ICopyFileArea.PropertyUpdate.REPLACE, properties, (IProgressMonitor)loopMon.newChild(1));
            }
            catch (FileSystemException e) {
                this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
            }
        }
        for (Map<UUID, ILocalChange> localChanges : changes.values()) {
            for (ILocalChange change : localChanges.values()) {
                if (uploadData.wasSkipped(change.getComponent(), change.getTarget())) continue;
                if (!change.isType(4)) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor(4, String.valueOf(Messages.NewCheckInOperation_EXPECTED_FILE_OR_FOLDER_DELETION) + change));
                    continue;
                }
                cfas = this.getCfasContaining(workspaceReq, change.getComponent(), progress.newChild(1));
                ICopyFileArea cfa = this.findCFA(cfas, workspace, change.getComponent(), change.getTarget(), change, inconsistentShares, (IProgressMonitor)progress.newChild(1));
                if (cfas.isEmpty()) continue;
                try {
                    cfa.forget(workspace.getContextHandle(), change.getComponent(), change.getTarget(), (IProgressMonitor)progress.newChild(1));
                }
                catch (FileSystemException e) {
                    this.collectStatus(FileSystemStatusUtil.getStatusFor((Throwable)((Object)e)));
                }
            }
        }
        progress.done();
    }

    private ICopyFileArea findCFA(Collection<ICopyFileArea> cfas, IWorkspaceConnection workspace, IComponentHandle component, IVersionableHandle updatedItem, ILocalChange change, Set<IShare> inconsistentShares, IProgressMonitor monitor) throws FileSystemException {
        ICopyFileArea cfa = null;
        SubMonitor childMon = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        if (change != null) {
            ILocation cfaRoot = change.getSandboxRoot();
            for (ICopyFileArea candidate : cfas) {
                if (cfaRoot.sameLocation(candidate.getRoot(), candidate.isCaseSensitive())) {
                    cfa = candidate;
                    continue;
                }
                this.checkForShare(inconsistentShares, candidate, workspace.getContextHandle(), component, change, (IProgressMonitor)childMon);
            }
        }
        if (cfa == null) {
            for (ICopyFileArea candidate : cfas) {
                InverseFileItemInfo infoForItem = candidate.getItemInfo(updatedItem, component, (IContextHandle)workspace.getResolvedWorkspace(), false);
                if (infoForItem == null) continue;
                if (cfa == null) {
                    cfa = candidate;
                    continue;
                }
                IShare share = candidate.getShare(workspace.getContextHandle(), component, updatedItem, (IProgressMonitor)childMon.newChild(1));
                if (share == null) continue;
                inconsistentShares.add(share);
            }
        }
        if (cfa == null) {
            cfa = cfas.iterator().next();
        }
        return cfa;
    }

    private void checkForShare(Set<IShare> inconsistentShares, ICopyFileArea cfa, IContextHandle workspace, IComponentHandle component, ILocalChange change, IProgressMonitor progress) throws FileSystemException {
        IShare share;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)3);
        if (change.getTargetParent() != null && (share = cfa.getShare(workspace, component, (IVersionableHandle)change.getTargetParent(), (IProgressMonitor)monitor.newChild(1))) != null) {
            inconsistentShares.add(share);
            return;
        }
        if (change.getCounterpart() != null && change.getCounterpart().getTargetParent() != null && (share = cfa.getShare(workspace, component, (IVersionableHandle)change.getCounterpart().getTargetParent(), (IProgressMonitor)monitor.newChild(1))) != null) {
            inconsistentShares.add(share);
            return;
        }
        share = cfa.getShare(workspace, component, change.getTarget(), (IProgressMonitor)monitor.newChild(1));
        if (share != null) {
            inconsistentShares.add(share);
            return;
        }
    }

    private void updateCFAConfigState(WorkspaceCheckInRequest workspaceReq, Collection<ILocalChange> allLocalChangesCommitted, IUpdateReport updateReport, Set<IShare> inconsistentShares, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(updateReport.getComponentStatesAfter().size() * 2 + inconsistentShares.size()));
        HashMap<UUID, ISyncTime> beforeStates = new HashMap<UUID, ISyncTime>();
        for (IComponentStateSummary summary : updateReport.getComponentStatesBefore()) {
            beforeStates.put(summary.getComponent().getItemId(), summary.getConfigurationTime());
        }
        progress.beginTask(Messages.NewCheckInOperation_UPDATING_SYNC_TIME, updateReport.getComponentStatesAfter().size() * 2 + inconsistentShares.size());
        IWorkspaceConnection workspace = workspaceReq.getWorkspace();
        for (IComponentStateSummary summary : updateReport.getComponentStatesAfter()) {
            IComponentHandle component = summary.getComponent();
            SubMonitor loopMon = progress.newChild(1);
            Collection<ICopyFileArea> cfas = this.getCfasContaining(workspaceReq, component, loopMon.newChild(1));
            loopMon.setWorkRemaining(cfas.size() + 10);
            for (ICopyFileArea cfa : cfas) {
                ISyncTime beforeState = (ISyncTime)beforeStates.get(component.getItemId());
                cfa.setConfigurationState((IContextHandle)workspace.getResolvedWorkspace(), component, beforeState, summary.getConfigurationTime(), (IProgressMonitor)loopMon.newChild(10));
            }
        }
        for (IShare inconsistentShare : inconsistentShares) {
            ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(inconsistentShare.getSandbox().getRoot());
            cfa.setUnknownConfigurationState(workspaceReq.workspace.getContextHandle(), inconsistentShare.getSharingDescriptor().getComponent(), inconsistentShare.getPath(), (IProgressMonitor)progress.newChild(1));
        }
    }

    private Collection<ICopyFileArea> getCfasContaining(WorkspaceCheckInRequest workspaceReq, IComponentHandle component, SubMonitor monitor) throws FileSystemException {
        HashSet<ICopyFileArea> cfas = new HashSet();
        monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)workspaceReq.allCfas().size());
        IWorkspaceConnection workspace = workspaceReq.getWorkspace();
        cfas = ICopyFileAreaManager.instance.getCopyFileAreasForConfiguration((IConfigurationDescriptor)new ConfigurationDescriptor(workspace.teamRepository().getId(), workspace.teamRepository().getRepositoryURI(), workspace.getContextHandle(), component), (IProgressMonitor)monitor);
        return cfas;
    }

    @Override
    protected String getTraceMessage() {
        return "No trace message";
    }

    @Override
    public boolean getRefreshBeforeRun() {
        return this.refreshBeforeRun;
    }

    @Override
    public void setRefreshBeforeRun(boolean newValue) {
        this.refreshBeforeRun = newValue;
    }

    private ILocalChange[] refreshLocalFilesystem(ILocalChange[] toRefresh, IContextHandle contextHandle, IComponentHandle componentHandle, ISandbox sandbox, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(5 + toRefresh.length));
        LocalChangeManager lcm = LocalChangeManager.getInstance();
        ArrayList<IShareable> shareables = new ArrayList<IShareable>(toRefresh.length);
        ILocalChange[] iLocalChangeArray = toRefresh;
        int n = toRefresh.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange change = iLocalChangeArray[n2];
            IShareable shareable = change.getShareable();
            if (shareable != null) {
                ((Shareable)shareable).getFileStorage().refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)monitor.newChild(1));
                shareables.add(shareable);
            }
            ++n2;
        }
        lcm.refreshChanges(shareables, (IProgressMonitor)monitor.newChild(2));
        lcm.syncPendingChanges(contextHandle, componentHandle, sandbox, (IProgressMonitor)monitor.newChild(3));
        ILocalChange[] fromLCM = lcm.getPendingChanges(contextHandle, componentHandle, sandbox);
        HashMap<UUID, ILocalChange> newChanges = new HashMap<UUID, ILocalChange>(fromLCM.length);
        ILocalChange[] iLocalChangeArray2 = fromLCM;
        int n3 = fromLCM.length;
        int n4 = 0;
        while (n4 < n3) {
            ILocalChange change = iLocalChangeArray2[n4];
            newChanges.put(change.getTarget().getItemId(), change);
            ++n4;
        }
        ArrayList<ILocalChange> toReturn = new ArrayList<ILocalChange>(toRefresh.length);
        ILocalChange[] iLocalChangeArray3 = toRefresh;
        int n5 = toRefresh.length;
        n3 = 0;
        while (n3 < n5) {
            ILocalChange change = iLocalChangeArray3[n3];
            ILocalChange current = (ILocalChange)newChanges.get(change.getTarget().getItemId());
            if (current != null) {
                toReturn.add(current);
            }
            ++n3;
        }
        return toReturn.toArray(new ILocalChange[toReturn.size()]);
    }

    @Override
    public void disableNonAtomicCommit() {
        this.nonAtomicCommitIsAnOption = false;
    }

    @Override
    public void enableNonAtomicCommit(int numberUploads) {
        this.nonAtomicCommitIsAnOption = true;
        this.uploadLimit = numberUploads;
    }

    public static abstract class ComponentCheckInRequest {
        private Map<UUID, Set<ILocalChange>> changesToCommit;
        private Set<ILocalChange> allChanges;
        private Map<UUID, IChangeSetHandle> changeSetsToCommit;
        protected final ISandbox sandbox;
        protected final IChangeSetHandle changeSet;
        protected final String commentForNewChangeSet;
        protected final IWorkspaceConnection workspace;
        protected final IComponentHandle component;

        protected ComponentCheckInRequest(ISandbox sb, IWorkspaceConnection workspace, IComponentHandle component, IChangeSetHandle csHandle, String commentForNewChangeSet) {
            this.sandbox = sb;
            this.workspace = workspace;
            this.component = component;
            this.changeSet = csHandle;
            this.commentForNewChangeSet = commentForNewChangeSet;
        }

        public abstract ILocalChange[] getChanges(boolean var1, IProgressMonitor var2) throws FileSystemException;

        public final IComponentHandle getComponent() {
            return this.component;
        }

        public final IWorkspaceConnection getWorkspace() {
            return this.workspace;
        }

        public abstract void validate(IProgressMonitor var1) throws FileSystemException;

        public final LocalChangeTracker getTracker() throws FileSystemException {
            LocalChangeManager lcm = (LocalChangeManager)FileSystemCore.getSharingManager().getLocalChangeManager();
            return lcm.findTracker((IContextHandle)this.getWorkspace().getResolvedWorkspace(), this.getComponent(), this.getSandbox().getRoot());
        }

        public final String getCommentForNewChangeSet() {
            return this.commentForNewChangeSet;
        }

        public final void setChangesToCommit(HashMap<UUID, Set<ILocalChange>> changesToCommit) {
            this.changesToCommit = changesToCommit;
        }

        public final void setChangeSetsToCommit(Map<UUID, IChangeSetHandle> changeSetsToCommit) {
            this.changeSetsToCommit = changeSetsToCommit;
        }

        public final ICopyFileArea getCfa() {
            return CopyFileAreaManager.instance.getCopyFileAreaForPath(this.getSandbox().getRoot());
        }

        public final ISandbox getSandbox() {
            return this.sandbox;
        }

        public final IChangeSetHandle getPreferredChangeSet() {
            return this.changeSet;
        }

        public final boolean isTargetPatchCheckIn() {
            if (this.getPreferredChangeSet() == null) {
                return false;
            }
            if (this.workspace == null || this.workspace.getCurrentPatch(this.getComponent()) == null) {
                return false;
            }
            IChangeSetHandle patchTargetChangeSet = this.workspace.getCurrentPatch(this.getComponent()).getTargetChangeSet();
            return this.getPreferredChangeSet().getItemId().equals((Object)patchTargetChangeSet.getItemId());
        }
    }

    public static class SymbolicLinkDetails {
        List<IShareable> shareables = new ArrayList<IShareable>();
        List<String> targets = new ArrayList<String>();
        List<Boolean> linkTypes = new ArrayList<Boolean>();
        List<Boolean> brokens = new ArrayList<Boolean>();
        List<Boolean> nonInteroperables = new ArrayList<Boolean>();
        boolean anyBroken = false;
        boolean anyNonInteroperable = false;

        public void push(IShareable shareable, String target, boolean directoryLink, boolean broken, boolean nonInteroperable) {
            if (!broken && !nonInteroperable) {
                return;
            }
            this.shareables.add(shareable);
            this.targets.add(target);
            this.linkTypes.add(directoryLink);
            this.brokens.add(broken);
            this.nonInteroperables.add(nonInteroperable);
            if (broken) {
                this.anyBroken = true;
            }
            if (nonInteroperable) {
                this.anyNonInteroperable = true;
            }
        }

        public IShareable[] getShareables() {
            return this.shareables.toArray(new IShareable[this.shareables.size()]);
        }

        public String[] getTargets() {
            return this.targets.toArray(new String[this.targets.size()]);
        }

        public Boolean[] getDirectoryLinks() {
            return this.linkTypes.toArray(new Boolean[this.linkTypes.size()]);
        }

        public Boolean[] getBroken() {
            return this.brokens.toArray(new Boolean[this.brokens.size()]);
        }

        public Boolean[] getNonInteroperable() {
            return this.nonInteroperables.toArray(new Boolean[this.nonInteroperables.size()]);
        }

        public boolean isEmpty() {
            return this.shareables.isEmpty();
        }

        public boolean isAnyBroken() {
            return this.anyBroken;
        }

        public boolean isAnyNonInteroperable() {
            return this.anyNonInteroperable;
        }
    }

    private static class WorkspaceCheckInRequest {
        final List<ComponentCheckInRequest> reqs;
        final IWorkspaceConnection workspace;
        Set<ICopyFileArea> allSandboxes = null;

        public WorkspaceCheckInRequest(List<ComponentCheckInRequest> reqs) {
            this.reqs = reqs;
            this.workspace = reqs.iterator().next().getWorkspace();
        }

        public IWorkspaceConnection getWorkspace() {
            return this.workspace;
        }

        public Set<ICopyFileArea> allCfas() {
            if (this.allSandboxes == null) {
                this.allSandboxes = new HashSet<ICopyFileArea>();
                for (ComponentCheckInRequest compReq : this.reqs) {
                    this.allSandboxes.add(compReq.getCfa());
                }
            }
            return this.allSandboxes;
        }
    }
}

