/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.localchanges;

import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;

public class LocalChangeContext {
    private IComponentHandle component;
    private IContextHandle connection;
    private ILocation cfaRoot;

    public LocalChangeContext(IComponentHandle component, IContextHandle connection, ILocation cfaRoot) {
        this.component = component;
        this.connection = connection;
        ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
        this.cfaRoot = cfa != null ? cfa.getRoot() : cfaRoot.getCanonicalForm();
    }

    public IComponentHandle getComponent() {
        return this.component;
    }

    public IContextHandle getConnection() {
        return this.connection;
    }

    public ILocation getRoot() {
        return this.cfaRoot;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LocalChangeContext)) {
            return false;
        }
        LocalChangeContext another = (LocalChangeContext)obj;
        return another.component.sameItemId((IItemHandle)this.component) && another.connection.sameItemId((IItemHandle)this.connection) && another.cfaRoot.equals(this.cfaRoot);
    }

    public int hashCode() {
        return this.component.getItemId().hashCode() ^ this.connection.getItemId().hashCode() ^ this.cfaRoot.hashCode();
    }

    public String toString() {
        return "LocalChangeContext(" + this.cfaRoot.toOSString() + ", " + this.connection.getItemId().getUuidValue() + ", " + this.component.getItemId().getUuidValue() + ')';
    }
}

