/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.LockOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.internal.utils.ExclusiveFileLockPatternUtil;
import com.ibm.team.filesystem.client.operations.LockDilemmaHandler;
import com.ibm.team.filesystem.client.operations.LockEntry;
import com.ibm.team.filesystem.common.internal.util.StringMatcher;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFlowEntry;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.LockOperationFailureException;
import com.ibm.team.scm.common.dto.IComponentLockReport;
import com.ibm.team.scm.common.dto.ILockSearchCriteria;
import com.ibm.team.scm.common.dto.ILockSearchResult;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.dto.IVersionableLock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;

public abstract class AbstractLockOperation
extends FileSystemOperation {
    private Map<ITeamRepository, List<LockEntry>> repoBatch = new HashMap<ITeamRepository, List<LockEntry>>();

    public AbstractLockOperation(LockDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? new LockDilemmaHandler() : dilemmaHandler);
    }

    protected LockEntry add(IWorkspaceConnection workspaceConnection, IComponentHandle componentHandle, IVersionableHandle versionableHandle, IContributorHandle contributorHandle) {
        LockEntry lockEntry = new LockEntry(workspaceConnection, componentHandle, versionableHandle, contributorHandle);
        this.addLockEntry(lockEntry);
        return lockEntry;
    }

    protected LockEntry add(IWorkspaceConnection sourceWorkspaceConnection, IWorkspaceConnection workspaceConnection, IComponentHandle componentHandle, IVersionableHandle versionableHandle, IContributorHandle contributorHandle) {
        LockEntry lockEntry = new LockEntry(sourceWorkspaceConnection, workspaceConnection, componentHandle, versionableHandle, contributorHandle);
        this.addLockEntry(lockEntry);
        return lockEntry;
    }

    protected void addLockEntry(LockEntry lockEntry) {
        ITeamRepository repo = lockEntry.getRepository();
        List<LockEntry> list = this.repoBatch.get(repo);
        if (list == null) {
            list = new ArrayList<LockEntry>();
            this.repoBatch.put(repo, list);
        }
        list.add(lockEntry);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemException, TeamRepositoryException {
        sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.repoBatch.size() * 2));
        for (Map.Entry<ITeamRepository, List<LockEntry>> entry : this.repoBatch.entrySet()) {
            block5: {
                lockEntries = entry.getValue();
                workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)entry.getKey());
                child = sub.newChild(1);
                child.setTaskName(Messages.AbstractLockOperation_0);
                lockOperations = this.getLockOperations(workspaceManager, lockEntries, (IProgressMonitor)child);
                child = sub.newChild(1);
                child.setTaskName(Messages.AbstractLockOperation_1);
                try {
                    workspaceManager.applyLockOperations(lockOperations, (IProgressMonitor)child);
                    break block5;
                }
                catch (LockOperationFailureException e) {
                    strings = e.getMessage().split("\r\n|\r|\n");
                    if (strings.length == 1) {
                        throw e;
                    }
                    errors = new IStatus[strings.length];
                    i = 0;
                    ** while (i < strings.length)
                }
lbl-1000:
                // 1 sources

                {
                    errors[i] = FileSystemStatusUtil.getStatusFor(4, strings[i]);
                    ++i;
                    continue;
                }
lbl23:
                // 1 sources

                status = new MultiStatus("com.ibm.team.filesystem.client", 4, errors, Messages.AbstractLockOperation_2, null);
                throw new FileSystemStatusException((IStatus)status);
            }
            this.refreshFileAttributes(lockEntries, child.newChild(1));
        }
    }

    private List<IWorkspaceManager.IVersionableLockOperation> getLockOperations(IWorkspaceManager workspaceManager, List<LockEntry> lockEntries, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)lockEntries.size());
        IWorkspaceManager.IVersionableLockOperationFactory lockOperationFactory = workspaceManager.lockOperationFactory();
        ArrayList<IWorkspaceManager.IVersionableLockOperation> lockOperations = new ArrayList<IWorkspaceManager.IVersionableLockOperation>();
        for (LockEntry lockEntry : lockEntries) {
            IWorkspaceConnection connection;
            IWorkspaceManager.IVersionableLockOperation op = this.getLockOperation(lockOperationFactory, lockEntry, connection = workspaceManager.getWorkspaceConnection(lockEntry.getStream(), (IProgressMonitor)sub.newChild(1)));
            if (op == null) continue;
            lockOperations.add(op);
        }
        return lockOperations;
    }

    protected Map<ITeamRepository, List<LockEntry>> getRepositoryBatch() {
        return this.repoBatch;
    }

    protected abstract IWorkspaceManager.IVersionableLockOperation getLockOperation(IWorkspaceManager.IVersionableLockOperationFactory var1, LockEntry var2, IWorkspaceConnection var3);

    protected int checkLockOwners(IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        HashMap<ITeamRepository, List<LockEntry>> notLockOwner = new HashMap<ITeamRepository, List<LockEntry>>();
        for (Map.Entry<ITeamRepository, List<LockEntry>> entry : this.getRepositoryBatch().entrySet()) {
            ITeamRepository repo = entry.getKey();
            IContributor caller = repo.loggedInContributor();
            HashMap workspaceComponentLockSearch = new HashMap();
            for (LockEntry lockEntry : entry.getValue()) {
                IContributorHandle owner = lockEntry.getContributor();
                if (owner == null) {
                    ArrayList<IVersionableHandle> versionables;
                    HashMap<UUID, ArrayList<IVersionableHandle>> componentLockSearch = (HashMap<UUID, ArrayList<IVersionableHandle>>)workspaceComponentLockSearch.get(lockEntry.getStream().getItemId());
                    if (componentLockSearch == null) {
                        componentLockSearch = new HashMap<UUID, ArrayList<IVersionableHandle>>();
                        workspaceComponentLockSearch.put(lockEntry.getStream().getItemId(), componentLockSearch);
                    }
                    if ((versionables = (ArrayList<IVersionableHandle>)componentLockSearch.get(lockEntry.getComponent().getItemId())) == null) {
                        versionables = new ArrayList<IVersionableHandle>();
                        componentLockSearch.put(lockEntry.getComponent().getItemId(), versionables);
                    }
                    versionables.add(lockEntry.getVersionable());
                    continue;
                }
                if (owner.sameItemId((IItemHandle)caller)) continue;
                ArrayList<LockEntry> list = (ArrayList<LockEntry>)notLockOwner.get(repo);
                if (list == null) {
                    list = new ArrayList<LockEntry>();
                    notLockOwner.put(repo, list);
                }
                list.add(lockEntry);
            }
            if (workspaceComponentLockSearch.isEmpty()) continue;
            monitor.setWorkRemaining(workspaceComponentLockSearch.size() * 100);
            IWorkspaceManager workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
            for (Map.Entry searchEntries : workspaceComponentLockSearch.entrySet()) {
                IWorkspaceHandle streamHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle((UUID)searchEntries.getKey(), null);
                SubMonitor subMonitor = monitor.newChild(100);
                subMonitor.setWorkRemaining(10 * ((Map)searchEntries.getValue()).size());
                for (Map.Entry search : ((Map)searchEntries.getValue()).entrySet()) {
                    IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((UUID)search.getKey(), null);
                    List versionableHandles = (List)search.getValue();
                    SubMonitor iterMonitor = subMonitor.newChild(10);
                    iterMonitor.setWorkRemaining(versionableHandles.size());
                    while (!versionableHandles.isEmpty()) {
                        int count = 0;
                        ILockSearchCriteria searchCriteria = ILockSearchCriteria.FACTORY.newInstance();
                        searchCriteria.getStreams().add(streamHandle);
                        searchCriteria.getComponents().add(componentHandle);
                        Iterator iter = versionableHandles.iterator();
                        while (count < 512 && iter.hasNext()) {
                            IVersionableHandle handle = (IVersionableHandle)iter.next();
                            iter.remove();
                            searchCriteria.getVersionables().add(handle);
                            ++count;
                        }
                        ILockSearchResult result = workspaceManager.findLocks(searchCriteria, 512, (IProgressMonitor)iterMonitor.newChild(searchCriteria.getVersionables().size()));
                        for (IStreamLockReport report : result.getReports()) {
                            for (IComponentLockReport lockReport : report.getComponentLocks()) {
                                for (IVersionableLock lock : lockReport.getLocks()) {
                                    if (lock.getContributor().sameItemId((IItemHandle)caller)) continue;
                                    ArrayList<LockEntry> list = (ArrayList<LockEntry>)notLockOwner.get(repo);
                                    if (list == null) {
                                        list = new ArrayList<LockEntry>();
                                        notLockOwner.put(repo, list);
                                    }
                                    LockEntry lockEntry = new LockEntry(repo, streamHandle, componentHandle, lock.getVersionable(), lock.getContributor());
                                    list.add(lockEntry);
                                }
                            }
                        }
                    }
                }
            }
        }
        LockDilemmaHandler handler = (LockDilemmaHandler)this.getDilemmaHandler();
        int result = !notLockOwner.isEmpty() ? handler.currentUserDoesntOwnLock(notLockOwner) : 3;
        return result;
    }

    private void refreshFileAttributes(List<LockEntry> lockEntries, SubMonitor subMonitor) throws TeamRepositoryException {
        HashSet<ConfigurationFacade> configurations = new HashSet<ConfigurationFacade>();
        HashMap<IWorkspaceConnection, List<StringMatcher>> patterns = new HashMap<IWorkspaceConnection, List<StringMatcher>>();
        HashMap workspaceComponent = new HashMap();
        for (LockEntry lockEntry : lockEntries) {
            List<StringMatcher> matchers;
            IFlowEntry defaultFlowEntry;
            IWorkspaceConnection workspaceConnection = lockEntry.getSourceWorkspaceConnection((IProgressMonitor)subMonitor.newChild(1));
            if (workspaceConnection == null || (defaultFlowEntry = workspaceConnection.getFlowTable().getDefaultAcceptFlow()) == null || !defaultFlowEntry.getFlowNode().getItemId().equals((Object)lockEntry.getStream().getItemId()) || (matchers = this.hasPattern(workspaceConnection, patterns, subMonitor.newChild(1))) == null || matchers.size() == 0) continue;
            ArrayList<IComponentHandle> components = (ArrayList<IComponentHandle>)workspaceComponent.get(workspaceConnection);
            if (components == null) {
                components = new ArrayList<IComponentHandle>();
                workspaceComponent.put(workspaceConnection, components);
            }
            if (components.contains(lockEntry.getComponent())) continue;
            components.add(lockEntry.getComponent());
            configurations.add(new ConfigurationFacade((IConnection)lockEntry.getSourceWorkspaceConnection((IProgressMonitor)subMonitor.newChild(1)), lockEntry.getComponent()));
        }
        if (configurations.size() == 0) {
            return;
        }
        Map<ISandbox, Set<ConfigurationFacade>> affectedAreas = ExclusiveFileLockPatternUtil.getCopyFileAreasAffected(configurations, (IProgressMonitor)subMonitor.newChild(10));
        if (affectedAreas.size() == 0) {
            return;
        }
        HashMap<IWorkspaceConnection, ISandbox> sandboxes = new HashMap<IWorkspaceConnection, ISandbox>();
        for (LockEntry lockEntry : lockEntries) {
            IShareable shareable;
            IWorkspaceConnection workspaceConnection = lockEntry.getSourceWorkspaceConnection((IProgressMonitor)subMonitor.newChild(1));
            ISandbox sandbox = null;
            if (sandboxes.containsKey(workspaceConnection)) {
                sandbox = (ISandbox)sandboxes.get(workspaceConnection);
            } else {
                sandbox = ExclusiveFileLockPatternUtil.getSandbox(affectedAreas, workspaceConnection, subMonitor.newChild(1));
                sandboxes.put(workspaceConnection, sandbox);
            }
            if (sandbox == null || (shareable = sandbox.findShareable(workspaceConnection.getContextHandle(), lockEntry.getComponent(), lockEntry.getVersionable(), (IProgressMonitor)subMonitor.newChild(1))) == null) continue;
            List matchers = (List)patterns.get(workspaceConnection);
            if (this instanceof LockOperation) {
                ExclusiveFileLockPatternUtil.makeFileWriteable(shareable, matchers);
                continue;
            }
            ILocalChange localChange = shareable.getChange((IProgressMonitor)subMonitor.newChild(1));
            if (localChange == null || localChange.getType() != 0) continue;
            ExclusiveFileLockPatternUtil.makeFileReadOnly(shareable, matchers);
        }
    }

    private List<StringMatcher> hasPattern(IWorkspaceConnection workspaceConnection, Map<IWorkspaceConnection, List<StringMatcher>> workspacePatterns, SubMonitor progress) {
        List<StringMatcher> patterns = workspacePatterns.get(workspaceConnection);
        if (patterns != null) {
            return patterns;
        }
        patterns = ExclusiveFileLockPatternUtil.getPatternsToMatch((IConnection)workspaceConnection, (IProgressMonitor)progress.newChild(1));
        workspacePatterns.put(workspaceConnection, patterns);
        return patterns;
    }
}

