/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.internal.FileSystemStatusUtil;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.IWorkspaceUpdateReporter;
import com.ibm.team.filesystem.client.operations.IWorkspaceUpdateReport;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.scm.client.IFlowNodeConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;

public class WorkspaceUpdateReport
implements IWorkspaceUpdateReport,
IWorkspaceUpdateReporter {
    MultiStatus errors = null;
    HashMap<IWorkspaceConnection, Map<UUID, IComponentHandle>> workspacesAndComponents = new HashMap();
    Map<IWorkspaceConnection, Map<UUID, List<IChangeSetHandle>>> acceptedChangeSets = new HashMap<IWorkspaceConnection, Map<UUID, List<IChangeSetHandle>>>();
    Map<IWorkspaceConnection, Map<UUID, List<IBaselineHandle>>> acceptedBaselines = new HashMap<IWorkspaceConnection, Map<UUID, List<IBaselineHandle>>>();
    Map<IWorkspaceConnection, Map<UUID, ComponentChangeType>> changedComps = new HashMap<IWorkspaceConnection, Map<UUID, ComponentChangeType>>();

    private <T> List<T> getItems(Map<IWorkspaceConnection, Map<UUID, List<T>>> group, IWorkspaceConnection ws, IComponentHandle comp) {
        Map<UUID, List<T>> itemsForWs = group.get(ws);
        if (itemsForWs == null) {
            return Collections.emptyList();
        }
        List<T> items = itemsForWs.get(comp.getItemId());
        if (items == null) {
            return Collections.emptyList();
        }
        return items;
    }

    @Override
    public List<IChangeSetHandle> getAcceptedChanges(IWorkspaceConnection ws, IComponentHandle comp) {
        return this.getItems(this.acceptedChangeSets, ws, comp);
    }

    @Override
    public List<IBaselineHandle> getBaselines(IWorkspaceConnection ws, IComponentHandle comp) {
        return this.getItems(this.acceptedBaselines, ws, comp);
    }

    @Override
    public List<IComponentHandle> getAffectedComponents(IWorkspaceConnection ws) {
        ArrayList<IComponentHandle> toReturn = new ArrayList<IComponentHandle>();
        toReturn.addAll(this.workspacesAndComponents.get(ws).values());
        return toReturn;
    }

    @Override
    public boolean isRemovedComponent(IWorkspaceConnection ws, IComponentHandle componentHandle) {
        Map<UUID, ComponentChangeType> changed = this.changedComps.get(ws);
        if (changed != null && changed.containsKey(componentHandle.getItemId())) {
            return ComponentChangeType.REMOVED.equals((Object)changed.get(componentHandle.getItemId()));
        }
        return false;
    }

    @Override
    public Collection<IWorkspaceConnection> getConnections() {
        return this.workspacesAndComponents.keySet();
    }

    @Override
    public void recordChangeSets(IWorkspaceConnection workspace, List<IChangeSetHandle> changeSetsToAccept, IProgressMonitor mon) {
        try {
            List changes = workspace.teamRepository().itemManager().fetchCompleteItems(changeSetsToAccept, 0, mon);
            Map<UUID, List<IChangeSetHandle>> components = this.acceptedChangeSets.get(workspace);
            if (components == null) {
                components = new HashMap<UUID, List<IChangeSetHandle>>(workspace.getComponents().size());
                this.acceptedChangeSets.put(workspace, components);
            }
            for (IChangeSet cs : changes) {
                UUID compId = cs.getComponent().getItemId();
                List<IChangeSetHandle> changesInComponent = components.get(compId);
                if (changesInComponent == null) {
                    changesInComponent = new ArrayList<IChangeSetHandle>(changes.size());
                    components.put(compId, changesInComponent);
                    this.recordModifiedComponent(workspace, cs.getComponent());
                }
                CollectionUtil.addToMapOfLists(components, (Object)cs.getComponent().getItemId(), (Object)cs);
            }
        }
        catch (TeamRepositoryException e) {
            this.record(e);
        }
    }

    @Override
    public void recordBaselines(IWorkspaceConnection workspace, List<IBaselineHandle> baselinesToAccept, IProgressMonitor mon) {
        Map<UUID, List<IBaselineHandle>> components;
        List baselines;
        try {
            baselines = workspace.teamRepository().itemManager().fetchCompleteItems(baselinesToAccept, 0, mon);
            components = this.acceptedBaselines.get(workspace);
            if (components == null) {
                components = new HashMap<UUID, List<IBaselineHandle>>(workspace.getComponents().size());
                this.acceptedBaselines.put(workspace, components);
            }
        }
        catch (TeamRepositoryException e) {
            this.record(e);
            return;
        }
        for (IBaseline baseline : baselines) {
            CollectionUtil.addToMapOfLists(components, (Object)baseline.getComponent().getItemId(), (Object)baseline);
            this.recordModifiedComponent(workspace, baseline.getComponent());
        }
    }

    @Override
    public void recordComponentOps(IWorkspaceConnection workspace, List<IFlowNodeConnection.IComponentOp> componentOps) {
        Map<UUID, ComponentChangeType> components;
        try {
            components = this.changedComps.get(workspace);
            if (components == null) {
                components = new HashMap<UUID, ComponentChangeType>(workspace.getComponents().size());
                this.changedComps.put(workspace, components);
            }
        }
        catch (TeamRepositoryException e) {
            this.record(e);
            return;
        }
        for (IFlowNodeConnection.IComponentOp op : componentOps) {
            ComponentChangeType type;
            if (op instanceof IFlowNodeConnection.IComponentAdditionOp) {
                type = ComponentChangeType.ADDITION;
            } else if (op instanceof IFlowNodeConnection.IComponentDeletionOp) {
                type = ComponentChangeType.REMOVED;
            } else if (op instanceof IFlowNodeConnection.IComponentReplacementOp) {
                type = ComponentChangeType.REPLACED;
            } else {
                this.record(FileSystemStatusUtil.getStatusFor(4, NLS.bind((String)"Unknown component op type: {0}", (Object)op.getClass().getSimpleName()), null));
                continue;
            }
            components.put(op.getComponent().getItemId(), type);
            this.recordModifiedComponent(workspace, op.getComponent());
        }
    }

    private void recordModifiedComponent(IWorkspaceConnection workspace, IComponentHandle component) {
        Map<UUID, IComponentHandle> components = this.workspacesAndComponents.get(workspace);
        if (components == null) {
            components = new HashMap<UUID, IComponentHandle>();
            this.workspacesAndComponents.put(workspace, components);
        }
        components.put(component.getItemId(), component);
    }

    private void record(TeamRepositoryException e) {
        this.record(FileSystemStatusUtil.getStatusFor(e));
    }

    private void record(IStatus status) {
        if (this.errors == null) {
            this.errors = new MultiStatus("com.ibm.team.filesystem.client", -1, Messages.WorkspaceUpdateReport_ERROR_STORING_REPORT, null);
        }
        this.errors.add(status);
    }

    @Override
    public IWorkspaceUpdateReport getReport() {
        return this;
    }

    private static enum ComponentChangeType {
        ADDITION,
        REMOVED,
        REPLACED;

    }
}

