/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.FileSystemStatusException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileStorage;
import com.ibm.team.filesystem.client.internal.FileStorageWrapper;
import com.ibm.team.filesystem.client.internal.IFileOptions;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.PlatformDetector;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.api.storage.ContentMeta;
import com.ibm.team.filesystem.client.internal.api.storage.IBackupHandler;
import com.ibm.team.filesystem.client.internal.api.storage.LocalFileAccessExtension;
import com.ibm.team.filesystem.client.internal.exceptions.ContentRetrievalFailure;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreManager;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.internal.repository.rcp.streams.DigestComputingOutputStream;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.ContentHashAlgorithmException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;

public class LocalFileStorage
extends FileStorage {
    private static final String SIMULATION_PROPERTY = "rtcz.simulate";
    public static final boolean ZOS_SIMULATION_ENABLED = System.getProperty("rtcz.simulate") != null;
    private static final String PT_LOCAL_FILE_STORAGE_EXT = "localFileAccess";
    private static final LocalFileAccessExtension localFileAccessExtension;
    private final File file;
    private final IPath path;

    static {
        LocalFileAccessExtension extension = null;
        IConfigurationElement[] configs = RegistryFactory.getRegistry().getConfigurationElementsFor("com.ibm.team.filesystem.client", PT_LOCAL_FILE_STORAGE_EXT);
        PlatformDetector.Platform platform = ZOS_SIMULATION_ENABLED ? PlatformDetector.Platform.Z : PlatformDetector.getPlatform();
        IConfigurationElement choice = null;
        if (platform == PlatformDetector.Platform.Z) {
            IConfigurationElement[] iConfigurationElementArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config = iConfigurationElementArray[n2];
                String id = config.getAttribute("platform");
                if (id != null && id.equals(platform.toString())) {
                    if (choice == null) {
                        choice = config;
                    } else {
                        throw new IllegalStateException("Only one local file storage extension implementation can be registered for platform " + (Object)((Object)platform));
                    }
                }
                ++n2;
            }
        }
        if (choice != null) {
            try {
                extension = (LocalFileAccessExtension)choice.createExecutableExtension("class");
            }
            catch (CoreException e) {
                LoggingHelper.log(e);
            }
        }
        localFileAccessExtension = extension == null ? new LocalFileAccessExtension() : extension;
    }

    public static void resolveLocalFileStorage(FileStorageWrapper storage, ResourceType type) {
        storage.setUnderlyingStorage(new LocalFileStorage(storage));
    }

    public static LocalFileAccessExtension getFileAccessExtension() {
        return localFileAccessExtension;
    }

    private LocalFileStorage(IFileStorage storage) {
        super(storage);
        this.path = (IPath)storage.getShareable().getFullPath().getAdapter(IPath.class);
        this.file = this.path.toFile();
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public long getModificationStamp() {
        long result = this.file.lastModified();
        if (result == 0L) {
            return this.getFileStore().fetchInfo().exists() ? 0L : -1L;
        }
        return result;
    }

    @Override
    public long getLocalTimeStamp() {
        return this.file.lastModified();
    }

    @Override
    public IFileStorage getParent() {
        FileStorageWrapper parent = null;
        IRelativeLocation parentPath = this.getLocalPath().getParent();
        if (parentPath != null && !parentPath.isEmpty()) {
            Shareable parentShareable = new Shareable(this.getSandbox(), parentPath, ResourceType.FOLDER);
            parent = new FileStorageWrapper(parentShareable, ResourceType.FOLDER);
        }
        return parent;
    }

    @Override
    public void resolveChildStorage(FileStorageWrapper childStorage, String name, ResourceType type) {
        if (this.file.isDirectory()) {
            File childFile = new File(this.file, name);
            if (childFile.exists()) {
                String caseCorrectName = name;
                if (!this.getSandbox().isCaseSensitive()) {
                    File[] children;
                    File[] fileArray = children = this.file.listFiles();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File child = fileArray[n2];
                        if (child.getName().equalsIgnoreCase(name)) {
                            caseCorrectName = child.getName();
                        }
                        ++n2;
                    }
                    if (!caseCorrectName.equals(name)) {
                        childStorage = new FileStorageWrapper(this.getSandbox(), this.getLocalPath().append(caseCorrectName), type);
                    }
                }
                SharingManager.getInstance().resolveFileStorage(childStorage, type);
            } else {
                childStorage.setUnderlyingStorage(new LocalFileStorage(childStorage));
            }
        } else {
            throw new IllegalStateException(NLS.bind((String)Messages.LocalFileStorage_7, (Object)name, (Object[])new Object[]{childStorage.getShareable().getLocalPath().toString()}));
        }
    }

    @Override
    public Collection<IFileStorage> getChildren(boolean refreshAllowed, IProgressMonitor progress) throws FileSystemException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IFileStore fileStorage = this.getFileStore();
        SharingManager sm = SharingManager.getInstance();
        sm.disableChangeMonitoring();
        try {
            IFileInfo fileInfo = fileStorage.fetchInfo(0, (IProgressMonitor)monitor.newChild(1));
            if (!fileInfo.isDirectory() || fileInfo.getAttribute(32)) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
        }
        catch (CoreException e) {
            throw FileSystemStatusException.fromCoreException(NLS.bind((String)Messages.LocalFileStorage_8, (Object)this.getLocalPath().toString(), (Object[])new Object[]{e.getMessage()}), e);
        }
        finally {
            sm.enableChangeMonitoring();
        }
        File[] listing = this.file.listFiles();
        if (listing == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IFileStorage> children = new ArrayList<IFileStorage>(listing.length);
        ISandbox sandbox = this.getSandbox();
        IRelativeLocation path = this.getLocalPath();
        File[] fileArray = listing;
        int n = listing.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            ResourceType type = child.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE;
            Shareable childShareable = new Shareable(sandbox, path.append(child.getName()), type);
            FileStorageWrapper storage = new FileStorageWrapper(childShareable, this.getStorage(), type);
            children.add(storage);
            ++n2;
        }
        return children;
    }

    @Override
    public InputStream getContents(IFileOptions options) throws ContentRetrievalFailure {
        if (this.file.isDirectory()) {
            return null;
        }
        try {
            FileInputStream in = new FileInputStream(this.file);
            return localFileAccessExtension.prepareContentsToReceive(options, in);
        }
        catch (FileNotFoundException e) {
            throw new ContentRetrievalFailure(NLS.bind((String)Messages.LocalFileStorage_1, (Object)this.getLocalPath().toString(), (Object[])new Object[]{e.getMessage()}), this.getLocalPath(), (Throwable)e);
        }
    }

    @Override
    public InputStream getContents(IFileOptions options, InputStream in) throws ContentRetrievalFailure {
        return localFileAccessExtension.prepareContentsToReceive(options, in);
    }

    @Override
    public InputStream getLocalChangeDetectionStream(IFileOptions fileOptions) throws ContentRetrievalFailure {
        if (this.file.isDirectory()) {
            return null;
        }
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new ContentRetrievalFailure(NLS.bind((String)Messages.LocalFileStorage_1, (Object)this.getLocalPath().toString(), (Object[])new Object[]{e.getMessage()}), this.getLocalPath(), (Throwable)e);
        }
    }

    @Override
    public void create(IFileOptions options, InputStream in, IProgressMonitor monitor) throws FileSystemException {
        this.setContents(options, in, new Shed(null), monitor);
    }

    @Override
    public void create(boolean createParents, Object additionalInfo, IProgressMonitor progress) throws FileSystemException {
        block13: {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            IFileStore fileStore = null;
            try {
                CoreException e2;
                block14: {
                    IFileStore parentFileStore;
                    block16: {
                        block15: {
                            boolean found;
                            try {
                                fileStore = this.getFileStore();
                                this.getFileStore().mkdir(createParents ? 0 : 4, (IProgressMonitor)monitor);
                                break block13;
                            }
                            catch (CoreException e2) {
                                IStatus status = e2.getStatus();
                                if (fileStore == null || status.getCode() != 277) break block14;
                                if (!createParents) break block15;
                                found = false;
                                int paranoia = 0;
                                parentFileStore = fileStore.getParent();
                                try {
                                    while (parentFileStore != null && !found && paranoia < 500) {
                                        IFileInfo fileInfo = parentFileStore.fetchInfo(0, (IProgressMonitor)monitor.newChild(1));
                                        if (fileInfo.getAttribute(32) || fileInfo.exists()) {
                                            found = true;
                                        } else {
                                            parentFileStore = fileStore.getParent();
                                        }
                                        ++paranoia;
                                    }
                                }
                                catch (CoreException coreException) {}
                            }
                            if (!found) {
                                throw FileSystemStatusException.fromCoreException(NLS.bind((String)Messages.LocalFileStorage_2, (Object)this.getLocalPath().toString(), (Object[])new Object[]{e2.getMessage()}), e2);
                            }
                            break block16;
                        }
                        parentFileStore = fileStore.getParent();
                    }
                    LocalFileStorage.setWritable(parentFileStore, true, (IProgressMonitor)monitor.newChild(1));
                    try {
                        this.getFileStore().mkdir(createParents ? 0 : 4, (IProgressMonitor)monitor);
                        break block13;
                    }
                    catch (CoreException e2) {
                        throw FileSystemStatusException.fromCoreException(NLS.bind((String)Messages.LocalFileStorage_2, (Object)this.getLocalPath().toString(), (Object[])new Object[]{e2.getMessage()}), e2);
                    }
                }
                throw FileSystemStatusException.fromCoreException(NLS.bind((String)Messages.LocalFileStorage_2, (Object)this.getLocalPath().toString(), (Object[])new Object[]{e2.getMessage()}), e2);
            }
            finally {
                monitor.done();
            }
        }
    }

    @Override
    public void setContents(IFileOptions options, InputStream in, Shed backupShed, IProgressMonitor monitor) throws FileSystemException {
        this.setContentsCalcMeta(false, options, in, backupShed, monitor);
    }

    @Override
    public ContentMeta setContentsCalcMeta(IFileOptions options, InputStream in, Shed backupShed, IProgressMonitor monitor) throws FileSystemException {
        return this.setContentsCalcMeta(true, options, in, backupShed, monitor);
    }

    public ContentMeta setContentsCalcMeta(boolean captureChangeDetectionInfo, IFileOptions options, InputStream in, Shed backupShed, IProgressMonitor monitor) throws FileSystemException {
        ContentMeta result;
        block39: {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            result = null;
            try {
                if (this.file.isDirectory()) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            throw new FileSystemException(NLS.bind((String)Messages.LocalFileStorage_9, (Object)this.getLocalPath(), (Object[])new Object[]{e.getMessage()}), e);
                        }
                    }
                    throw new FileSystemException(NLS.bind((String)Messages.LocalFileStorage_3, (Object)this.getLocalPath(), (Object[])new Object[0]));
                }
                boolean success = false;
                try {
                    try {
                        OutputStream out;
                        backupShed.backupIfDirty(this.getStorage().getShareable(), (IProgressMonitor)progress.newChild(1));
                        IFileStore fileStore = this.getFileStore();
                        try {
                            out = fileStore.openOutputStream(0, (IProgressMonitor)progress.newChild(1));
                        }
                        catch (CoreException e2) {
                            IStatus status = e2.getStatus();
                            boolean retry = false;
                            if (status.getCode() == 277) {
                                retry = LocalFileStorage.setWritable(fileStore.getParent(), true, (IProgressMonitor)progress.newChild(1));
                                this.setWritable(true, (IProgressMonitor)progress.newChild(1));
                            } else if (status.getCode() == 279 || !this.file.canWrite()) {
                                retry = this.setWritable(true, (IProgressMonitor)progress.newChild(1));
                            }
                            if (retry) {
                                out = fileStore.openOutputStream(0, (IProgressMonitor)progress.newChild(1));
                            }
                            throw FileSystemStatusException.fromCoreException(NLS.bind((String)Messages.LocalFileStorage_9, (Object)this.getLocalPath(), (Object[])new Object[]{e2.getMessage()}), e2);
                        }
                        if (captureChangeDetectionInfo) {
                            out = ContentHash.getDigestComputingOutputStream((OutputStream)out);
                        }
                        try {
                            if (in != null) {
                                in = localFileAccessExtension.prepareContentsToSet(options, in);
                                byte[] buf = new byte[8192];
                                int size = in.read(buf);
                                while (size != -1) {
                                    out.write(buf, 0, size);
                                    size = in.read(buf);
                                }
                            }
                            success = true;
                        }
                        finally {
                            block37: {
                                try {
                                    out.close();
                                    if (success && captureChangeDetectionInfo && out instanceof DigestComputingOutputStream) {
                                        result = new ContentMeta(ContentHash.valueOf((byte[])((DigestComputingOutputStream)out).getFinalDigest()), ((DigestComputingOutputStream)out).getContentSize());
                                    }
                                }
                                catch (IOException e) {
                                    if (!success) break block37;
                                    success = false;
                                    throw e;
                                }
                            }
                        }
                    }
                    catch (ContentHashAlgorithmException e) {
                        throw new FileSystemException(NLS.bind((String)Messages.LocalFileStorage_0, (Object)this.getLocalPath(), (Object[])new Object[]{e.getMessage()}), e);
                    }
                    catch (IOException e) {
                        throw new FileSystemException(NLS.bind((String)Messages.LocalFileStorage_9, (Object)this.getLocalPath(), (Object[])new Object[]{e.getMessage()}), e);
                    }
                    catch (CoreException e) {
                        throw FileSystemStatusException.fromCoreException(NLS.bind((String)Messages.LocalFileStorage_9, (Object)this.getLocalPath(), (Object[])new Object[]{e.getMessage()}), e);
                    }
                }
                catch (Throwable throwable) {
                    block38: {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e) {
                                if (!success) break block38;
                                throw new FileSystemException(NLS.bind((String)Messages.LocalFileStorage_9, (Object)this.getLocalPath(), (Object[])new Object[]{e.getMessage()}), e);
                            }
                        }
                    }
                    throw throwable;
                }
                if (in == null) break block39;
                try {
                    in.close();
                }
                catch (IOException e) {
                    if (success) {
                        throw new FileSystemException(NLS.bind((String)Messages.LocalFileStorage_9, (Object)this.getLocalPath(), (Object[])new Object[]{e.getMessage()}), e);
                    }
                }
            }
            finally {
                progress.done();
            }
        }
        return result;
    }

    @Override
    public IRelativeLocation getIDEPath() {
        return this.getLocalPath();
    }

    @Override
    public String getActualName() {
        String[] potentialNames;
        if (this.getSandbox().isCaseSensitive()) {
            return this.file.getName();
        }
        IFileStore fs = this.getFileStore();
        if (fs.getFileSystem().attributes() > 0) {
            IFileInfo info = this.getFileStore().fetchInfo();
            return info.getName();
        }
        String expectedName = this.file.getName();
        File parent = this.file.getParentFile();
        if (parent != null && (potentialNames = parent.list()) != null) {
            String[] stringArray = potentialNames;
            int n = potentialNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (name.equals(expectedName)) {
                    return name;
                }
                if (name.equalsIgnoreCase(expectedName)) {
                    return name;
                }
                ++n2;
            }
        }
        return this.file.getName();
    }

    @Override
    public String getActualNameOnDisk(IProgressMonitor monitor) {
        return this.getActualName();
    }

    @Override
    public boolean isExecutable(IProgressMonitor monitor) throws FileSystemException {
        return this.file.canExecute();
    }

    @Override
    public boolean setExecutable(boolean exec, IProgressMonitor monitor) {
        return this.file.setExecutable(exec);
    }

    @Override
    public boolean supportsExecBit() {
        return FileStorage.PLATFORM_SUPPORTS_EXEC_BIT || (EFS.getLocalFileSystem().attributes() & 4) != 0;
    }

    @Override
    public void move(FileStorage targetStorage, IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)7);
        try {
            try {
                IFileStore parent;
                IFileStore managedFileStore = this.getFileStore();
                IFileStore targetFileStore = targetStorage.getFileStore();
                if (!this.file.canWrite()) {
                    this.setWritable(true, (IProgressMonitor)progress.newChild(1));
                }
                if ((parent = managedFileStore.getParent()) != null && parent.fetchInfo().getAttribute(2)) {
                    LocalFileStorage.setWritable(parent, true, (IProgressMonitor)progress.newChild(1));
                }
                try {
                    managedFileStore.move(targetStorage.getFileStore(), 0, (IProgressMonitor)progress.newChild(1));
                }
                catch (CoreException e) {
                    IFileStore targetParent = targetFileStore.getParent();
                    boolean retry = false;
                    if (targetParent != null && targetParent.fetchInfo().getAttribute(2)) {
                        retry = LocalFileStorage.setWritable(targetParent, true, (IProgressMonitor)progress.newChild(1));
                    }
                    if (retry) {
                        managedFileStore.move(targetFileStore, 0, (IProgressMonitor)progress.newChild(1));
                    }
                    throw FileSystemStatusException.fromCoreException(NLS.bind((String)Messages.LocalFileStorage_10, (Object)this.getLocalPath(), (Object[])new Object[]{targetStorage.getLocalPath(), e.getMessage()}), e);
                }
                targetStorage.refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)progress.newChild(1));
            }
            catch (CoreException e) {
                throw FileSystemStatusException.fromCoreException(NLS.bind((String)Messages.LocalFileStorage_10, (Object)this.getLocalPath(), (Object[])new Object[]{targetStorage.getLocalPath(), e.getMessage()}), e);
            }
        }
        finally {
            progress.done();
        }
    }

    @Override
    protected final IFileStore getFileStore() {
        ILocation sandboxRoot = this.getSandbox().getRoot();
        return new ManagedFileStore(sandboxRoot, this.getLocalPath(), EFS.getLocalFileSystem().getStore(this.path));
    }

    @Override
    public void delete(IProgressMonitor monitor) throws FileSystemException {
        block12: {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            Collection<IFileStorage> children = this.getChildren(true, (IProgressMonitor)progress.newChild(1));
            progress.setWorkRemaining(children.size() * 10 + 12);
            for (IFileStorage child : this.getChildren(true, monitor)) {
                child.delete((IProgressMonitor)progress.newChild(10));
            }
            try {
                try {
                    if (!this.storageExists((IProgressMonitor)progress.newChild(1))) break block12;
                    this.preserveHistory((IProgressMonitor)progress.newChild(1));
                    IFileStore fileStore = this.getFileStore();
                    try {
                        fileStore.delete(0, (IProgressMonitor)progress.newChild(10));
                    }
                    catch (CoreException e2) {
                        boolean retry = false;
                        IFileInfo info = fileStore.fetchInfo();
                        if (info.getAttribute(32) || info.exists()) {
                            IFileStore parent;
                            if (info.getAttribute(2)) {
                                retry = this.setWritable(true, (IProgressMonitor)progress.newChild(1));
                            }
                            if ((parent = fileStore.getParent()) != null && parent.fetchInfo().getAttribute(2)) {
                                boolean success = LocalFileStorage.setWritable(parent, true, (IProgressMonitor)progress.newChild(1));
                                boolean bl = retry = retry || success;
                            }
                        }
                        if (retry) {
                            fileStore.delete(0, (IProgressMonitor)progress.newChild(10));
                            break block12;
                        }
                        throw FileSystemStatusException.fromCoreException(NLS.bind((String)Messages.LocalFileStorage_6, (Object)this.file.getPath(), (Object[])new Object[]{e2.getMessage()}), e2);
                    }
                }
                catch (CoreException e) {
                    throw FileSystemStatusException.fromCoreException(NLS.bind((String)Messages.LocalFileStorage_6, (Object)this.file.getPath(), (Object[])new Object[]{e.getMessage()}), e);
                }
            }
            finally {
                progress.done();
            }
        }
    }

    @Override
    public boolean contains(ISchedulingRule rule) {
        if (this == rule) {
            return true;
        }
        if (rule instanceof MultiRule) {
            MultiRule multi = (MultiRule)rule;
            ISchedulingRule[] children = multi.getChildren();
            int i = 0;
            while (i < children.length) {
                if (!this.contains(children[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (!(rule instanceof IFileStorage)) {
            return false;
        }
        return this.getIDEPath().isPrefixOf(((IFileStorage)rule).getIDEPath());
    }

    @Override
    public boolean isConflicting(ISchedulingRule rule) {
        if (!(rule instanceof IFileStorage)) {
            return false;
        }
        ILocation otherPath = ((IFileStorage)rule).getShareable().getFullPath();
        ILocation fullPath = this.getStorage().getShareable().getFullPath();
        return fullPath.isPrefixOf(otherPath) || otherPath.isPrefixOf(fullPath);
    }

    public String toString() {
        return this.getIDEPath().toString();
    }

    @Override
    public void refreshCachedSubTree(int depth, IProgressMonitor monitor) throws FileSystemException {
    }

    @Override
    public Object getAdapter(Class adaptTo) {
        if (adaptTo.isAssignableFrom(File.class)) {
            return this.file;
        }
        return null;
    }

    @Override
    public void deregisterRepositoryProvider(IProgressMonitor monitor) throws FileSystemException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Collection<IFileStorage> children = this.getChildren(true, (IProgressMonitor)progress.newChild(1));
        if (children != null) {
            progress.setWorkRemaining(2 * children.size());
            for (IFileStorage child : children) {
                if (child.getResourceType((IProgressMonitor)progress.newChild(1)) != ResourceType.FOLDER) continue;
                child.deregisterRepositoryProvider((IProgressMonitor)progress.newChild(1));
            }
        }
    }

    @Override
    public void registerRepositorProvider(IProgressMonitor monitor) throws FileSystemException {
    }

    @Override
    public boolean isRepositoryProviderRegistered(IProgressMonitor monitor) throws FileSystemException {
        return false;
    }

    @Override
    public void preserveHistory(IProgressMonitor monitor) throws FileSystemException {
    }

    @Override
    public ISchedulingRule getResourceRuleForIDE(ISharingManager.RuleKind kind) {
        return null;
    }

    @Override
    public void backup(IBackupHandler shed, BackupDilemmaHandler dilemmaHandler, IProgressMonitor monitor) throws FileSystemException {
        shed.backupInShed(this.getStorage().getShareable(), monitor);
    }

    @Override
    public boolean storageExists(IProgressMonitor progress) throws FileSystemException {
        return this.getStorage().exists(progress);
    }

    @Override
    public boolean setWritable(boolean writable, IProgressMonitor progress) {
        IFileStore fileStorage = this.getFileStore();
        return LocalFileStorage.setWritable(fileStorage, writable, progress);
    }

    private static boolean setWritable(IFileStore fileToMakeWritable, boolean writable, IProgressMonitor progress) {
        boolean success;
        SubMonitor monitor;
        block11: {
            monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            if (fileToMakeWritable == null) {
                return false;
            }
            success = false;
            if ((fileToMakeWritable.getFileSystem().attributes() & 2) != 0) {
                SharingManager sm = SharingManager.getInstance();
                sm.disableChangeMonitoring();
                try {
                    try {
                        IFileInfo fileInfo = fileToMakeWritable.fetchInfo(0, (IProgressMonitor)monitor.newChild(10));
                        fileInfo.setAttribute(2, !writable);
                        fileToMakeWritable.putInfo(fileInfo, 0, (IProgressMonitor)monitor.newChild(10));
                        fileInfo = fileToMakeWritable.fetchInfo(0, (IProgressMonitor)monitor.newChild(10));
                        success = fileInfo.getAttribute(2) ^ writable;
                    }
                    catch (CoreException coreException) {
                        sm.enableChangeMonitoring();
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    sm.enableChangeMonitoring();
                    throw throwable;
                }
                sm.enableChangeMonitoring();
            }
        }
        if (!success) {
            try {
                File localFile = fileToMakeWritable.toLocalFile(0, (IProgressMonitor)monitor.newChild(10));
                if (localFile != null) {
                    success = localFile.setWritable(writable, true);
                }
            }
            catch (CoreException coreException) {}
        }
        return success;
    }

    @Override
    public boolean shouldBeIgnored(IProgressMonitor monitor) {
        return IgnoreManager.getInstance().shouldBeIgnored(this.getStorage().getShareable(), monitor);
    }
}

