/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IContentProperties;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileOptions;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.LocalFileStorage;
import com.ibm.team.filesystem.client.internal.MetadataProperties;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRLFInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToLFInputStream;
import com.ibm.team.internal.repository.rcp.streams.DigestComputingInputStream;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.ContentHashAlgorithmException;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public abstract class DeferredInformation {
    public static volatile boolean SKIP_MODIFICATION_STAMPS = true;
    private boolean contentTransferred;
    private ContentHash hash;
    private long contentSize;
    private Exception failure;
    private FileAreaUpdate fileAreaUpdate;
    private String alternateEncoding;
    private FileLineDelimiter alternateDelimiter;
    private Date existingShareableTimestamp;
    private boolean contentDeleted;

    public DeferredInformation(FileAreaUpdate update, Date existingShareableTimestamp) {
        this.fileAreaUpdate = update;
        this.contentTransferred = false;
        this.alternateEncoding = null;
        this.existingShareableTimestamp = existingShareableTimestamp;
    }

    public boolean contentUpdated() {
        return this.contentTransferred;
    }

    public boolean isExecutable() {
        return this.fileAreaUpdate.isExecutable();
    }

    public void setContentUpdated(ContentHash hash, long contentSize) {
        this.contentTransferred = true;
        this.hash = hash;
        this.contentSize = contentSize;
    }

    public IFileContent getContent() {
        return this.fileAreaUpdate.getOptionalContent();
    }

    public String getContentType() {
        return this.fileAreaUpdate.getContentType();
    }

    public MetadataProperties getMetadataProperties() {
        return new MetadataProperties(this.fileAreaUpdate.getMetadataProperties(), Collections.EMPTY_MAP, Collections.EMPTY_SET);
    }

    public String getRemoteName() {
        return this.fileAreaUpdate.getName();
    }

    public IFolderHandle getRemoteParent() {
        return this.fileAreaUpdate.getDestinationParent();
    }

    public IVersionableHandle getFileItemState() {
        return this.fileAreaUpdate.afterState();
    }

    public IComponentHandle getComponent() {
        return this.fileAreaUpdate.getComponent();
    }

    public Date getFileTimestamp() {
        return this.fileAreaUpdate.getFileTimestamp();
    }

    public Date getExistingShareableTimestamp() {
        return this.existingShareableTimestamp;
    }

    public ContentHash getHash() {
        return this.hash;
    }

    public long getContentSize() {
        return this.contentSize;
    }

    public void setFailure(Exception failureCause) {
        this.failure = failureCause;
        this.contentTransferred = false;
    }

    public Exception getFailure() {
        return this.failure;
    }

    public String getEncoding() {
        if (this.alternateEncoding == null) {
            return this.fileAreaUpdate.getOptionalContent().getCharacterEncoding();
        }
        return this.alternateEncoding;
    }

    public FileLineDelimiter getLineDelimiter() {
        if (this.alternateDelimiter == null) {
            return this.fileAreaUpdate.getOptionalContent().getLineDelimiter();
        }
        return this.alternateDelimiter;
    }

    public FileAreaUpdate getFileAreaUpdate() {
        return this.fileAreaUpdate;
    }

    public void setAlternateEncoding(String alternateEncoding) {
        this.alternateEncoding = alternateEncoding;
    }

    public void setAlternativeLineDelimiter(FileLineDelimiter lineDelimiter) {
        this.alternateDelimiter = lineDelimiter;
    }

    public boolean hasAlternateDownloadDirection() {
        return this.alternateDelimiter != null && this.fileAreaUpdate.getOptionalContent().getLineDelimiter() != this.alternateDelimiter || this.alternateEncoding != null && !this.alternateEncoding.equals(this.fileAreaUpdate.getOptionalContent().getCharacterEncoding());
    }

    public boolean isLineDelimiterIgnored() {
        return this.alternateDelimiter != null && this.fileAreaUpdate.getOptionalContent().getLineDelimiter() != this.alternateDelimiter && this.alternateDelimiter == FileLineDelimiter.LINE_DELIMITER_NONE;
    }

    public void reset() {
        this.failure = null;
        this.contentTransferred = false;
        this.hash = null;
        this.contentSize = 0L;
    }

    public void convert(IProgressMonitor progress) {
        block74: {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            if (!this.contentUpdated()) {
                return;
            }
            if (LocalFileStorage.getFileAccessExtension().transformsContents()) {
                return;
            }
            try {
                VerifyConvertToLFInputStream conversionStream;
                FileOptions options;
                InputStream tmpIn;
                InputStream fileIn;
                TemporaryOutputStream tmpOut;
                IFileStorage file;
                block75: {
                    block76: {
                        String encoding;
                        SharingManager.getInstance().disableChangeMonitoring();
                        IShareable shareable = this.getShareable();
                        ((Shareable)shareable).getFileStorage().refreshCachedSubTree(1, (IProgressMonitor)monitor.newChild(10));
                        IContentProperties contentProperties = SharingManager.getInstance().getContentExaminer(shareable).findStoredProperties(shareable, (IProgressMonitor)monitor.newChild(10));
                        FileLineDelimiter expectedLineDelimiter = this.fileAreaUpdate.getOptionalContent().getLineDelimiter();
                        if (expectedLineDelimiter.equals((Object)FileLineDelimiter.LINE_DELIMITER_PLATFORM)) {
                            expectedLineDelimiter = FileLineDelimiter.getPlatformDelimiter();
                        }
                        if ((encoding = contentProperties.getEncoding()).equals(this.fileAreaUpdate.getOptionalContent().getCharacterEncoding())) break block74;
                        file = ((Shareable)shareable).getFileStorage();
                        tmpOut = null;
                        fileIn = null;
                        tmpIn = null;
                        options = new FileOptions(false, this.fileAreaUpdate.getOptionalContent().getLineDelimiter(), this.fileAreaUpdate.getOptionalContent().getCharacterEncoding(), this.fileAreaUpdate.getMetadataProperties());
                        fileIn = file.getContents(options);
                        if (expectedLineDelimiter == FileLineDelimiter.LINE_DELIMITER_LF) {
                            conversionStream = new VerifyConvertToLFInputStream(fileIn, contentProperties.getEncoding());
                            break block75;
                        }
                        if (expectedLineDelimiter == FileLineDelimiter.LINE_DELIMITER_CRLF) {
                            conversionStream = new VerifyConvertToCRLFInputStream(fileIn, contentProperties.getEncoding());
                            break block75;
                        }
                        if (expectedLineDelimiter == FileLineDelimiter.LINE_DELIMITER_CR) {
                            conversionStream = new VerifyConvertToCRInputStream(fileIn, contentProperties.getEncoding());
                            break block75;
                        }
                        if (fileIn == null) break block76;
                        try {
                            fileIn.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (tmpIn != null) {
                        try {
                            tmpIn.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (tmpOut != null) {
                        try {
                            tmpOut.close();
                            tmpOut.dispose();
                        }
                        catch (IOException iOException) {}
                    }
                    return;
                }
                ReaderToInputStream in = new ReaderToInputStream((InputStreamReader)conversionStream);
                SubMonitor subProgress = monitor.newChild(40);
                int work = 1000;
                int worked = 0;
                long total = this.fileAreaUpdate.getOptionalContent().getEstimatedConvertedLength();
                long transferred = 0L;
                subProgress.setWorkRemaining(work);
                byte[] buffer = new byte[4096];
                tmpOut = TemporaryOutputStream.getTemporaryOutputStream((long)total);
                int numbytes = in.read(buffer);
                while (numbytes != -1) {
                    int newWorked = (int)((double)(transferred += (long)numbytes) / (double)total * (double)work);
                    subProgress.worked(newWorked - worked);
                    worked = newWorked;
                    tmpOut.write(buffer, 0, numbytes);
                    newWorked = (int)((double)(transferred += (long)numbytes) / (double)total * (double)work);
                    subProgress.worked(newWorked - worked);
                    worked = newWorked;
                    numbytes = in.read(buffer);
                }
                subProgress.done();
                fileIn.close();
                fileIn = null;
                tmpOut.close();
                tmpIn = tmpOut.getInputStream((IProgressMonitor)monitor.newChild(5));
                DigestComputingInputStream inStream = ContentHash.getDigestComputingStream((InputStream)tmpIn);
                try {
                    options = new FileOptions(true, this.fileAreaUpdate.getOptionalContent().getLineDelimiter(), this.fileAreaUpdate.getOptionalContent().getCharacterEncoding(), this.fileAreaUpdate.getMetadataProperties());
                    file.setContents(options, (InputStream)inStream, new Shed(null), (IProgressMonitor)monitor.newChild(35));
                    this.setContentUpdated(ContentHash.valueOf((byte[])inStream.getFinalDigest()), inStream.getContentSize());
                    this.alternateDelimiter = null;
                }
                catch (TeamRepositoryException e) {
                    this.setFailure((Exception)((Object)e));
                    if (fileIn != null) {
                        try {
                            fileIn.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (tmpIn != null) {
                        try {
                            tmpIn.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (tmpOut != null) {
                        try {
                            tmpOut.close();
                            tmpOut.dispose();
                        }
                        catch (IOException iOException) {}
                    }
                    SharingManager.getInstance().enableChangeMonitoring();
                    return;
                }
                try {
                    block78: {
                        try {
                            tmpIn.close();
                            tmpIn = null;
                            tmpOut.dispose();
                            tmpOut = null;
                        }
                        catch (IOException iOException) {
                            if (fileIn != null) {
                                try {
                                    fileIn.close();
                                }
                                catch (IOException iOException2) {}
                            }
                            if (tmpIn != null) {
                                try {
                                    tmpIn.close();
                                }
                                catch (IOException iOException3) {}
                            }
                            if (tmpOut != null) {
                                try {
                                    tmpOut.close();
                                    tmpOut.dispose();
                                }
                                catch (IOException iOException4) {}
                            }
                            break block74;
                        }
                        catch (ContentHashAlgorithmException contentHashAlgorithmException) {
                            block77: {
                                try {
                                    if (fileIn == null) break block77;
                                }
                                catch (Throwable throwable) {
                                    if (fileIn != null) {
                                        try {
                                            fileIn.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    if (tmpIn != null) {
                                        try {
                                            tmpIn.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    if (tmpOut != null) {
                                        try {
                                            tmpOut.close();
                                            tmpOut.dispose();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                    throw throwable;
                                }
                                try {
                                    fileIn.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (tmpIn != null) {
                                try {
                                    tmpIn.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (tmpOut != null) {
                                try {
                                    tmpOut.close();
                                    tmpOut.dispose();
                                }
                                catch (IOException iOException) {}
                            }
                            break block74;
                        }
                        if (fileIn == null) break block78;
                        try {
                            fileIn.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (tmpIn != null) {
                        try {
                            tmpIn.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (tmpOut == null) break block74;
                    try {
                        tmpOut.close();
                        tmpOut.dispose();
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (FileSystemException fileSystemException) {}
            }
            finally {
                SharingManager.getInstance().enableChangeMonitoring();
            }
        }
    }

    public abstract IShareable getShareable();

    void processModificationStamp(File localFile) {
        if (localFile == null) {
            return;
        }
        if (!SKIP_MODIFICATION_STAMPS) {
            Date timestamp = this.getFileTimestamp();
            Date now = new Date();
            if (timestamp.getTime() != -1L && now.after(timestamp) && (this.getExistingShareableTimestamp() == null || timestamp.after(this.getExistingShareableTimestamp()))) {
                localFile.setLastModified(timestamp.getTime());
            }
        }
    }

    public void setContentDeleted() {
        this.contentDeleted = true;
    }

    public boolean contentDeleted() {
        return this.contentDeleted;
    }
}

