/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.localchanges;

import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeContext;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeNode;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.osgi.util.NLS;

public abstract class LocalChange
implements ILocalChange {
    private boolean canceled;
    private boolean inTheWild;
    protected LocalChangeNode node;
    protected IVersionableHandle target;
    protected IFolderHandle targetParent;
    protected IRelativeLocation path;
    protected IRelativeLocation originalPath;
    protected LocalChangeContext context;

    public LocalChange(LocalChangeContext context, IRelativeLocation path, IRelativeLocation originalPath, IVersionableHandle target, IFolderHandle targetParent) {
        this.validateTarget(target);
        this.validateTargetParent(targetParent, context, path, originalPath);
        this.context = context;
        this.path = path;
        this.originalPath = originalPath;
        this.target = target;
        this.targetParent = targetParent;
    }

    protected void validateTarget(IVersionableHandle target) {
        Assert.isNotNull((Object)target);
        Assert.isTrue((!target.hasFullState() ? 1 : 0) != 0);
        this.validateTargetState(target);
    }

    protected void validateTargetParent(IFolderHandle targetParent, LocalChangeContext context, IRelativeLocation path, IRelativeLocation originalPath) {
        if (targetParent == null) {
            if (path == null) {
                path = originalPath;
            }
            if (path == null) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.LocalChange_TargetParentAndPathMissing, (Object)context.getRoot()));
            }
            throw new IllegalArgumentException(NLS.bind((String)Messages.LocalChange_TargetParentMissing, (Object)path.toString(), (Object)context.getRoot()));
        }
        Assert.isTrue((!targetParent.hasFullState() ? 1 : 0) != 0);
    }

    protected void validateTargetState(IVersionableHandle target) {
        Assert.isTrue((boolean)target.hasStateId());
    }

    final void cancel() {
        this.canceled = true;
        LocalChange counterpart = (LocalChange)this.getCounterpart();
        if (counterpart != null) {
            counterpart.canceled = true;
        }
    }

    final boolean isWild() {
        return this.inTheWild;
    }

    final void setWild() {
        this.inTheWild = true;
    }

    @Override
    public IComponentHandle getComponent() {
        return this.context == null ? null : this.context.getComponent();
    }

    @Override
    public ILocalChange getCounterpart() {
        return null;
    }

    final UUID getItemId() {
        return this.target == null ? null : this.target.getItemId();
    }

    LocalChangeNode getNode() {
        return this.node;
    }

    public final ILocation getCfaRoot() {
        return this.context.getRoot();
    }

    @Override
    public final IRelativeLocation getPath() {
        return this.path;
    }

    @Override
    public IRelativeLocation getResultingPath() {
        return this.path;
    }

    @Override
    public IRelativeLocation getOriginalPath() {
        return this.originalPath;
    }

    @Override
    public ILocation getSandboxRoot() {
        return this.context.getRoot();
    }

    @Override
    public IShareable getShareable() {
        return LocalChangeManager.getInstance().getShareable(this);
    }

    @Override
    public final IVersionableHandle getTarget() {
        return this.target;
    }

    @Override
    public IContextHandle getConnection() {
        return this.context == null ? null : this.context.getConnection();
    }

    @Override
    public final boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public boolean isType(int mask) {
        return (this.getType() & mask) == mask;
    }

    void setNode(LocalChangeNode node) {
        this.node = node;
    }

    public int hashCode() {
        int code = this.originalPath == null ? 0 : this.originalPath.hashCode();
        return this.target.getItemId().hashCode() ^ this.path.hashCode() ^ code ^ this.getType();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalChange)) {
            return false;
        }
        LocalChange other = (LocalChange)o;
        if (this.originalPath == null ? other.originalPath != null : !this.originalPath.equals(other.originalPath)) {
            return false;
        }
        return this.canceled == other.canceled && LocalChange.equals(this.target, other.target) && LocalChange.equals((IVersionableHandle)this.targetParent, (IVersionableHandle)other.targetParent) && this.path.equals(other.path) && this.getType() == other.getType() && this.context == other.context;
    }

    private static boolean equals(IVersionableHandle v1, IVersionableHandle v2) {
        if (v1 == v2) {
            return true;
        }
        if (v1 == null || v2 == null) {
            return false;
        }
        if (!v1.sameItemId((IItemHandle)v2)) {
            return false;
        }
        if (v1.hasStateId() != v2.hasStateId()) {
            return false;
        }
        return !v1.hasStateId() || v1.sameStateId((IItemHandle)v2);
    }

    public String toString() {
        return String.valueOf(this.getTypeString()) + " " + this.path + " " + this.getItemId();
    }

    private String getTypeString() {
        String typeString;
        switch (this.getType()) {
            case 2: {
                typeString = "ADDITION";
                break;
            }
            case 16: {
                typeString = "MOVE_FROM";
                break;
            }
            case 8: {
                typeString = "MOVE_TO";
                break;
            }
            case 17: {
                typeString = "MOVE_FROM (content)";
                break;
            }
            case 49: {
                typeString = "MOVE_FROM (content + attributes)";
                break;
            }
            case 48: {
                typeString = "MOVE_FROM (attributes)";
                break;
            }
            case 9: {
                typeString = "MOVE_TO (content)";
                break;
            }
            case 41: {
                typeString = "MOVE_TO (content + attributes)";
                break;
            }
            case 40: {
                typeString = "MOVE_TO (attributes)";
                break;
            }
            case 4: {
                typeString = "DELETION";
                break;
            }
            case 1: {
                typeString = "CONTENT";
                break;
            }
            case 33: {
                typeString = "CONTENT + ATTRIBUTES";
                break;
            }
            case 32: {
                typeString = "ATTRIBUTES";
                break;
            }
            case 0: {
                return "NO_CHANGE";
            }
            default: {
                typeString = "UNKNOWN(" + this.getType() + ")";
            }
        }
        if (this.isCanceled()) {
            typeString = String.valueOf(typeString) + " (canceled)";
        }
        return typeString;
    }

    @Override
    public IFolderHandle getTargetParent() {
        return this.targetParent;
    }
}

