/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.log;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Providers {
    private static final Logger logger = LoggerFactory.getLogger(Providers.class);
    private Map<MessageBodyReader<?>, Boolean> mbrs = null;
    private Map<MessageBodyWriter<?>, Boolean> mbws = null;

    public void addMessageBodyReader(MessageBodyReader<?> reader, boolean result) {
        if (this.mbrs == null) {
            this.mbrs = new LinkedHashMap();
        }
        this.mbrs.put(reader, result);
    }

    public void addMessageBodyWriter(MessageBodyWriter<?> writer, boolean result) {
        if (this.mbws == null) {
            this.mbws = new LinkedHashMap();
        }
        this.mbws.put(writer, result);
    }

    public void log() {
        if (logger.isDebugEnabled()) {
            String providerResults;
            if (this.mbrs != null && this.mbrs.size() > 0) {
                providerResults = "";
                for (MessageBodyReader messageBodyReader : this.mbrs.keySet()) {
                    providerResults = providerResults + "\n" + messageBodyReader.getClass().getCanonicalName() + ".isReadable() returned " + this.mbrs.get(messageBodyReader);
                }
                logger.debug(providerResults);
            }
            if (this.mbws != null && this.mbws.size() > 0) {
                providerResults = "";
                for (MessageBodyWriter messageBodyWriter : this.mbws.keySet()) {
                    providerResults = providerResults + "\n" + messageBodyWriter.getClass().getCanonicalName() + ".isWritable() returned " + this.mbws.get(messageBodyWriter);
                }
                logger.debug(providerResults);
            }
        }
    }
}

