/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.server.internal.registry;

import java.lang.reflect.InvocationTargetException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.registry.ContextAccessor;
import org.apache.wink.server.internal.contexts.HttpServletRequestWrapperImpl;
import org.apache.wink.server.internal.contexts.HttpServletResponseWrapperImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletContextAccessor
extends ContextAccessor {
    @Override
    public <T> T getContextFromAccessor(Class<T> contextClass, RuntimeContext runtimeContext) {
        if (runtimeContext != null) {
            try {
                return runtimeContext.getAttribute(contextClass);
            }
            catch (Exception e) {
                if (e instanceof InvocationTargetException) {
                    Throwable ite = ((InvocationTargetException)e).getTargetException();
                    if (ite instanceof RuntimeException) {
                        throw (RuntimeException)ite;
                    }
                    throw new WebApplicationException(ite);
                }
                throw new WebApplicationException(e);
            }
        }
        if (HttpServletRequest.class == contextClass) {
            return (T)((Object)new HttpServletRequestWrapperImpl());
        }
        if (HttpServletResponse.class == contextClass) {
            return (T)((Object)new HttpServletResponseWrapperImpl());
        }
        throw new IllegalArgumentException(Messages.getMessage("invalidServletContextAccessor", contextClass));
    }
}

